set(PhysX_PREFIX ${CMAKE_BINARY_DIR}/External/PhysX/src/physx)
set(PhysX_CMAKE_SCRIPT_DIR ${CMAKE_BINARY_DIR}/External/PhysX/src/physx/compiler/public)

set(PhysX_SHARED_PATH ${CMAKE_BINARY_DIR}/External/PhysX/src/pxshared)
set(PhysX_LIB_DIR ${CMAKE_BINARY_DIR}/lib)
set(PhysX_BIN_DIR ${CMAKE_BINARY_DIR}/bin)

set(PhysX_PREFIX_PATH CMAKE_PREFIX_PATH)
list(APPEND PhysX_PREFIX_PATH ${CMAKE_BINARY_DIR}/External/PhysX/src/externals/CMakeModules ${CMAKE_BINARY_DIR}/External/PhysX/src/externals/targa)
set(PhysX_CMAKEMODULES_PATH ${CMAKE_BINARY_DIR}/External/PhysX/src/externals/CMakeModules)

#-----------------------------------------------------------------------------
# Add External Project
#-----------------------------------------------------------------------------
include(imstkAddExternalProject)
imstk_add_external_project( PhysX
  GIT_REPOSITORY https://gitlab.kitware.com/iMSTK/PhysX.git
  GIT_TAG 4.1
  INSTALL_COMMAND ${SKIP_STEP_COMMAND}
  CMAKE_ARGS
	  ${PhysX_CMAKE_SCRIPT_DIR}
      -DPHYSX_ROOT_DIR=${PhysX_PREFIX} 
      -DPX_OUTPUT_LIB_DIR=${PhysX_PREFIX} 
      -DPX_OUTPUT_BIN_DIR=${PhysX_PREFIX} 
	  -DCMAKE_PREFIX_PATH=${PhysX_PREFIX_PATH}
	  -DCMAKEMODULES_PATH=${PhysX_CMAKEMODULES_PATH}#??
	  -DPM_CMakeModules_PATH=${PhysX_CMAKEMODULES_PATH}#??
	  -DPX_OUTPUT_LIB_DIR=${PhysX_LIB_DIR} 
	  -DPX_OUTPUT_BIN_DIR=${PhysX_BIN_DIR}
	  -DPXSHARED_PATH=${PhysX_SHARED_PATH}
      -DPX_BUILDSNIPPETS=TRUE 
      -DPX_BUILDPUBLICSAMPLES=TRUE 
      -DPX_GENERATE_STATIC_LIBRARIES=FALSE 
      -DNV_USE_STATIC_WINCRT=TRUE 
      -DNV_USE_DEBUG_WINCRT=TRUE 
      -DPX_FLOAT_POINT_PRECISE_MATH=FALSE  
      #-DCMAKE_INSTALL_PREFIX="D:/Dev/PhysX/PhysX/physx/install/vc15win64/PhysX"
  RELATIVE_INCLUDE_PATH ""
  #VERBOSE
  )