// This file is part of the SimMedTK project.
// Copyright (c) Center for Modeling, Simulation, and Imaging in Medicine,
//                        Rensselaer Polytechnic Institute
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//---------------------------------------------------------------------------
//
// Authors:
//
// Contact:
//---------------------------------------------------------------------------

#ifndef SM_LCP
#define SM_LCP

// SimMedTK includes
#include "Core/ContactHandling.h"
#include "Simulators/VegaFemSceneObject.h"

///
/// \brief Lcp based contact handling
///
class Lcp : public ContactHandling
{
public:
	///
	/// \brief constructor
	///
    Lcp(bool typeBilateral);

	///
	/// \brief Constructor
	///
    Lcp(bool typeBilateral,
        const std::shared_ptr<SceneObject>& sceneObjFirst,
        const std::shared_ptr<SceneObject>& sceneObjSecond);

	///
	/// \brief Destructor
	///
    virtual ~Lcp();

    ///
    /// \brief Setup the LCP
    ///
    void setupLcp();

    ///
    /// \brief resolve contacts
    ///
    void resolveContacts();

    ///
    /// \brief Get the coordinates of the local contact axis given the normal
    ///
    void get_Contact_Coord(core::Vec3f &n, core::Vec3f &t, core::Vec3f &theta);
};

#endif // SM_LCP