// This file is part of the SimMedTK project.
// Copyright (c) Center for Modeling, Simulation, and Imaging in Medicine,
//                        Rensselaer Polytechnic Institute
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//---------------------------------------------------------------------------
//
// Authors:
//
// Contact:
//---------------------------------------------------------------------------

#include "ContactHandling/Lcp.h"
#include "Core/CollisionPair.h"

Lcp::Lcp(bool typeBilateral) : ContactHandling(typeBilateral)
{

}

Lcp::Lcp(bool typeBilateral,
    const std::shared_ptr<SceneObject>& sceneObjFirst,
    const std::shared_ptr<SceneObject>& sceneObjSecond)
    : ContactHandling(typeBilateral, sceneObjFirst, sceneObjSecond)
{

}

Lcp::~Lcp()
{

}

void Lcp::setupLcp()
{

}

void Lcp::resolveContacts()
{

}

//void Lcp::get_Contact_Coord(core::Vec3f &n, core::Vec3f &t, core::Vec3f &theta)
//{
//
//    core::Vec3f tt;
//    if (n.y != 0){
//        tt.x = 0;
//        tt.z = 1 / sqrt((1 + n.z*n.z / (n.y*n.y)));
//        tt.y = -n.z*tt.z / n.y;
//    }
//    else if (n.z != 0){
//        tt.y = 0;
//        tt.x = 1 / sqrt((1 + n.x*n.x / (n.z*n.z)));
//        tt.z = -n.x*tt.x / n.z;
//    }
//    else if (n.x != 0){
//        tt.z = 0;
//        tt.y = 1 / sqrt((1 + n.y*n.y / (n.x*n.x)));
//        tt.x = -n.y*tt.y / n.x;
//    }
//    else{
//        std::cout << "Error: Normal is a null vector" << std::endl;
//        return;
//    }
//
//    t = tt;
//    theta = n.cross(tt);
//
//    t.normalize();
//    theta.normalize();
//
//    /*printf("%f\t%f\t%f\n",t.x,t.y,t.z);
//    printf("%f\t%f\t%f\n",theta.x,theta.y,theta.z);*/
//
//}