
#-----------------------------------------------------------------------------
# Find path
#-----------------------------------------------------------------------------
find_path(PhysX_INCLUDE_DIR
  NAMES
    PxPhysicsAPI.h
  )
mark_as_advanced(PhysX_INCLUDE_DIR)
list(APPEND PhysX_INCLUDE_DIRS ${PhysX_INCLUDE_DIR})

# NOTE: Include path in the <PhysX Root>\pxshared
find_path(PhysX_PxShared_INCLUDE_DIR
    NAMES
    foundation/Px.h
    )
mark_as_advanced(PhysX_PxShared_INCLUDE_DIR)
list(APPEND PhysX_INCLUDE_DIRS ${PhysX_PxShared_INCLUDE_DIR})

find_path(PhysX_LIB_PATH NAMES "")
mark_as_advanced(PhysX_LIB_PATH)

#-----------------------------------------------------------------------------
# Find PhysX libraries
#-----------------------------------------------------------------------------
if(CMAKE_SIZEOF_VOID_P EQUAL 8)
  set(bitness 64)
else()
  set(bitness 32)
endif()
  
macro(addPhysXLib libVarName PhysXLib)    
    find_library(${libVarName}_LIBRARY 
        NAMES 
            ${PhysXLib}_${bitness}                    
        HINTS
            ${PhysX_LIB_PATH})
    mark_as_advanced(${PhysXLib}_LIBRARY)    
    list(APPEND PhysX_LIBRARIES ${${libVarName}_LIBRARY})
endmacro()

# Add PhysX libraries
addPhysXLib(PhysX PhysX)
addPhysXLib(PhysX_Common PhysXCommon)
addPhysXLib(PhysX_Foundation PhysXFoundation)
addPhysXLib(PhysX_Cooking PhysXCooking)
addPhysXLib(PhysX_Extensions PhysXExtensions_static)
addPhysXLib(PhysX_SnippetUtils SnippetUtils_static)
addPhysXLib(PhysX_Pvd PhysXPvdSDK_static)

#-----------------------------------------------------------------------------
# Find package
#-----------------------------------------------------------------------------
include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(PhysX
  REQUIRED_VARS
    PhysX_INCLUDE_DIRS
    PhysX_LIBRARIES
)
