/**************************************************************************************
Copyright 2015 Applied Research Associates, Inc.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the License
at:
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software distributed under
the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
CONDITIONS OF ANY KIND, either express or implied. See the License for the
specific language governing permissions and limitations under the License.
**************************************************************************************/

package mil.tatrc.physiology.datamodel.substance.quantity;

import com.kitware.physiology.cdm.SubstanceQuantity.SubstanceQuantityData;

import mil.tatrc.physiology.datamodel.substance.SESubstance;

public abstract class SESubstanceQuantity 
{
  protected SESubstance           substance;
  
  public SESubstanceQuantity(SESubstance s)
  {
    substance=s;
  }
  public void reset()
  {
    
  }
  public static void load(SubstanceQuantityData src, SESubstanceQuantity dst)
  {
    dst.reset();
  }
  protected static void unload(SESubstanceQuantity src, SubstanceQuantityData.Builder dst)
  {
    if(src.substance!=null)
      dst.setSubstance(src.getSubstance().getName());
  }
  
  public SESubstance getSubstance()
  {
    return substance;
  }
}
