/**************************************************************************************
Copyright 2015 Applied Research Associates, Inc.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the License
at:
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software distributed under
the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
CONDITIONS OF ANY KIND, either express or implied. See the License for the
specific language governing permissions and limitations under the License.
**************************************************************************************/

package mil.tatrc.physiology.datamodel.patient.conditions;

import com.kitware.physiology.cdm.PatientConditions.ChronicVentricularSystolicDysfunctionData;

public class SEChronicVentricularSystolicDysfunction extends SEPatientCondition
{
  public SEChronicVentricularSystolicDysfunction()
  {
    
  }
  
  public void reset()
  {
    super.reset();
  }
  
  public void copy(SEChronicVentricularSystolicDysfunction other)
  {
    if(this==other)
      return;
    super.copy(other);    
  }
  
  public static void load(ChronicVentricularSystolicDysfunctionData src, SEChronicVentricularSystolicDysfunction dst) 
  {
    SEPatientCondition.load(src.getPatientCondition(), dst);
  }
  
  public static ChronicVentricularSystolicDysfunctionData unload(SEChronicVentricularSystolicDysfunction src) 
  {
    ChronicVentricularSystolicDysfunctionData.Builder dst = ChronicVentricularSystolicDysfunctionData.newBuilder();
    unload(src,dst);
    return dst.build();
  }
  
  protected static void unload(SEChronicVentricularSystolicDysfunction src, ChronicVentricularSystolicDysfunctionData.Builder dst)
  {
    SEPatientCondition.unload(src, dst.getPatientConditionBuilder());
  }
  
  public String toString()
  {
    return "Chronic Ventricular Systolic Dysfunction";
  }

  
}
