#ifndef __vtkPatchInterpolation_h
#define __vtkPatchInterpolation_h

#include "vtkObject.h"
#include "vtkFiltersBezierModule.h" // For EXPORT macro

class vtkDataArray;

/**\brief Provide methods to interpolate and evaluate Bezier patches.
  *
  */
class VTKFILTERSBEZIER_EXPORT vtkPatchInterpolation : public vtkObject
{
public:
  static vtkPatchInterpolation* New();
  vtkTypeMacro(vtkPatchInterpolation,vtkObject);
  virtual void PrintSelf(ostream& os, vtkIndent indent);

  void InterpolateOnPatch(
    vtkDataArray* outputPt,
    int dim, vtkDataArray* P_i, int* degree, double* r);

protected:
  vtkPatchInterpolation();
  virtual ~vtkPatchInterpolation();

  template<typename Iterator>
  void EvalCoord(
    Iterator data_iter, const Iterator data_end,
    const int& dim, const int* const degree, const double* const r,
    double* coord);
  template<typename T_i, typename T_d>
  void EvalBernstein(const T_i& n, const T_i& v, const T_d& x, T_d& b);

private:
  vtkPatchInterpolation(const vtkPatchInterpolation&); // Not implemented.
  void operator = (const vtkPatchInterpolation&); // Not implemented.
};

#endif // __vtkPatchInterpolation_h
