#include "vtkPatchInterpolation.h"
#include "vtkSmartPointer.h"
#include "vtkDoubleArray.h"
#include "vtkIndent.h"

#include "vtkMath.h"
#include "vtkTypeTraits.h"

#include <ctime>

int TestPatchInterpolation(int argc, char* argv[])
{
  vtkSmartPointer<vtkDoubleArray> test_array = vtkSmartPointer<vtkDoubleArray>::New();
  test_array->SetNumberOfComponents(4);
  test_array->InsertNextTuple4(0,0,0,1);
  test_array->InsertNextTuple4(1,0,2,1);
  test_array->InsertNextTuple4(1,1,0,1);
  test_array->InsertNextTuple4(0,1,1,1);

  double r[2] = {0.5, 0.5};
  int degree[2] = {1,1};

  vtkSmartPointer<vtkDoubleArray> output_array = vtkSmartPointer<vtkDoubleArray>::New();
  output_array->SetNumberOfComponents(4);
  
  vtkSmartPointer<vtkPatchInterpolation> test_class = vtkSmartPointer<vtkPatchInterpolation>::New();
  test_class->InterpolateOnPatch(output_array, 2, test_array, degree, r);

  vtkIndent indent(2);
  output_array->PrintSelf(std::cout, indent);


  return 0;
}
