/*=========================================================================

  Program:   Visualization Toolkit
  Module:    TestDisplaySizedImplicitPlaneWidget.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "vtkAppendPolyData.h"
#include "vtkClipPolyData.h"
#include "vtkCommand.h"
#include "vtkConeSource.h"
#include "vtkDisplaySizedImplicitPlaneRepresentation.h"
#include "vtkDisplaySizedImplicitPlaneWidget.h"
#include "vtkGlyph3D.h"
#include "vtkInteractorEventRecorder.h"
#include "vtkLODActor.h"
#include "vtkNew.h"
#include "vtkPlane.h"
#include "vtkPolyDataMapper.h"
#include "vtkProperty.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkRenderer.h"
#include "vtkSphereSource.h"

using Representation = vtkDisplaySizedImplicitPlaneRepresentation;
using Widget = vtkDisplaySizedImplicitPlaneWidget;

const char eventLog[] = "# StreamVersion 1.1\n"
                        "ExposeEvent 0 299 0 0 0 0\n"
                        "RenderEvent 0 299 0 0 0 0\n"
                        "EnterEvent 299 170 0 0 0 0\n"
                        "MouseMoveEvent 299 170 0 0 0 0\n"
                        "MouseMoveEvent 298 170 0 0 0 0\n"
                        "MouseMoveEvent 297 170 0 0 0 0\n"
                        "MouseMoveEvent 297 171 0 0 0 0\n"
                        "MouseMoveEvent 296 171 0 0 0 0\n"
                        "MouseMoveEvent 295 171 0 0 0 0\n"
                        "MouseMoveEvent 294 171 0 0 0 0\n"
                        "MouseMoveEvent 293 172 0 0 0 0\n"
                        "MouseMoveEvent 292 172 0 0 0 0\n"
                        "MouseMoveEvent 291 172 0 0 0 0\n"
                        "MouseMoveEvent 291 173 0 0 0 0\n"
                        "MouseMoveEvent 290 173 0 0 0 0\n"
                        "MouseMoveEvent 289 173 0 0 0 0\n"
                        "MouseMoveEvent 289 174 0 0 0 0\n"
                        "MouseMoveEvent 288 174 0 0 0 0\n"
                        "MouseMoveEvent 287 175 0 0 0 0\n"
                        "MouseMoveEvent 286 175 0 0 0 0\n"
                        "MouseMoveEvent 285 175 0 0 0 0\n"
                        "MouseMoveEvent 285 176 0 0 0 0\n"
                        "MouseMoveEvent 284 176 0 0 0 0\n"
                        "MouseMoveEvent 283 176 0 0 0 0\n"
                        "MouseMoveEvent 282 176 0 0 0 0\n"
                        "MouseMoveEvent 282 177 0 0 0 0\n"
                        "MouseMoveEvent 281 177 0 0 0 0\n"
                        "MouseMoveEvent 280 177 0 0 0 0\n"
                        "MouseMoveEvent 279 177 0 0 0 0\n"
                        "MouseMoveEvent 278 177 0 0 0 0\n"
                        "MouseMoveEvent 277 177 0 0 0 0\n"
                        "MouseMoveEvent 276 177 0 0 0 0\n"
                        "MouseMoveEvent 275 177 0 0 0 0\n"
                        "MouseMoveEvent 274 177 0 0 0 0\n"
                        "MouseMoveEvent 273 177 0 0 0 0\n"
                        "MouseMoveEvent 273 178 0 0 0 0\n"
                        "MouseMoveEvent 272 178 0 0 0 0\n"
                        "MouseMoveEvent 271 178 0 0 0 0\n"
                        "MouseMoveEvent 270 178 0 0 0 0\n"
                        "MouseMoveEvent 269 178 0 0 0 0\n"
                        "MouseMoveEvent 268 178 0 0 0 0\n"
                        "MouseMoveEvent 267 178 0 0 0 0\n"
                        "MouseMoveEvent 266 178 0 0 0 0\n"
                        "MouseMoveEvent 265 178 0 0 0 0\n"
                        "MouseMoveEvent 264 178 0 0 0 0\n"
                        "MouseMoveEvent 263 178 0 0 0 0\n"
                        "MouseMoveEvent 262 178 0 0 0 0\n"
                        "MouseMoveEvent 261 178 0 0 0 0\n"
                        "MouseMoveEvent 260 178 0 0 0 0\n"
                        "MouseMoveEvent 259 178 0 0 0 0\n"
                        "MouseMoveEvent 258 178 0 0 0 0\n"
                        "MouseMoveEvent 257 178 0 0 0 0\n"
                        "MouseMoveEvent 256 178 0 0 0 0\n"
                        "MouseMoveEvent 255 178 0 0 0 0\n"
                        "MouseMoveEvent 254 178 0 0 0 0\n"
                        "MouseMoveEvent 253 178 0 0 0 0\n"
                        "MouseMoveEvent 252 178 0 0 0 0\n"
                        "MouseMoveEvent 251 178 0 0 0 0\n"
                        "MouseMoveEvent 250 178 0 0 0 0\n"
                        "MouseMoveEvent 249 178 0 0 0 0\n"
                        "MouseMoveEvent 248 178 0 0 0 0\n"
                        "MouseMoveEvent 247 178 0 0 0 0\n"
                        "MouseMoveEvent 246 178 0 0 0 0\n"
                        "MouseMoveEvent 246 177 0 0 0 0\n"
                        "MouseMoveEvent 245 177 0 0 0 0\n"
                        "MouseMoveEvent 244 177 0 0 0 0\n"
                        "MouseMoveEvent 243 177 0 0 0 0\n"
                        "MouseMoveEvent 242 177 0 0 0 0\n"
                        "MouseMoveEvent 241 177 0 0 0 0\n"
                        "MouseMoveEvent 240 177 0 0 0 0\n"
                        "MouseMoveEvent 239 177 0 0 0 0\n"
                        "MouseMoveEvent 239 176 0 0 0 0\n"
                        "MouseMoveEvent 238 176 0 0 0 0\n"
                        "MouseMoveEvent 237 176 0 0 0 0\n"
                        "MouseMoveEvent 236 176 0 0 0 0\n"
                        "MouseMoveEvent 235 176 0 0 0 0\n"
                        "RenderEvent 235 176 0 0 0 0\n"
                        "MouseMoveEvent 235 176 0 0 0 0\n"
                        "MouseMoveEvent 234 176 0 0 0 0\n"
                        "LeftButtonPressEvent 234 176 0 0 0 0\n"
                        "RenderEvent 234 176 0 0 0 0\n"
                        "MouseMoveEvent 234 176 0 0 0 0\n"
                        "RenderEvent 234 176 0 0 0 0\n"
                        "MouseMoveEvent 233 176 0 0 0 0\n"
                        "RenderEvent 233 176 0 0 0 0\n"
                        "MouseMoveEvent 233 176 0 0 0 0\n"
                        "RenderEvent 233 176 0 0 0 0\n"
                        "MouseMoveEvent 232 175 0 0 0 0\n"
                        "RenderEvent 232 175 0 0 0 0\n"
                        "MouseMoveEvent 231 175 0 0 0 0\n"
                        "RenderEvent 231 175 0 0 0 0\n"
                        "MouseMoveEvent 230 175 0 0 0 0\n"
                        "RenderEvent 230 175 0 0 0 0\n"
                        "MouseMoveEvent 228 174 0 0 0 0\n"
                        "RenderEvent 228 174 0 0 0 0\n"
                        "MouseMoveEvent 227 174 0 0 0 0\n"
                        "RenderEvent 227 174 0 0 0 0\n"
                        "MouseMoveEvent 226 174 0 0 0 0\n"
                        "RenderEvent 226 174 0 0 0 0\n"
                        "MouseMoveEvent 225 174 0 0 0 0\n"
                        "RenderEvent 225 174 0 0 0 0\n"
                        "MouseMoveEvent 224 174 0 0 0 0\n"
                        "RenderEvent 224 174 0 0 0 0\n"
                        "MouseMoveEvent 223 173 0 0 0 0\n"
                        "RenderEvent 223 173 0 0 0 0\n"
                        "MouseMoveEvent 222 173 0 0 0 0\n"
                        "RenderEvent 222 173 0 0 0 0\n"
                        "MouseMoveEvent 221 173 0 0 0 0\n"
                        "RenderEvent 221 173 0 0 0 0\n"
                        "MouseMoveEvent 220 173 0 0 0 0\n"
                        "RenderEvent 220 173 0 0 0 0\n"
                        "MouseMoveEvent 218 172 0 0 0 0\n"
                        "RenderEvent 218 172 0 0 0 0\n"
                        "MouseMoveEvent 216 172 0 0 0 0\n"
                        "RenderEvent 216 172 0 0 0 0\n"
                        "MouseMoveEvent 215 172 0 0 0 0\n"
                        "RenderEvent 215 172 0 0 0 0\n"
                        "MouseMoveEvent 214 171 0 0 0 0\n"
                        "RenderEvent 214 171 0 0 0 0\n"
                        "MouseMoveEvent 213 171 0 0 0 0\n"
                        "RenderEvent 213 171 0 0 0 0\n"
                        "MouseMoveEvent 212 171 0 0 0 0\n"
                        "RenderEvent 212 171 0 0 0 0\n"
                        "MouseMoveEvent 211 171 0 0 0 0\n"
                        "RenderEvent 211 171 0 0 0 0\n"
                        "MouseMoveEvent 209 170 0 0 0 0\n"
                        "RenderEvent 209 170 0 0 0 0\n"
                        "MouseMoveEvent 207 170 0 0 0 0\n"
                        "RenderEvent 207 170 0 0 0 0\n"
                        "MouseMoveEvent 206 169 0 0 0 0\n"
                        "RenderEvent 206 169 0 0 0 0\n"
                        "MouseMoveEvent 204 169 0 0 0 0\n"
                        "RenderEvent 204 169 0 0 0 0\n"
                        "MouseMoveEvent 202 169 0 0 0 0\n"
                        "RenderEvent 202 169 0 0 0 0\n"
                        "MouseMoveEvent 201 168 0 0 0 0\n"
                        "RenderEvent 201 168 0 0 0 0\n"
                        "MouseMoveEvent 201 168 0 0 0 0\n"
                        "RenderEvent 201 168 0 0 0 0\n"
                        "MouseMoveEvent 200 168 0 0 0 0\n"
                        "RenderEvent 200 168 0 0 0 0\n"
                        "MouseMoveEvent 199 168 0 0 0 0\n"
                        "RenderEvent 199 168 0 0 0 0\n"
                        "MouseMoveEvent 198 167 0 0 0 0\n"
                        "RenderEvent 198 167 0 0 0 0\n"
                        "MouseMoveEvent 197 167 0 0 0 0\n"
                        "RenderEvent 197 167 0 0 0 0\n"
                        "MouseMoveEvent 196 167 0 0 0 0\n"
                        "RenderEvent 196 167 0 0 0 0\n"
                        "MouseMoveEvent 196 166 0 0 0 0\n"
                        "RenderEvent 196 166 0 0 0 0\n"
                        "MouseMoveEvent 194 166 0 0 0 0\n"
                        "RenderEvent 194 166 0 0 0 0\n"
                        "MouseMoveEvent 193 166 0 0 0 0\n"
                        "RenderEvent 193 166 0 0 0 0\n"
                        "MouseMoveEvent 191 165 0 0 0 0\n"
                        "RenderEvent 191 165 0 0 0 0\n"
                        "MouseMoveEvent 190 165 0 0 0 0\n"
                        "RenderEvent 190 165 0 0 0 0\n"
                        "MouseMoveEvent 188 164 0 0 0 0\n"
                        "RenderEvent 188 164 0 0 0 0\n"
                        "MouseMoveEvent 187 164 0 0 0 0\n"
                        "RenderEvent 187 164 0 0 0 0\n"
                        "MouseMoveEvent 187 164 0 0 0 0\n"
                        "RenderEvent 187 164 0 0 0 0\n"
                        "MouseMoveEvent 186 164 0 0 0 0\n"
                        "RenderEvent 186 164 0 0 0 0\n"
                        "MouseMoveEvent 186 164 0 0 0 0\n"
                        "RenderEvent 186 164 0 0 0 0\n"
                        "MouseMoveEvent 185 163 0 0 0 0\n"
                        "RenderEvent 185 163 0 0 0 0\n"
                        "MouseMoveEvent 185 163 0 0 0 0\n"
                        "RenderEvent 185 163 0 0 0 0\n"
                        "MouseMoveEvent 185 163 0 0 0 0\n"
                        "RenderEvent 185 163 0 0 0 0\n"
                        "MouseMoveEvent 185 163 0 0 0 0\n"
                        "RenderEvent 185 163 0 0 0 0\n"
                        "LeftButtonReleaseEvent 185 163 0 0 0 0\n"
                        "RenderEvent 185 163 0 0 0 0\n"
                        "MouseMoveEvent 185 163 0 0 0 0\n"
                        "RenderEvent 185 163 0 0 0 0\n"
                        "MouseMoveEvent 185 163 0 0 0 0\n"
                        "MouseMoveEvent 186 163 0 0 0 0\n"
                        "MouseMoveEvent 187 163 0 0 0 0\n"
                        "MouseMoveEvent 188 163 0 0 0 0\n"
                        "MouseMoveEvent 188 164 0 0 0 0\n"
                        "MouseMoveEvent 189 164 0 0 0 0\n"
                        "MouseMoveEvent 190 164 0 0 0 0\n"
                        "RenderEvent 190 164 0 0 0 0\n"
                        "MouseMoveEvent 191 164 0 0 0 0\n"
                        "MouseMoveEvent 192 164 0 0 0 0\n"
                        "MouseMoveEvent 193 164 0 0 0 0\n"
                        "MouseMoveEvent 193 165 0 0 0 0\n"
                        "MouseMoveEvent 194 165 0 0 0 0\n"
                        "MouseMoveEvent 195 165 0 0 0 0\n"
                        "MouseMoveEvent 196 165 0 0 0 0\n"
                        "MouseMoveEvent 197 165 0 0 0 0\n"
                        "MouseMoveEvent 198 165 0 0 0 0\n"
                        "MouseMoveEvent 199 165 0 0 0 0\n"
                        "MouseMoveEvent 200 165 0 0 0 0\n"
                        "MouseMoveEvent 201 165 0 0 0 0\n"
                        "MouseMoveEvent 202 165 0 0 0 0\n"
                        "MouseMoveEvent 203 165 0 0 0 0\n"
                        "MouseMoveEvent 204 165 0 0 0 0\n"
                        "MouseMoveEvent 205 165 0 0 0 0\n"
                        "MouseMoveEvent 206 166 0 0 0 0\n"
                        "MouseMoveEvent 207 166 0 0 0 0\n"
                        "MouseMoveEvent 208 166 0 0 0 0\n"
                        "MouseMoveEvent 209 166 0 0 0 0\n"
                        "MouseMoveEvent 210 166 0 0 0 0\n"
                        "MouseMoveEvent 211 166 0 0 0 0\n"
                        "MouseMoveEvent 212 166 0 0 0 0\n"
                        "MouseMoveEvent 213 166 0 0 0 0\n"
                        "MouseMoveEvent 214 166 0 0 0 0\n"
                        "MouseMoveEvent 215 166 0 0 0 0\n"
                        "MouseMoveEvent 216 166 0 0 0 0\n"
                        "MouseMoveEvent 217 166 0 0 0 0\n"
                        "MouseMoveEvent 218 166 0 0 0 0\n"
                        "MouseMoveEvent 219 166 0 0 0 0\n"
                        "MouseMoveEvent 220 166 0 0 0 0\n"
                        "MouseMoveEvent 221 166 0 0 0 0\n"
                        "MouseMoveEvent 222 166 0 0 0 0\n"
                        "MouseMoveEvent 223 166 0 0 0 0\n"
                        "MouseMoveEvent 224 166 0 0 0 0\n"
                        "MouseMoveEvent 225 166 0 0 0 0\n"
                        "MouseMoveEvent 225 165 0 0 0 0\n"
                        "MouseMoveEvent 226 165 0 0 0 0\n"
                        "MouseMoveEvent 227 165 0 0 0 0\n"
                        "MouseMoveEvent 228 164 0 0 0 0\n"
                        "MouseMoveEvent 229 164 0 0 0 0\n"
                        "MouseMoveEvent 230 164 0 0 0 0\n"
                        "MouseMoveEvent 230 163 0 0 0 0\n"
                        "MouseMoveEvent 231 163 0 0 0 0\n"
                        "MouseMoveEvent 232 162 0 0 0 0\n"
                        "MouseMoveEvent 233 162 0 0 0 0\n"
                        "MouseMoveEvent 233 161 0 0 0 0\n"
                        "MouseMoveEvent 234 161 0 0 0 0\n"
                        "MouseMoveEvent 235 161 0 0 0 0\n"
                        "MouseMoveEvent 235 160 0 0 0 0\n"
                        "MouseMoveEvent 236 160 0 0 0 0\n"
                        "MouseMoveEvent 236 159 0 0 0 0\n"
                        "MouseMoveEvent 237 159 0 0 0 0\n"
                        "MouseMoveEvent 238 159 0 0 0 0\n"
                        "MouseMoveEvent 238 158 0 0 0 0\n"
                        "MouseMoveEvent 239 158 0 0 0 0\n"
                        "MouseMoveEvent 240 158 0 0 0 0\n"
                        "MouseMoveEvent 240 157 0 0 0 0\n"
                        "MouseMoveEvent 241 157 0 0 0 0\n"
                        "MouseMoveEvent 241 156 0 0 0 0\n"
                        "MouseMoveEvent 242 156 0 0 0 0\n"
                        "MouseMoveEvent 243 156 0 0 0 0\n"
                        "MouseMoveEvent 243 155 0 0 0 0\n"
                        "MouseMoveEvent 244 155 0 0 0 0\n"
                        "MouseMoveEvent 245 155 0 0 0 0\n"
                        "MouseMoveEvent 246 155 0 0 0 0\n"
                        "MouseMoveEvent 247 155 0 0 0 0\n"
                        "MouseMoveEvent 248 155 0 0 0 0\n"
                        "MouseMoveEvent 249 155 0 0 0 0\n"
                        "MouseMoveEvent 250 155 0 0 0 0\n"
                        "MouseMoveEvent 251 155 0 0 0 0\n"
                        "MouseMoveEvent 252 155 0 0 0 0\n"
                        "MouseMoveEvent 253 155 0 0 0 0\n"
                        "MouseMoveEvent 254 155 0 0 0 0\n"
                        "MouseMoveEvent 255 155 0 0 0 0\n"
                        "MouseMoveEvent 256 155 0 0 0 0\n"
                        "MouseMoveEvent 257 155 0 0 0 0\n"
                        "MouseMoveEvent 258 155 0 0 0 0\n"
                        "MouseMoveEvent 259 155 0 0 0 0\n"
                        "MouseMoveEvent 260 155 0 0 0 0\n"
                        "MouseMoveEvent 261 155 0 0 0 0\n"
                        "MouseMoveEvent 262 155 0 0 0 0\n"
                        "MouseMoveEvent 263 155 0 0 0 0\n"
                        "MouseMoveEvent 264 155 0 0 0 0\n"
                        "MouseMoveEvent 265 155 0 0 0 0\n"
                        "MouseMoveEvent 265 156 0 0 0 0\n"
                        "LeftButtonPressEvent 265 156 0 0 0 0\n"
                        "StartInteractionEvent 265 156 0 0 0 0\n"
                        "MouseMoveEvent 265 155 0 0 0 0\n"
                        "InteractionEvent 265 155 0 0 0 0\n"
                        "MouseMoveEvent 265 155 0 0 0 0\n"
                        "InteractionEvent 265 155 0 0 0 0\n"
                        "TimerEvent 265 155 0 0 0 0\n"
                        "RenderEvent 265 155 0 0 0 0\n"
                        "TimerEvent 265 155 0 0 0 0\n"
                        "RenderEvent 265 155 0 0 0 0\n"
                        "TimerEvent 265 155 0 0 0 0\n"
                        "RenderEvent 265 155 0 0 0 0\n"
                        "TimerEvent 265 155 0 0 0 0\n"
                        "RenderEvent 265 155 0 0 0 0\n"
                        "TimerEvent 265 155 0 0 0 0\n"
                        "RenderEvent 265 155 0 0 0 0\n"
                        "MouseMoveEvent 266 155 0 0 0 0\n"
                        "InteractionEvent 266 155 0 0 0 0\n"
                        "TimerEvent 266 155 0 0 0 0\n"
                        "RenderEvent 266 155 0 0 0 0\n"
                        "MouseMoveEvent 267 154 0 0 0 0\n"
                        "InteractionEvent 267 154 0 0 0 0\n"
                        "TimerEvent 267 154 0 0 0 0\n"
                        "RenderEvent 267 154 0 0 0 0\n"
                        "MouseMoveEvent 270 152 0 0 0 0\n"
                        "InteractionEvent 270 152 0 0 0 0\n"
                        "TimerEvent 270 152 0 0 0 0\n"
                        "RenderEvent 270 152 0 0 0 0\n"
                        "LeftButtonReleaseEvent 269 152 0 0 0 0\n"
                        "EndInteractionEvent 269 152 0 0 0 0\n"
                        "RenderEvent 269 152 0 0 0 0\n"
                        "MouseMoveEvent 270 152 0 0 0 0\n"
                        "MouseMoveEvent 270 151 0 0 0 0\n"
                        "MouseMoveEvent 269 151 0 0 0 0\n"
                        "MouseMoveEvent 269 150 0 0 0 0\n"
                        "MouseMoveEvent 269 149 0 0 0 0\n"
                        "MouseMoveEvent 269 148 0 0 0 0\n"
                        "MouseMoveEvent 269 147 0 0 0 0\n"
                        "MouseMoveEvent 268 146 0 0 0 0\n"
                        "MouseMoveEvent 268 145 0 0 0 0\n"
                        "MouseMoveEvent 268 144 0 0 0 0\n"
                        "MouseMoveEvent 267 144 0 0 0 0\n"
                        "MouseMoveEvent 267 143 0 0 0 0\n"
                        "MouseMoveEvent 267 142 0 0 0 0\n"
                        "MouseMoveEvent 267 141 0 0 0 0\n"
                        "MouseMoveEvent 267 140 0 0 0 0\n"
                        "MouseMoveEvent 266 140 0 0 0 0\n"
                        "MouseMoveEvent 266 139 0 0 0 0\n"
                        "MouseMoveEvent 266 138 0 0 0 0\n"
                        "MouseMoveEvent 266 137 0 0 0 0\n"
                        "MouseMoveEvent 266 136 0 0 0 0\n"
                        "MouseMoveEvent 266 135 0 0 0 0\n"
                        "MouseMoveEvent 266 134 0 0 0 0\n"
                        "MouseMoveEvent 266 133 0 0 0 0\n"
                        "MouseMoveEvent 266 132 0 0 0 0\n"
                        "MouseMoveEvent 266 131 0 0 0 0\n"
                        "MouseMoveEvent 266 130 0 0 0 0\n"
                        "MouseMoveEvent 266 129 0 0 0 0\n"
                        "MouseMoveEvent 266 128 0 0 0 0\n"
                        "MouseMoveEvent 266 127 0 0 0 0\n"
                        "MouseMoveEvent 266 126 0 0 0 0\n"
                        "MouseMoveEvent 266 125 0 0 0 0\n"
                        "MouseMoveEvent 266 124 0 0 0 0\n"
                        "MouseMoveEvent 265 124 0 0 0 0\n"
                        "MouseMoveEvent 265 123 0 0 0 0\n"
                        "MouseMoveEvent 265 122 0 0 0 0\n"
                        "MouseMoveEvent 265 121 0 0 0 0\n"
                        "MouseMoveEvent 265 120 0 0 0 0\n"
                        "MouseMoveEvent 264 120 0 0 0 0\n"
                        "MouseMoveEvent 264 119 0 0 0 0\n"
                        "MouseMoveEvent 264 118 0 0 0 0\n"
                        "MouseMoveEvent 264 117 0 0 0 0\n"
                        "MouseMoveEvent 263 117 0 0 0 0\n"
                        "MouseMoveEvent 263 116 0 0 0 0\n"
                        "MouseMoveEvent 263 115 0 0 0 0\n"
                        "MouseMoveEvent 262 115 0 0 0 0\n"
                        "MouseMoveEvent 262 114 0 0 0 0\n"
                        "MouseMoveEvent 262 113 0 0 0 0\n"
                        "MouseMoveEvent 261 113 0 0 0 0\n"
                        "MouseMoveEvent 261 112 0 0 0 0\n"
                        "MouseMoveEvent 260 112 0 0 0 0\n"
                        "MouseMoveEvent 260 111 0 0 0 0\n"
                        "MouseMoveEvent 260 110 0 0 0 0\n"
                        "MouseMoveEvent 259 110 0 0 0 0\n"
                        "MouseMoveEvent 259 109 0 0 0 0\n"
                        "MouseMoveEvent 259 108 0 0 0 0\n"
                        "MouseMoveEvent 258 108 0 0 0 0\n"
                        "MouseMoveEvent 257 108 0 0 0 0\n"
                        "MouseMoveEvent 257 107 0 0 0 0\n"
                        "MouseMoveEvent 256 107 0 0 0 0\n"
                        "MouseMoveEvent 256 106 0 0 0 0\n"
                        "MouseMoveEvent 255 106 0 0 0 0\n"
                        "MouseMoveEvent 254 105 0 0 0 0\n"
                        "MouseMoveEvent 254 104 0 0 0 0\n"
                        "MouseMoveEvent 253 104 0 0 0 0\n"
                        "MouseMoveEvent 252 103 0 0 0 0\n"
                        "MouseMoveEvent 251 103 0 0 0 0\n"
                        "MouseMoveEvent 251 102 0 0 0 0\n"
                        "MouseMoveEvent 250 102 0 0 0 0\n"
                        "MouseMoveEvent 250 101 0 0 0 0\n"
                        "MouseMoveEvent 249 101 0 0 0 0\n"
                        "MouseMoveEvent 248 101 0 0 0 0\n"
                        "MouseMoveEvent 248 100 0 0 0 0\n"
                        "MouseMoveEvent 248 99 0 0 0 0\n"
                        "MouseMoveEvent 247 99 0 0 0 0\n"
                        "MouseMoveEvent 246 98 0 0 0 0\n"
                        "MouseMoveEvent 245 98 0 0 0 0\n"
                        "MouseMoveEvent 245 97 0 0 0 0\n"
                        "MouseMoveEvent 244 97 0 0 0 0\n"
                        "MouseMoveEvent 243 96 0 0 0 0\n"
                        "MouseMoveEvent 241 96 0 0 0 0\n"
                        "MouseMoveEvent 241 95 0 0 0 0\n"
                        "MouseMoveEvent 240 95 0 0 0 0\n"
                        "MouseMoveEvent 239 94 0 0 0 0\n"
                        "MouseMoveEvent 238 94 0 0 0 0\n"
                        "MouseMoveEvent 238 93 0 0 0 0\n"
                        "MouseMoveEvent 237 93 0 0 0 0\n"
                        "MouseMoveEvent 236 93 0 0 0 0\n"
                        "MouseMoveEvent 235 93 0 0 0 0\n"
                        "MouseMoveEvent 235 92 0 0 0 0\n"
                        "MouseMoveEvent 234 92 0 0 0 0\n"
                        "MouseMoveEvent 233 91 0 0 0 0\n"
                        "MouseMoveEvent 232 91 0 0 0 0\n"
                        "MouseMoveEvent 231 91 0 0 0 0\n"
                        "MouseMoveEvent 231 90 0 0 0 0\n"
                        "MouseMoveEvent 230 90 0 0 0 0\n"
                        "MouseMoveEvent 229 90 0 0 0 0\n"
                        "MouseMoveEvent 229 89 0 0 0 0\n"
                        "MouseMoveEvent 228 89 0 0 0 0\n"
                        "MouseMoveEvent 227 88 0 0 0 0\n"
                        "MouseMoveEvent 226 88 0 0 0 0\n"
                        "MouseMoveEvent 225 88 0 0 0 0\n"
                        "MouseMoveEvent 224 87 0 0 0 0\n"
                        "MouseMoveEvent 223 86 0 0 0 0\n"
                        "MouseMoveEvent 222 86 0 0 0 0\n"
                        "MouseMoveEvent 221 86 0 0 0 0\n"
                        "MouseMoveEvent 220 85 0 0 0 0\n"
                        "MouseMoveEvent 220 84 0 0 0 0\n"
                        "MouseMoveEvent 219 84 0 0 0 0\n"
                        "MouseMoveEvent 218 84 0 0 0 0\n"
                        "MouseMoveEvent 218 83 0 0 0 0\n"
                        "MouseMoveEvent 217 83 0 0 0 0\n"
                        "MouseMoveEvent 216 83 0 0 0 0\n"
                        "MouseMoveEvent 215 83 0 0 0 0\n"
                        "MouseMoveEvent 214 82 0 0 0 0\n"
                        "MouseMoveEvent 213 82 0 0 0 0\n"
                        "MouseMoveEvent 212 82 0 0 0 0\n"
                        "MouseMoveEvent 212 81 0 0 0 0\n"
                        "MouseMoveEvent 211 81 0 0 0 0\n"
                        "MouseMoveEvent 210 81 0 0 0 0\n"
                        "MouseMoveEvent 209 81 0 0 0 0\n"
                        "MouseMoveEvent 208 81 0 0 0 0\n"
                        "MouseMoveEvent 208 80 0 0 0 0\n"
                        "MouseMoveEvent 207 80 0 0 0 0\n"
                        "MouseMoveEvent 206 80 0 0 0 0\n"
                        "MouseMoveEvent 206 79 0 0 0 0\n"
                        "MouseMoveEvent 205 79 0 0 0 0\n"
                        "MouseMoveEvent 204 79 0 0 0 0\n"
                        "MouseMoveEvent 203 79 0 0 0 0\n"
                        "MouseMoveEvent 203 78 0 0 0 0\n"
                        "MouseMoveEvent 202 78 0 0 0 0\n"
                        "MouseMoveEvent 202 77 0 0 0 0\n"
                        "MouseMoveEvent 201 77 0 0 0 0\n"
                        "MouseMoveEvent 200 77 0 0 0 0\n"
                        "MouseMoveEvent 200 76 0 0 0 0\n"
                        "MouseMoveEvent 199 76 0 0 0 0\n"
                        "MouseMoveEvent 198 76 0 0 0 0\n"
                        "MouseMoveEvent 197 76 0 0 0 0\n"
                        "MouseMoveEvent 197 75 0 0 0 0\n"
                        "MouseMoveEvent 196 75 0 0 0 0\n"
                        "MouseMoveEvent 195 75 0 0 0 0\n"
                        "MouseMoveEvent 194 75 0 0 0 0\n"
                        "MouseMoveEvent 194 74 0 0 0 0\n"
                        "MouseMoveEvent 193 74 0 0 0 0\n"
                        "MouseMoveEvent 192 74 0 0 0 0\n"
                        "MouseMoveEvent 191 74 0 0 0 0\n"
                        "MouseMoveEvent 190 74 0 0 0 0\n"
                        "MouseMoveEvent 189 74 0 0 0 0\n"
                        "MouseMoveEvent 189 73 0 0 0 0\n"
                        "MouseMoveEvent 188 73 0 0 0 0\n"
                        "MouseMoveEvent 187 73 0 0 0 0\n"
                        "MouseMoveEvent 186 73 0 0 0 0\n"
                        "MouseMoveEvent 186 72 0 0 0 0\n"
                        "MouseMoveEvent 185 72 0 0 0 0\n"
                        "MouseMoveEvent 185 71 0 0 0 0\n"
                        "MouseMoveEvent 184 71 0 0 0 0\n"
                        "MouseMoveEvent 184 70 0 0 0 0\n"
                        "MouseMoveEvent 184 69 0 0 0 0\n"
                        "MouseMoveEvent 183 69 0 0 0 0\n"
                        "MouseMoveEvent 183 68 0 0 0 0\n"
                        "MouseMoveEvent 182 68 0 0 0 0\n"
                        "MouseMoveEvent 182 67 0 0 0 0\n"
                        "MouseMoveEvent 181 66 0 0 0 0\n"
                        "MouseMoveEvent 181 65 0 0 0 0\n"
                        "MouseMoveEvent 180 65 0 0 0 0\n"
                        "KeyPressEvent 180 65 0 111 1 o\n"
                        "RenderEvent 180 65 0 111 1 o\n"
                        "CharEvent 180 65 0 111 1 o\n"
                        "KeyReleaseEvent 180 65 0 111 1 o\n"
                        "MouseMoveEvent 180 65 0 0 0 o\n"
                        "RenderEvent 180 65 0 0 0 o\n"
                        "MouseMoveEvent 179 65 0 0 0 o\n"
                        "MouseMoveEvent 178 65 0 0 0 o\n"
                        "MouseMoveEvent 177 65 0 0 0 o\n"
                        "MouseMoveEvent 176 65 0 0 0 o\n"
                        "MouseMoveEvent 176 66 0 0 0 o\n"
                        "MouseMoveEvent 175 66 0 0 0 o\n"
                        "RenderEvent 175 66 0 0 0 o\n"
                        "MouseMoveEvent 175 66 0 0 0 o\n"
                        "MouseMoveEvent 174 66 0 0 0 o\n"
                        "MouseMoveEvent 173 66 0 0 0 o\n"
                        "MouseMoveEvent 173 67 0 0 0 o\n"
                        "MouseMoveEvent 172 67 0 0 0 o\n"
                        "MouseMoveEvent 171 67 0 0 0 o\n"
                        "MouseMoveEvent 170 67 0 0 0 o\n"
                        "MouseMoveEvent 169 67 0 0 0 o\n"
                        "RenderEvent 169 67 0 0 0 o\n"
                        "MouseMoveEvent 167 68 0 0 0 o\n"
                        "MouseMoveEvent 166 68 0 0 0 o\n"
                        "MouseMoveEvent 165 68 0 0 0 o\n"
                        "MouseMoveEvent 164 68 0 0 0 o\n"
                        "MouseMoveEvent 163 69 0 0 0 o\n"
                        "MouseMoveEvent 162 69 0 0 0 o\n"
                        "MouseMoveEvent 161 69 0 0 0 o\n"
                        "MouseMoveEvent 160 70 0 0 0 o\n"
                        "MouseMoveEvent 159 70 0 0 0 o\n"
                        "MouseMoveEvent 158 70 0 0 0 o\n"
                        "RenderEvent 158 70 0 0 0 o\n"
                        "MouseMoveEvent 157 70 0 0 0 o\n"
                        "MouseMoveEvent 156 70 0 0 0 o\n"
                        "MouseMoveEvent 156 71 0 0 0 o\n"
                        "MouseMoveEvent 155 71 0 0 0 o\n"
                        "MouseMoveEvent 155 72 0 0 0 o\n"
                        "MouseMoveEvent 154 72 0 0 0 o\n"
                        "MouseMoveEvent 153 72 0 0 0 o\n"
                        "MouseMoveEvent 152 72 0 0 0 o\n"
                        "MouseMoveEvent 152 73 0 0 0 o\n"
                        "MouseMoveEvent 151 73 0 0 0 o\n"
                        "MouseMoveEvent 150 73 0 0 0 o\n"
                        "MouseMoveEvent 150 74 0 0 0 o\n"
                        "MouseMoveEvent 150 75 0 0 0 o\n"
                        "MouseMoveEvent 149 75 0 0 0 o\n"
                        "MouseMoveEvent 149 76 0 0 0 o\n"
                        "MouseMoveEvent 148 76 0 0 0 o\n"
                        "MouseMoveEvent 148 77 0 0 0 o\n"
                        "MouseMoveEvent 147 77 0 0 0 o\n"
                        "MouseMoveEvent 147 78 0 0 0 o\n"
                        "MouseMoveEvent 147 79 0 0 0 o\n"
                        "MouseMoveEvent 146 79 0 0 0 o\n"
                        "MouseMoveEvent 146 80 0 0 0 o\n"
                        "MouseMoveEvent 146 81 0 0 0 o\n"
                        "MouseMoveEvent 145 81 0 0 0 o\n"
                        "MouseMoveEvent 145 82 0 0 0 o\n"
                        "MouseMoveEvent 145 83 0 0 0 o\n"
                        "MouseMoveEvent 145 84 0 0 0 o\n"
                        "MouseMoveEvent 144 84 0 0 0 o\n"
                        "MouseMoveEvent 144 85 0 0 0 o\n"
                        "MouseMoveEvent 144 86 0 0 0 o\n"
                        "MouseMoveEvent 143 86 0 0 0 o\n"
                        "MouseMoveEvent 143 87 0 0 0 o\n"
                        "MouseMoveEvent 143 88 0 0 0 o\n"
                        "MouseMoveEvent 142 88 0 0 0 o\n"
                        "MouseMoveEvent 142 89 0 0 0 o\n"
                        "MouseMoveEvent 142 90 0 0 0 o\n"
                        "MouseMoveEvent 142 91 0 0 0 o\n"
                        "MouseMoveEvent 141 91 0 0 0 o\n"
                        "MouseMoveEvent 141 92 0 0 0 o\n"
                        "MouseMoveEvent 141 93 0 0 0 o\n"
                        "MouseMoveEvent 141 94 0 0 0 o\n"
                        "MouseMoveEvent 141 95 0 0 0 o\n"
                        "MouseMoveEvent 141 96 0 0 0 o\n"
                        "MouseMoveEvent 140 96 0 0 0 o\n"
                        "MouseMoveEvent 140 97 0 0 0 o\n"
                        "MouseMoveEvent 140 98 0 0 0 o\n"
                        "MouseMoveEvent 140 99 0 0 0 o\n"
                        "MouseMoveEvent 140 100 0 0 0 o\n"
                        "MouseMoveEvent 140 101 0 0 0 o\n"
                        "MouseMoveEvent 139 101 0 0 0 o\n"
                        "MouseMoveEvent 139 102 0 0 0 o\n"
                        "MouseMoveEvent 139 103 0 0 0 o\n"
                        "MouseMoveEvent 139 104 0 0 0 o\n"
                        "MouseMoveEvent 139 105 0 0 0 o\n"
                        "MouseMoveEvent 138 105 0 0 0 o\n"
                        "MouseMoveEvent 138 106 0 0 0 o\n"
                        "MouseMoveEvent 138 107 0 0 0 o\n"
                        "MouseMoveEvent 138 108 0 0 0 o\n"
                        "MouseMoveEvent 138 109 0 0 0 o\n"
                        "MouseMoveEvent 138 110 0 0 0 o\n"
                        "MouseMoveEvent 137 110 0 0 0 o\n"
                        "MouseMoveEvent 137 111 0 0 0 o\n"
                        "MouseMoveEvent 137 112 0 0 0 o\n"
                        "MouseMoveEvent 137 113 0 0 0 o\n"
                        "MouseMoveEvent 137 114 0 0 0 o\n"
                        "MouseMoveEvent 137 115 0 0 0 o\n"
                        "MouseMoveEvent 137 116 0 0 0 o\n"
                        "MouseMoveEvent 138 116 0 0 0 o\n"
                        "MouseMoveEvent 138 117 0 0 0 o\n"
                        "MouseMoveEvent 139 117 0 0 0 o\n"
                        "KeyPressEvent 139 117 0 110 1 n\n"
                        "RenderEvent 139 117 0 110 1 n\n"
                        "CharEvent 139 117 0 110 1 n\n"
                        "KeyReleaseEvent 139 117 0 110 1 n\n"
                        "MouseMoveEvent 139 117 0 0 0 n\n"
                        "MouseMoveEvent 140 117 0 0 0 n\n"
                        "MouseMoveEvent 141 117 0 0 0 n\n"
                        "MouseMoveEvent 142 117 0 0 0 n\n"
                        "MouseMoveEvent 143 117 0 0 0 n\n"
                        "MouseMoveEvent 144 117 0 0 0 n\n"
                        "MouseMoveEvent 145 117 0 0 0 n\n"
                        "MouseMoveEvent 146 117 0 0 0 n\n"
                        "MouseMoveEvent 147 117 0 0 0 n\n"
                        "MouseMoveEvent 148 117 0 0 0 n\n"
                        "MouseMoveEvent 149 116 0 0 0 n\n"
                        "MouseMoveEvent 150 116 0 0 0 n\n"
                        "MouseMoveEvent 151 116 0 0 0 n\n"
                        "MouseMoveEvent 152 116 0 0 0 n\n"
                        "MouseMoveEvent 153 116 0 0 0 n\n"
                        "MouseMoveEvent 153 115 0 0 0 n\n"
                        "MouseMoveEvent 154 115 0 0 0 n\n"
                        "MouseMoveEvent 155 115 0 0 0 n\n"
                        "MouseMoveEvent 156 115 0 0 0 n\n"
                        "MouseMoveEvent 156 114 0 0 0 n\n"
                        "MouseMoveEvent 157 114 0 0 0 n\n"
                        "MouseMoveEvent 158 114 0 0 0 n\n"
                        "MouseMoveEvent 159 114 0 0 0 n\n"
                        "MouseMoveEvent 160 113 0 0 0 n\n"
                        "MouseMoveEvent 161 113 0 0 0 n\n"
                        "MouseMoveEvent 162 113 0 0 0 n\n"
                        "MouseMoveEvent 162 112 0 0 0 n\n"
                        "MouseMoveEvent 163 112 0 0 0 n\n"
                        "MouseMoveEvent 164 112 0 0 0 n\n"
                        "MouseMoveEvent 164 111 0 0 0 n\n"
                        "MouseMoveEvent 165 111 0 0 0 n\n"
                        "MouseMoveEvent 166 111 0 0 0 n\n"
                        "MouseMoveEvent 166 110 0 0 0 n\n"
                        "MouseMoveEvent 167 110 0 0 0 n\n"
                        "MouseMoveEvent 167 109 0 0 0 n\n"
                        "MouseMoveEvent 168 109 0 0 0 n\n"
                        "MouseMoveEvent 169 108 0 0 0 n\n"
                        "MouseMoveEvent 170 108 0 0 0 n\n"
                        "MouseMoveEvent 171 108 0 0 0 n\n"
                        "MouseMoveEvent 171 107 0 0 0 n\n"
                        "MouseMoveEvent 172 107 0 0 0 n\n"
                        "MouseMoveEvent 173 106 0 0 0 n\n"
                        "MouseMoveEvent 174 106 0 0 0 n\n"
                        "MouseMoveEvent 175 105 0 0 0 n\n"
                        "MouseMoveEvent 175 104 0 0 0 n\n"
                        "MouseMoveEvent 176 104 0 0 0 n\n"
                        "MouseMoveEvent 177 104 0 0 0 n\n"
                        "MouseMoveEvent 177 103 0 0 0 n\n"
                        "MouseMoveEvent 178 103 0 0 0 n\n"
                        "MouseMoveEvent 178 102 0 0 0 n\n"
                        "RenderEvent 178 102 0 0 0 n\n"
                        "MouseMoveEvent 179 101 0 0 0 n\n"
                        "MouseMoveEvent 180 101 0 0 0 n\n"
                        "MouseMoveEvent 181 100 0 0 0 n\n"
                        "MouseMoveEvent 182 99 0 0 0 n\n"
                        "MouseMoveEvent 182 98 0 0 0 n\n"
                        "MouseMoveEvent 183 98 0 0 0 n\n"
                        "MouseMoveEvent 183 97 0 0 0 n\n"
                        "MouseMoveEvent 184 97 0 0 0 n\n"
                        "MouseMoveEvent 184 96 0 0 0 n\n"
                        "MouseMoveEvent 185 96 0 0 0 n\n"
                        "MouseMoveEvent 185 95 0 0 0 n\n"
                        "MouseMoveEvent 186 94 0 0 0 n\n"
                        "MouseMoveEvent 186 93 0 0 0 n\n"
                        "MouseMoveEvent 187 93 0 0 0 n\n"
                        "MouseMoveEvent 187 92 0 0 0 n\n"
                        "MouseMoveEvent 188 91 0 0 0 n\n"
                        "MouseMoveEvent 189 91 0 0 0 n\n"
                        "MouseMoveEvent 189 90 0 0 0 n\n"
                        "MouseMoveEvent 189 89 0 0 0 n\n"
                        "MouseMoveEvent 190 89 0 0 0 n\n"
                        "MouseMoveEvent 190 88 0 0 0 n\n"
                        "MouseMoveEvent 191 87 0 0 0 n\n"
                        "MouseMoveEvent 192 86 0 0 0 n\n"
                        "MouseMoveEvent 192 85 0 0 0 n\n"
                        "MouseMoveEvent 193 85 0 0 0 n\n"
                        "MouseMoveEvent 193 84 0 0 0 n\n"
                        "MouseMoveEvent 194 84 0 0 0 n\n"
                        "MouseMoveEvent 193 84 0 0 0 n\n"
                        "MouseMoveEvent 194 84 0 0 0 n\n"
                        "MouseMoveEvent 194 83 0 0 0 n\n"
                        "MouseMoveEvent 194 82 0 0 0 n\n"
                        "MouseMoveEvent 195 82 0 0 0 n\n"
                        "MouseMoveEvent 195 81 0 0 0 n\n"
                        "MouseMoveEvent 195 80 0 0 0 n\n"
                        "RenderEvent 195 80 0 0 0 n\n"
                        "LeftButtonPressEvent 195 80 0 0 0 n\n"
                        "RenderEvent 195 80 0 0 0 n\n"
                        "MouseMoveEvent 195 80 0 0 0 n\n"
                        "RenderEvent 195 80 0 0 0 n\n"
                        "MouseMoveEvent 196 80 0 0 0 n\n"
                        "RenderEvent 196 80 0 0 0 n\n"
                        "MouseMoveEvent 197 80 0 0 0 n\n"
                        "RenderEvent 197 80 0 0 0 n\n"
                        "MouseMoveEvent 198 80 0 0 0 n\n"
                        "RenderEvent 198 80 0 0 0 n\n"
                        "MouseMoveEvent 201 81 0 0 0 n\n"
                        "RenderEvent 201 81 0 0 0 n\n"
                        "MouseMoveEvent 204 81 0 0 0 n\n"
                        "RenderEvent 204 81 0 0 0 n\n"
                        "MouseMoveEvent 208 81 0 0 0 n\n"
                        "RenderEvent 208 81 0 0 0 n\n"
                        "MouseMoveEvent 213 81 0 0 0 n\n"
                        "RenderEvent 213 81 0 0 0 n\n"
                        "MouseMoveEvent 218 81 0 0 0 n\n"
                        "RenderEvent 218 81 0 0 0 n\n"
                        "MouseMoveEvent 223 81 0 0 0 n\n"
                        "RenderEvent 223 81 0 0 0 n\n"
                        "MouseMoveEvent 228 82 0 0 0 n\n"
                        "RenderEvent 228 82 0 0 0 n\n"
                        "MouseMoveEvent 234 82 0 0 0 n\n"
                        "RenderEvent 234 82 0 0 0 n\n"
                        "MouseMoveEvent 238 82 0 0 0 n\n"
                        "RenderEvent 238 82 0 0 0 n\n"
                        "MouseMoveEvent 242 82 0 0 0 n\n"
                        "RenderEvent 242 82 0 0 0 n\n"
                        "MouseMoveEvent 244 82 0 0 0 n\n"
                        "RenderEvent 244 82 0 0 0 n\n"
                        "MouseMoveEvent 246 82 0 0 0 n\n"
                        "RenderEvent 246 82 0 0 0 n\n"
                        "MouseMoveEvent 249 82 0 0 0 n\n"
                        "RenderEvent 249 82 0 0 0 n\n"
                        "MouseMoveEvent 251 82 0 0 0 n\n"
                        "RenderEvent 251 82 0 0 0 n\n"
                        "MouseMoveEvent 251 82 0 0 0 n\n"
                        "RenderEvent 251 82 0 0 0 n\n"
                        "MouseMoveEvent 251 82 0 0 0 n\n"
                        "RenderEvent 251 82 0 0 0 n\n"
                        "MouseMoveEvent 252 82 0 0 0 n\n"
                        "RenderEvent 252 82 0 0 0 n\n"
                        "MouseMoveEvent 252 82 0 0 0 n\n"
                        "RenderEvent 252 82 0 0 0 n\n"
                        "MouseMoveEvent 252 82 0 0 0 n\n"
                        "RenderEvent 252 82 0 0 0 n\n"
                        "MouseMoveEvent 253 82 0 0 0 n\n"
                        "RenderEvent 253 82 0 0 0 n\n"
                        "MouseMoveEvent 253 82 0 0 0 n\n"
                        "RenderEvent 253 82 0 0 0 n\n"
                        "MouseMoveEvent 255 82 0 0 0 n\n"
                        "RenderEvent 255 82 0 0 0 n\n"
                        "MouseMoveEvent 256 83 0 0 0 n\n"
                        "RenderEvent 256 83 0 0 0 n\n"
                        "MouseMoveEvent 257 83 0 0 0 n\n"
                        "RenderEvent 257 83 0 0 0 n\n"
                        "MouseMoveEvent 258 83 0 0 0 n\n"
                        "RenderEvent 258 83 0 0 0 n\n"
                        "MouseMoveEvent 259 83 0 0 0 n\n"
                        "RenderEvent 259 83 0 0 0 n\n"
                        "MouseMoveEvent 259 83 0 0 0 n\n"
                        "RenderEvent 259 83 0 0 0 n\n"
                        "MouseMoveEvent 259 84 0 0 0 n\n"
                        "RenderEvent 259 84 0 0 0 n\n"
                        "MouseMoveEvent 261 84 0 0 0 n\n"
                        "RenderEvent 261 84 0 0 0 n\n"
                        "MouseMoveEvent 263 84 0 0 0 n\n"
                        "RenderEvent 263 84 0 0 0 n\n"
                        "MouseMoveEvent 266 84 0 0 0 n\n"
                        "RenderEvent 266 84 0 0 0 n\n"
                        "MouseMoveEvent 269 85 0 0 0 n\n"
                        "RenderEvent 269 85 0 0 0 n\n"
                        "MouseMoveEvent 272 86 0 0 0 n\n"
                        "RenderEvent 272 86 0 0 0 n\n"
                        "MouseMoveEvent 274 86 0 0 0 n\n"
                        "RenderEvent 274 86 0 0 0 n\n"
                        "MouseMoveEvent 277 87 0 0 0 n\n"
                        "RenderEvent 277 87 0 0 0 n\n"
                        "MouseMoveEvent 280 87 0 0 0 n\n"
                        "RenderEvent 280 87 0 0 0 n\n"
                        "MouseMoveEvent 282 88 0 0 0 n\n"
                        "RenderEvent 282 88 0 0 0 n\n"
                        "MouseMoveEvent 284 89 0 0 0 n\n"
                        "RenderEvent 284 89 0 0 0 n\n"
                        "MouseMoveEvent 286 89 0 0 0 n\n"
                        "RenderEvent 286 89 0 0 0 n\n"
                        "MouseMoveEvent 289 90 0 0 0 n\n"
                        "RenderEvent 289 90 0 0 0 n\n"
                        "MouseMoveEvent 291 90 0 0 0 n\n"
                        "RenderEvent 291 90 0 0 0 n\n"
                        "MouseMoveEvent 292 91 0 0 0 n\n"
                        "RenderEvent 292 91 0 0 0 n\n"
                        "MouseMoveEvent 293 91 0 0 0 n\n"
                        "RenderEvent 293 91 0 0 0 n\n"
                        "MouseMoveEvent 294 91 0 0 0 n\n"
                        "RenderEvent 294 91 0 0 0 n\n"
                        "MouseMoveEvent 294 91 0 0 0 n\n"
                        "RenderEvent 294 91 0 0 0 n\n"
                        "MouseMoveEvent 295 92 0 0 0 n\n"
                        "RenderEvent 295 92 0 0 0 n\n"
                        "MouseMoveEvent 296 92 0 0 0 n\n"
                        "RenderEvent 296 92 0 0 0 n\n"
                        "MouseMoveEvent 297 92 0 0 0 n\n"
                        "RenderEvent 297 92 0 0 0 n\n"
                        "MouseMoveEvent 297 92 0 0 0 n\n"
                        "RenderEvent 297 92 0 0 0 n\n"
                        "LeftButtonReleaseEvent 297 92 0 0 0 n\n"
                        "RenderEvent 297 92 0 0 0 n\n"
                        "MouseMoveEvent 297 92 0 0 0 n\n"
                        "MouseMoveEvent 296 92 0 0 0 n\n"
                        "MouseMoveEvent 295 92 0 0 0 n\n"
                        "MouseMoveEvent 294 92 0 0 0 n\n"
                        "MouseMoveEvent 293 92 0 0 0 n\n"
                        "MouseMoveEvent 292 92 0 0 0 n\n"
                        "MouseMoveEvent 291 92 0 0 0 n\n"
                        "MouseMoveEvent 290 92 0 0 0 n\n"
                        "MouseMoveEvent 289 92 0 0 0 n\n"
                        "MouseMoveEvent 288 92 0 0 0 n\n"
                        "MouseMoveEvent 287 92 0 0 0 n\n"
                        "MouseMoveEvent 286 92 0 0 0 n\n"
                        "MouseMoveEvent 285 92 0 0 0 n\n"
                        "MouseMoveEvent 284 92 0 0 0 n\n"
                        "MouseMoveEvent 283 92 0 0 0 n\n"
                        "MouseMoveEvent 282 92 0 0 0 n\n"
                        "MouseMoveEvent 281 92 0 0 0 n\n"
                        "MouseMoveEvent 280 92 0 0 0 n\n"
                        "MouseMoveEvent 279 92 0 0 0 n\n"
                        "MouseMoveEvent 278 92 0 0 0 n\n"
                        "MouseMoveEvent 277 92 0 0 0 n\n"
                        "MouseMoveEvent 276 92 0 0 0 n\n"
                        "MouseMoveEvent 276 91 0 0 0 n\n"
                        "MouseMoveEvent 275 91 0 0 0 n\n"
                        "MouseMoveEvent 274 91 0 0 0 n\n"
                        "MouseMoveEvent 273 91 0 0 0 n\n"
                        "MouseMoveEvent 272 91 0 0 0 n\n"
                        "MouseMoveEvent 271 91 0 0 0 n\n"
                        "MouseMoveEvent 270 91 0 0 0 n\n"
                        "MouseMoveEvent 269 91 0 0 0 n\n"
                        "MouseMoveEvent 268 91 0 0 0 n\n"
                        "MouseMoveEvent 267 91 0 0 0 n\n"
                        "MouseMoveEvent 266 91 0 0 0 n\n"
                        "MouseMoveEvent 265 91 0 0 0 n\n"
                        "RenderEvent 265 91 0 0 0 n\n"
                        "MouseMoveEvent 265 91 0 0 0 n\n"
                        "MouseMoveEvent 264 91 0 0 0 n\n"
                        "MouseMoveEvent 263 91 0 0 0 n\n"
                        "MouseMoveEvent 262 91 0 0 0 n\n"
                        "MouseMoveEvent 261 91 0 0 0 n\n"
                        "MouseMoveEvent 260 91 0 0 0 n\n"
                        "MouseMoveEvent 259 91 0 0 0 n\n"
                        "MouseMoveEvent 258 91 0 0 0 n\n"
                        "MouseMoveEvent 257 91 0 0 0 n\n"
                        "MouseMoveEvent 256 91 0 0 0 n\n"
                        "MouseMoveEvent 255 91 0 0 0 n\n"
                        "MouseMoveEvent 254 91 0 0 0 n\n"
                        "MouseMoveEvent 253 91 0 0 0 n\n"
                        "RenderEvent 253 91 0 0 0 n\n"
                        "MouseMoveEvent 253 91 0 0 0 n\n"
                        "MouseMoveEvent 252 91 0 0 0 n\n"
                        "MouseMoveEvent 251 91 0 0 0 n\n"
                        "MouseMoveEvent 250 91 0 0 0 n\n"
                        "MouseMoveEvent 249 91 0 0 0 n\n"
                        "MouseMoveEvent 248 91 0 0 0 n\n"
                        "MouseMoveEvent 247 91 0 0 0 n\n"
                        "MouseMoveEvent 246 91 0 0 0 n\n"
                        "MouseMoveEvent 245 91 0 0 0 n\n"
                        "MouseMoveEvent 244 91 0 0 0 n\n"
                        "MouseMoveEvent 243 91 0 0 0 n\n"
                        "MouseMoveEvent 242 91 0 0 0 n\n"
                        "MouseMoveEvent 241 91 0 0 0 n\n"
                        "MouseMoveEvent 240 91 0 0 0 n\n"
                        "MouseMoveEvent 239 91 0 0 0 n\n"
                        "RenderEvent 239 91 0 0 0 n\n"
                        "MouseMoveEvent 239 91 0 0 0 n\n"
                        "MouseMoveEvent 238 91 0 0 0 n\n"
                        "MouseMoveEvent 237 91 0 0 0 n\n"
                        "MouseMoveEvent 236 91 0 0 0 n\n"
                        "MouseMoveEvent 235 91 0 0 0 n\n"
                        "LeftButtonPressEvent 235 91 0 0 0 n\n"
                        "RenderEvent 235 91 0 0 0 n\n"
                        "MouseMoveEvent 235 92 0 0 0 n\n"
                        "RenderEvent 235 92 0 0 0 n\n"
                        "MouseMoveEvent 235 92 0 0 0 n\n"
                        "RenderEvent 235 92 0 0 0 n\n"
                        "MouseMoveEvent 234 93 0 0 0 n\n"
                        "RenderEvent 234 93 0 0 0 n\n"
                        "MouseMoveEvent 231 96 0 0 0 n\n"
                        "RenderEvent 231 96 0 0 0 n\n"
                        "MouseMoveEvent 227 100 0 0 0 n\n"
                        "RenderEvent 227 100 0 0 0 n\n"
                        "MouseMoveEvent 222 106 0 0 0 n\n"
                        "RenderEvent 222 106 0 0 0 n\n"
                        "MouseMoveEvent 216 111 0 0 0 n\n"
                        "RenderEvent 216 111 0 0 0 n\n"
                        "MouseMoveEvent 211 115 0 0 0 n\n"
                        "RenderEvent 211 115 0 0 0 n\n"
                        "MouseMoveEvent 207 119 0 0 0 n\n"
                        "RenderEvent 207 119 0 0 0 n\n"
                        "MouseMoveEvent 204 123 0 0 0 n\n"
                        "RenderEvent 204 123 0 0 0 n\n"
                        "MouseMoveEvent 200 126 0 0 0 n\n"
                        "RenderEvent 200 126 0 0 0 n\n"
                        "MouseMoveEvent 197 129 0 0 0 n\n"
                        "RenderEvent 197 129 0 0 0 n\n"
                        "MouseMoveEvent 195 132 0 0 0 n\n"
                        "RenderEvent 195 132 0 0 0 n\n"
                        "MouseMoveEvent 193 134 0 0 0 n\n"
                        "RenderEvent 193 134 0 0 0 n\n"
                        "MouseMoveEvent 192 135 0 0 0 n\n"
                        "RenderEvent 192 135 0 0 0 n\n"
                        "MouseMoveEvent 190 136 0 0 0 n\n"
                        "RenderEvent 190 136 0 0 0 n\n"
                        "MouseMoveEvent 188 138 0 0 0 n\n"
                        "RenderEvent 188 138 0 0 0 n\n"
                        "MouseMoveEvent 186 139 0 0 0 n\n"
                        "RenderEvent 186 139 0 0 0 n\n"
                        "MouseMoveEvent 186 139 0 0 0 n\n"
                        "RenderEvent 186 139 0 0 0 n\n"
                        "MouseMoveEvent 185 139 0 0 0 n\n"
                        "RenderEvent 185 139 0 0 0 n\n"
                        "MouseMoveEvent 185 140 0 0 0 n\n"
                        "RenderEvent 185 140 0 0 0 n\n"
                        "MouseMoveEvent 185 140 0 0 0 n\n"
                        "RenderEvent 185 140 0 0 0 n\n"
                        "LeftButtonReleaseEvent 185 140 0 0 0 n\n"
                        "RenderEvent 185 140 0 0 0 n\n"
                        "MouseMoveEvent 185 140 0 0 0 n\n"
                        "RenderEvent 185 140 0 0 0 n\n"
                        "MouseMoveEvent 185 140 0 0 0 n\n"
                        "MouseMoveEvent 186 140 0 0 0 n\n"
                        "MouseMoveEvent 187 140 0 0 0 n\n"
                        "MouseMoveEvent 188 140 0 0 0 n\n"
                        "MouseMoveEvent 189 140 0 0 0 n\n"
                        "MouseMoveEvent 190 140 0 0 0 n\n"
                        "MouseMoveEvent 191 140 0 0 0 n\n"
                        "MouseMoveEvent 192 140 0 0 0 n\n"
                        "MouseMoveEvent 193 140 0 0 0 n\n"
                        "MouseMoveEvent 194 139 0 0 0 n\n"
                        "MouseMoveEvent 195 139 0 0 0 n\n"
                        "MouseMoveEvent 196 139 0 0 0 n\n"
                        "MouseMoveEvent 197 139 0 0 0 n\n"
                        "MouseMoveEvent 198 139 0 0 0 n\n"
                        "MouseMoveEvent 199 139 0 0 0 n\n"
                        "MouseMoveEvent 200 138 0 0 0 n\n"
                        "MouseMoveEvent 201 138 0 0 0 n\n"
                        "MouseMoveEvent 202 138 0 0 0 n\n"
                        "MouseMoveEvent 203 138 0 0 0 n\n"
                        "MouseMoveEvent 203 137 0 0 0 n\n"
                        "MouseMoveEvent 204 137 0 0 0 n\n"
                        "MouseMoveEvent 205 137 0 0 0 n\n"
                        "MouseMoveEvent 206 137 0 0 0 n\n"
                        "MouseMoveEvent 207 137 0 0 0 n\n"
                        "MouseMoveEvent 208 137 0 0 0 n\n"
                        "MouseMoveEvent 208 136 0 0 0 n\n"
                        "MouseMoveEvent 209 136 0 0 0 n\n"
                        "MouseMoveEvent 210 136 0 0 0 n\n"
                        "MouseMoveEvent 211 136 0 0 0 n\n"
                        "MouseMoveEvent 211 135 0 0 0 n\n"
                        "MouseMoveEvent 212 135 0 0 0 n\n"
                        "MouseMoveEvent 213 135 0 0 0 n\n"
                        "MouseMoveEvent 214 135 0 0 0 n\n"
                        "MouseMoveEvent 215 135 0 0 0 n\n"
                        "MouseMoveEvent 216 135 0 0 0 n\n"
                        "MouseMoveEvent 216 134 0 0 0 n\n"
                        "MouseMoveEvent 217 134 0 0 0 n\n"
                        "MouseMoveEvent 218 134 0 0 0 n\n"
                        "MouseMoveEvent 219 134 0 0 0 n\n"
                        "RenderEvent 219 134 0 0 0 n\n"
                        "MouseMoveEvent 219 134 0 0 0 n\n"
                        "MouseMoveEvent 220 134 0 0 0 n\n"
                        "MouseMoveEvent 221 134 0 0 0 n\n"
                        "MouseMoveEvent 222 134 0 0 0 n\n"
                        "MouseMoveEvent 223 134 0 0 0 n\n"
                        "MouseMoveEvent 224 134 0 0 0 n\n"
                        "LeftButtonPressEvent 224 134 0 0 0 n\n"
                        "RenderEvent 224 134 0 0 0 n\n"
                        "MouseMoveEvent 224 134 0 0 0 n\n"
                        "RenderEvent 224 134 0 0 0 n\n"
                        "MouseMoveEvent 224 134 0 0 0 n\n"
                        "RenderEvent 224 134 0 0 0 n\n"
                        "MouseMoveEvent 224 134 0 0 0 n\n"
                        "RenderEvent 224 134 0 0 0 n\n"
                        "MouseMoveEvent 225 133 0 0 0 n\n"
                        "RenderEvent 225 133 0 0 0 n\n"
                        "MouseMoveEvent 226 132 0 0 0 n\n"
                        "RenderEvent 226 132 0 0 0 n\n"
                        "MouseMoveEvent 229 130 0 0 0 n\n"
                        "RenderEvent 229 130 0 0 0 n\n"
                        "MouseMoveEvent 234 127 0 0 0 n\n"
                        "RenderEvent 234 127 0 0 0 n\n"
                        "MouseMoveEvent 240 123 0 0 0 n\n"
                        "RenderEvent 240 123 0 0 0 n\n"
                        "MouseMoveEvent 246 119 0 0 0 n\n"
                        "RenderEvent 246 119 0 0 0 n\n"
                        "MouseMoveEvent 253 115 0 0 0 n\n"
                        "RenderEvent 253 115 0 0 0 n\n"
                        "MouseMoveEvent 259 111 0 0 0 n\n"
                        "RenderEvent 259 111 0 0 0 n\n"
                        "MouseMoveEvent 264 108 0 0 0 n\n"
                        "RenderEvent 264 108 0 0 0 n\n"
                        "MouseMoveEvent 267 106 0 0 0 n\n"
                        "RenderEvent 267 106 0 0 0 n\n"
                        "MouseMoveEvent 270 105 0 0 0 n\n"
                        "RenderEvent 270 105 0 0 0 n\n"
                        "MouseMoveEvent 271 103 0 0 0 n\n"
                        "RenderEvent 271 103 0 0 0 n\n"
                        "MouseMoveEvent 272 103 0 0 0 n\n"
                        "RenderEvent 272 103 0 0 0 n\n"
                        "MouseMoveEvent 273 102 0 0 0 n\n"
                        "RenderEvent 273 102 0 0 0 n\n"
                        "MouseMoveEvent 273 102 0 0 0 n\n"
                        "RenderEvent 273 102 0 0 0 n\n"
                        "MouseMoveEvent 274 101 0 0 0 n\n"
                        "RenderEvent 274 101 0 0 0 n\n"
                        "MouseMoveEvent 274 101 0 0 0 n\n"
                        "RenderEvent 274 101 0 0 0 n\n"
                        "MouseMoveEvent 274 101 0 0 0 n\n"
                        "RenderEvent 274 101 0 0 0 n\n"
                        "MouseMoveEvent 274 101 0 0 0 n\n"
                        "RenderEvent 274 101 0 0 0 n\n"
                        "MouseMoveEvent 274 101 0 0 0 n\n"
                        "RenderEvent 274 101 0 0 0 n\n"
                        "MouseMoveEvent 275 101 0 0 0 n\n"
                        "RenderEvent 275 101 0 0 0 n\n"
                        "MouseMoveEvent 275 101 0 0 0 n\n"
                        "RenderEvent 275 101 0 0 0 n\n"
                        "LeftButtonReleaseEvent 275 101 0 0 0 n\n"
                        "RenderEvent 275 101 0 0 0 n\n"
                        "MouseMoveEvent 275 101 0 0 0 n\n"
                        "MouseMoveEvent 274 101 0 0 0 n\n"
                        "MouseMoveEvent 273 101 0 0 0 n\n"
                        "MouseMoveEvent 272 101 0 0 0 n\n"
                        "RenderEvent 272 101 0 0 0 n\n"
                        "MouseMoveEvent 272 100 0 0 0 n\n"
                        "MouseMoveEvent 271 100 0 0 0 n\n"
                        "MouseMoveEvent 270 100 0 0 0 n\n"
                        "MouseMoveEvent 269 100 0 0 0 n\n"
                        "MouseMoveEvent 268 100 0 0 0 n\n"
                        "MouseMoveEvent 267 100 0 0 0 n\n"
                        "MouseMoveEvent 266 100 0 0 0 n\n"
                        "MouseMoveEvent 265 100 0 0 0 n\n"
                        "MouseMoveEvent 264 99 0 0 0 n\n"
                        "MouseMoveEvent 263 99 0 0 0 n\n"
                        "MouseMoveEvent 262 99 0 0 0 n\n"
                        "MouseMoveEvent 261 99 0 0 0 n\n"
                        "MouseMoveEvent 260 98 0 0 0 n\n"
                        "MouseMoveEvent 259 98 0 0 0 n\n"
                        "RenderEvent 259 98 0 0 0 n\n"
                        "MouseMoveEvent 258 98 0 0 0 n\n"
                        "MouseMoveEvent 257 97 0 0 0 n\n"
                        "MouseMoveEvent 256 97 0 0 0 n\n"
                        "MouseMoveEvent 255 97 0 0 0 n\n"
                        "MouseMoveEvent 254 97 0 0 0 n\n"
                        "MouseMoveEvent 254 96 0 0 0 n\n"
                        "MouseWheelBackwardEvent 254 96 0 0 0 n\n"
                        "StartInteractionEvent 254 96 0 0 0 n\n"
                        "RenderEvent 254 96 0 0 0 n\n"
                        "EndInteractionEvent 254 96 0 0 0 n\n"
                        "RenderEvent 254 96 0 0 0 n\n"
                        "MouseMoveEvent 254 96 0 0 0 n\n"
                        "RenderEvent 254 96 0 0 0 n\n"
                        "MouseMoveEvent 254 96 0 0 0 n\n"
                        "MouseWheelBackwardEvent 254 96 0 0 0 n\n"
                        "StartInteractionEvent 254 96 0 0 0 n\n"
                        "RenderEvent 254 96 0 0 0 n\n"
                        "EndInteractionEvent 254 96 0 0 0 n\n"
                        "RenderEvent 254 96 0 0 0 n\n"
                        "MouseMoveEvent 254 96 0 0 0 n\n"
                        "MouseMoveEvent 255 96 0 0 0 n\n"
                        "MouseWheelBackwardEvent 255 96 0 0 0 n\n"
                        "StartInteractionEvent 255 96 0 0 0 n\n"
                        "RenderEvent 255 96 0 0 0 n\n"
                        "EndInteractionEvent 255 96 0 0 0 n\n"
                        "RenderEvent 255 96 0 0 0 n\n"
                        "MouseMoveEvent 255 96 0 0 0 n\n"
                        "RenderEvent 255 96 0 0 0 n\n"
                        "MouseMoveEvent 255 96 0 0 0 n\n"
                        "MouseMoveEvent 256 96 0 0 0 n\n"
                        "MouseMoveEvent 257 96 0 0 0 n\n"
                        "MouseMoveEvent 258 96 0 0 0 n\n"
                        "MouseMoveEvent 259 96 0 0 0 n\n"
                        "MouseMoveEvent 260 96 0 0 0 n\n"
                        "MouseMoveEvent 261 96 0 0 0 n\n"
                        "MouseMoveEvent 261 97 0 0 0 n\n"
                        "MouseMoveEvent 262 97 0 0 0 n\n"
                        "MouseMoveEvent 263 97 0 0 0 n\n"
                        "MouseMoveEvent 264 97 0 0 0 n\n"
                        "MouseMoveEvent 265 97 0 0 0 n\n"
                        "MouseMoveEvent 266 97 0 0 0 n\n"
                        "MouseMoveEvent 267 98 0 0 0 n\n"
                        "MouseMoveEvent 268 98 0 0 0 n\n"
                        "MouseMoveEvent 269 98 0 0 0 n\n"
                        "MouseMoveEvent 270 99 0 0 0 n\n"
                        "MouseMoveEvent 271 99 0 0 0 n\n"
                        "MouseMoveEvent 272 100 0 0 0 n\n"
                        "MouseMoveEvent 273 100 0 0 0 n\n"
                        "MouseMoveEvent 274 101 0 0 0 n\n"
                        "MouseMoveEvent 275 102 0 0 0 n\n"
                        "MouseMoveEvent 276 103 0 0 0 n\n"
                        "MouseMoveEvent 276 104 0 0 0 n\n"
                        "MouseMoveEvent 277 105 0 0 0 n\n"
                        "MouseMoveEvent 277 106 0 0 0 n\n"
                        "MouseMoveEvent 278 106 0 0 0 n\n"
                        "MouseMoveEvent 278 107 0 0 0 n\n"
                        "MouseMoveEvent 278 108 0 0 0 n\n"
                        "MouseMoveEvent 279 110 0 0 0 n\n"
                        "MouseMoveEvent 280 110 0 0 0 n\n"
                        "MouseMoveEvent 280 112 0 0 0 n\n"
                        "MouseMoveEvent 281 113 0 0 0 n\n"
                        "MouseMoveEvent 282 114 0 0 0 n\n"
                        "MouseMoveEvent 282 115 0 0 0 n\n"
                        "MouseMoveEvent 283 116 0 0 0 n\n"
                        "MouseMoveEvent 283 117 0 0 0 n\n"
                        "MouseMoveEvent 283 118 0 0 0 n\n"
                        "MouseMoveEvent 284 119 0 0 0 n\n"
                        "MouseMoveEvent 285 120 0 0 0 n\n"
                        "MouseMoveEvent 285 122 0 0 0 n\n"
                        "MouseMoveEvent 286 123 0 0 0 n\n"
                        "MouseMoveEvent 286 124 0 0 0 n\n"
                        "MouseMoveEvent 287 125 0 0 0 n\n"
                        "MouseMoveEvent 287 126 0 0 0 n\n"
                        "MouseMoveEvent 288 127 0 0 0 n\n"
                        "MouseMoveEvent 288 128 0 0 0 n\n"
                        "MouseMoveEvent 288 129 0 0 0 n\n"
                        "MouseMoveEvent 289 131 0 0 0 n\n"
                        "MouseMoveEvent 289 132 0 0 0 n\n"
                        "MouseMoveEvent 289 133 0 0 0 n\n"
                        "MouseMoveEvent 290 134 0 0 0 n\n"
                        "MouseMoveEvent 291 135 0 0 0 n\n"
                        "MouseMoveEvent 291 136 0 0 0 n\n"
                        "MouseMoveEvent 291 137 0 0 0 n\n"
                        "MouseMoveEvent 292 138 0 0 0 n\n"
                        "MouseMoveEvent 292 140 0 0 0 n\n"
                        "MouseMoveEvent 292 141 0 0 0 n\n"
                        "MouseMoveEvent 292 142 0 0 0 n\n"
                        "MouseMoveEvent 293 143 0 0 0 n\n"
                        "MouseMoveEvent 293 144 0 0 0 n\n"
                        "MouseMoveEvent 293 145 0 0 0 n\n"
                        "MouseMoveEvent 293 147 0 0 0 n\n"
                        "MouseMoveEvent 294 147 0 0 0 n\n"
                        "MouseMoveEvent 294 149 0 0 0 n\n"
                        "MouseMoveEvent 294 150 0 0 0 n\n"
                        "MouseMoveEvent 295 151 0 0 0 n\n"
                        "MouseMoveEvent 295 152 0 0 0 n\n"
                        "MouseMoveEvent 295 154 0 0 0 n\n"
                        "MouseMoveEvent 296 156 0 0 0 n\n"
                        "MouseMoveEvent 296 157 0 0 0 n\n"
                        "MouseMoveEvent 296 158 0 0 0 n\n"
                        "MouseMoveEvent 297 159 0 0 0 n\n"
                        "MouseMoveEvent 297 161 0 0 0 n\n"
                        "MouseMoveEvent 297 163 0 0 0 n\n"
                        "MouseMoveEvent 297 164 0 0 0 n\n"
                        "MouseMoveEvent 297 165 0 0 0 n\n"
                        "MouseMoveEvent 298 166 0 0 0 n\n"
                        "MouseMoveEvent 298 167 0 0 0 n\n"
                        "MouseMoveEvent 298 168 0 0 0 n\n"
                        "MouseMoveEvent 298 169 0 0 0 n\n"
                        "MouseMoveEvent 299 171 0 0 0 n\n"
                        "MouseMoveEvent 299 172 0 0 0 n\n"
                        "MouseMoveEvent 299 173 0 0 0 n\n"
                        "MouseMoveEvent 299 176 0 0 0 n\n"
                        "MouseMoveEvent 299 177 0 0 0 n\n"
                        "LeaveEvent 300 178 0 0 0 n\n"
                        "EnterEvent 299 226 0 0 0 n\n"
                        "MouseMoveEvent 299 226 0 0 0 n\n"
                        "MouseMoveEvent 299 227 0 0 0 n\n"
                        "MouseMoveEvent 299 228 0 0 0 n\n"
                        "MouseMoveEvent 299 229 0 0 0 n\n"
                        "MouseMoveEvent 299 230 0 0 0 n\n"
                        "MouseMoveEvent 299 231 0 0 0 n\n"
                        "MouseMoveEvent 298 232 0 0 0 n\n"
                        "MouseMoveEvent 298 233 0 0 0 n\n"
                        "MouseMoveEvent 298 234 0 0 0 n\n"
                        "MouseMoveEvent 297 235 0 0 0 n\n"
                        "MouseMoveEvent 297 236 0 0 0 n\n"
                        "MouseMoveEvent 297 237 0 0 0 n\n"
                        "MouseMoveEvent 297 238 0 0 0 n\n"
                        "MouseMoveEvent 297 239 0 0 0 n\n"
                        "MouseMoveEvent 296 240 0 0 0 n\n"
                        "MouseMoveEvent 296 241 0 0 0 n\n"
                        "MouseMoveEvent 296 242 0 0 0 n\n"
                        "MouseMoveEvent 296 243 0 0 0 n\n"
                        "MouseMoveEvent 296 244 0 0 0 n\n"
                        "MouseMoveEvent 296 245 0 0 0 n\n"
                        "MouseMoveEvent 295 246 0 0 0 n\n"
                        "MouseMoveEvent 295 247 0 0 0 n\n"
                        "MouseMoveEvent 295 248 0 0 0 n\n"
                        "MouseMoveEvent 295 249 0 0 0 n\n"
                        "MouseMoveEvent 294 249 0 0 0 n\n"
                        "MouseMoveEvent 294 250 0 0 0 n\n"
                        "MouseMoveEvent 294 251 0 0 0 n\n"
                        "MouseMoveEvent 294 252 0 0 0 n\n"
                        "MouseMoveEvent 294 253 0 0 0 n\n"
                        "MouseMoveEvent 294 254 0 0 0 n\n"
                        "MouseMoveEvent 294 255 0 0 0 n\n"
                        "MouseMoveEvent 294 256 0 0 0 n\n"
                        "MouseMoveEvent 293 256 0 0 0 n\n"
                        "MouseMoveEvent 293 257 0 0 0 n\n"
                        "MouseMoveEvent 293 258 0 0 0 n\n"
                        "MouseMoveEvent 293 259 0 0 0 n\n"
                        "MouseMoveEvent 293 260 0 0 0 n\n"
                        "MouseMoveEvent 292 260 0 0 0 n\n"
                        "MouseMoveEvent 292 261 0 0 0 n\n"
                        "MouseMoveEvent 292 262 0 0 0 n\n"
                        "MouseMoveEvent 292 263 0 0 0 n\n"
                        "MouseMoveEvent 292 264 0 0 0 n\n"
                        "MouseMoveEvent 292 265 0 0 0 n\n"
                        "MouseMoveEvent 291 266 0 0 0 n\n"
                        "MouseMoveEvent 291 267 0 0 0 n\n"
                        "MouseMoveEvent 290 268 0 0 0 n\n"
                        "MouseMoveEvent 290 269 0 0 0 n\n"
                        "MouseMoveEvent 290 270 0 0 0 n\n"
                        "MouseMoveEvent 289 270 0 0 0 n\n"
                        "MouseMoveEvent 289 271 0 0 0 n\n"
                        "MouseMoveEvent 289 272 0 0 0 n\n"
                        "MouseMoveEvent 289 273 0 0 0 n\n"
                        "MouseMoveEvent 289 274 0 0 0 n\n"
                        "MouseMoveEvent 288 274 0 0 0 n\n"
                        "MouseMoveEvent 288 275 0 0 0 n\n"
                        "MouseMoveEvent 288 276 0 0 0 n\n"
                        "MouseMoveEvent 287 276 0 0 0 n\n"
                        "MouseMoveEvent 287 277 0 0 0 n\n"
                        "MouseMoveEvent 287 278 0 0 0 n\n"
                        "MouseMoveEvent 287 279 0 0 0 n\n"
                        "MouseMoveEvent 286 279 0 0 0 n\n"
                        "MouseMoveEvent 286 280 0 0 0 n\n"
                        "MouseMoveEvent 286 281 0 0 0 n\n"
                        "MouseMoveEvent 285 281 0 0 0 n\n"
                        "MouseMoveEvent 285 282 0 0 0 n\n"
                        "MouseMoveEvent 285 283 0 0 0 n\n"
                        "MouseMoveEvent 284 283 0 0 0 n\n"
                        "MouseMoveEvent 284 284 0 0 0 n\n"
                        "MouseMoveEvent 284 285 0 0 0 n\n"
                        "MouseMoveEvent 284 286 0 0 0 n\n"
                        "MouseMoveEvent 283 287 0 0 0 n\n"
                        "MouseMoveEvent 283 288 0 0 0 n\n"
                        "MouseMoveEvent 283 289 0 0 0 n\n"
                        "MouseMoveEvent 283 290 0 0 0 n\n"
                        "MouseMoveEvent 283 291 0 0 0 n\n"
                        "MouseMoveEvent 283 292 0 0 0 n\n"
                        "MouseMoveEvent 283 293 0 0 0 n\n"
                        "MouseMoveEvent 283 294 0 0 0 n\n"
                        "MouseMoveEvent 283 295 0 0 0 n\n"
                        "MouseMoveEvent 283 296 0 0 0 n\n"
                        "MouseMoveEvent 284 296 0 0 0 n\n"
                        "MouseMoveEvent 284 297 0 0 0 n\n"
                        "MouseMoveEvent 284 298 0 0 0 n\n"
                        "MouseMoveEvent 285 298 0 0 0 n\n"
                        "MouseMoveEvent 285 299 0 0 0 n\n"
                        "MouseMoveEvent 286 299 0 0 0 n\n"
                        "LeaveEvent 286 300 0 0 0 n";

// This does the actual work: updates the vtkPlane implicit function.
// This in turn causes the pipeline to update and clip the object.
// Callback for the interaction
class vtkTDSIPW2Callback : public vtkCommand
{
public:
  static vtkTDSIPW2Callback* New() { return new vtkTDSIPW2Callback; }

  void Execute(vtkObject* caller, unsigned long, void*) override
  {
    auto* planeWidget = reinterpret_cast<Widget*>(caller);
    auto* rep = reinterpret_cast<Representation*>(planeWidget->GetRepresentation());
    rep->GetPlane(this->Plane);
    this->Actor->VisibilityOn();
  }

  vtkTDSIPW2Callback()
    : Plane(nullptr)
    , Actor(nullptr)
  {
  }

  vtkPlane* Plane;
  vtkActor* Actor;
};

int TestDisplaySizedImplicitPlaneWidget(int vtkNotUsed(argc), char* vtkNotUsed(argv)[])
{
  // Create a mace out of filters.
  vtkNew<vtkSphereSource> sphere;
  vtkNew<vtkConeSource> cone;
  vtkNew<vtkGlyph3D> glyph;
  glyph->SetInputConnection(sphere->GetOutputPort());
  glyph->SetSourceConnection(cone->GetOutputPort());
  glyph->SetVectorModeToUseNormal();
  glyph->SetScaleModeToScaleByVector();
  glyph->SetScaleFactor(0.25);
  glyph->Update();

  // The sphere and spikes are appended into a single polydata.
  // This just makes things simpler to manage.
  vtkNew<vtkAppendPolyData> apd;
  apd->AddInputConnection(glyph->GetOutputPort());
  apd->AddInputConnection(sphere->GetOutputPort());

  // This portion of the code clips the mace with the vtkPlanes
  // implicit function. The clipped region is colored green.
  vtkNew<vtkPlane> plane;
  vtkNew<vtkClipPolyData> clipper;
  clipper->SetInputConnection(apd->GetOutputPort());
  clipper->SetClipFunction(plane);
  clipper->InsideOutOn();

  vtkNew<vtkPolyDataMapper> selectMapper;
  selectMapper->SetInputConnection(clipper->GetOutputPort());

  vtkNew<vtkLODActor> selectActor;
  selectActor->SetMapper(selectMapper);

  // Create the RenderWindow, Renderer and both Actors
  vtkNew<vtkRenderer> ren1;
  vtkNew<vtkRenderWindow> renWin;
  renWin->AddRenderer(ren1);
  ren1->AddActor(selectActor);

  vtkNew<vtkRenderWindowInteractor> iren;
  iren->SetRenderWindow(renWin);

  // The SetInteractor method is how 3D widgets are associated with the render
  // window interactor. Internally, SetInteractor sets up a bunch of callbacks
  // using the Command/Observer mechanism (AddObserver()).
  vtkNew<vtkTDSIPW2Callback> myCallback;
  myCallback->Plane = plane;
  myCallback->Actor = selectActor;

  vtkNew<Representation> rep;
  rep->ScaleEnabledOn();
  rep->SetPlaceFactor(1.25); // This must be set prior to placing the widget
  rep->PlaceWidget(selectActor->GetBounds());
  rep->SetNormal(plane->GetNormal());

  vtkNew<Widget> planeWidget;
  planeWidget->SetInteractor(iren);
  planeWidget->SetRepresentation(rep);
  planeWidget->AddObserver(vtkCommand::InteractionEvent, myCallback);

  // Render
  iren->Initialize();
  renWin->Render();
  planeWidget->On();

  vtkNew<vtkInteractorEventRecorder> recorder;
  recorder->SetInteractor(iren);
#if 0 // uncomment if recording
  recorder->SetFileName("record.log");
  recorder->Record();
  recorder->On();

  iren->Initialize();
  renWin->Render();
  iren->Start();
#else
  recorder->ReadFromInputStringOn();
  recorder->SetInputString(eventLog);

  // render the image
  iren->Initialize();
  renWin->Render();
  recorder->Play();

  // Remove the observers so we can go interactive. Without this the "-I"
  // testing option fails.
  recorder->Off();

  iren->Start();
#endif

  return EXIT_SUCCESS;
}
