/*=========================================================================

  Program:   ParaView
  Module:    TestSpyPlotTracers.cxx

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "vtkDummyController.h"
#include "vtkSmartPointer.h"
#include "vtkSpyPlotReader.h"
#include "vtkTestUtilities.h"

int TestSpyPlotTracers(int argc, char* argv[])
{
  char* fname =
    vtkTestUtilities::ExpandDataFileName(argc, argv, "Testing/Data/SPCTH/ball_and_box.spcth");

  auto controller = vtkSmartPointer<vtkDummyController>::New();
  vtkMultiProcessController::SetGlobalController(controller);

  auto reader = vtkSmartPointer<vtkSpyPlotReader>::New();
  reader->SetGlobalController(controller);
  reader->SetFileName(fname);
  reader->GenerateTracerArrayOn();
  reader->Update();

  delete[] fname;

  return 0;
}
