
/*=========================================================================

  Program:   ParaView
  Module:    TestPVThreshold.cxx

  Copyright (c) Kitware, Inc.
  All rights reserved.
  See Copyright.txt or http://www.paraview.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "vtkDataSetSurfaceFilter.h"
#include "vtkPVLODActor.h"
#include "vtkPVThreshold.h"
#include "vtkPolyDataMapper.h"
#include "vtkRTAnalyticSource.h"
#include "vtkRegressionTestImage.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkRenderer.h"
#include "vtkSmartPointer.h"
#include "vtkTesting.h"

int TestPVThreshold(int argc, char* argv[])
{
  auto source1 = vtkSmartPointer<vtkRTAnalyticSource>::New();
  source1->SetWholeExtent(-10, 10, -10, 10, -10, 10);
  source1->SetCenter(0.0, 0.0, 0.0);
  source1->SetXFreq(60.0);
  source1->SetYFreq(30.0);
  source1->SetZFreq(40.0);
  source1->SetMaximum(255.0);
  source1->SetXMag(10.0);
  source1->SetYMag(18.0);
  source1->SetZMag(5.0);
  source1->SetStandardDeviation(0.5);
  source1->SetSubsampleRate(1);

  auto source2 = vtkSmartPointer<vtkRTAnalyticSource>::New();
  source2->SetWholeExtent(20, 40, -10, 10, -10, 10);
  source2->SetCenter(30.0, 0.0, 0.0);
  source2->SetXFreq(60.0);
  source2->SetYFreq(30.0);
  source2->SetZFreq(40.0);
  source2->SetMaximum(255.0);
  source2->SetXMag(10.0);
  source2->SetYMag(18.0);
  source2->SetZMag(5.0);
  source2->SetStandardDeviation(0.5);
  source2->SetSubsampleRate(1);

  auto source3 = vtkSmartPointer<vtkRTAnalyticSource>::New();
  source3->SetWholeExtent(50, 70, -10, 10, -10, 10);
  source3->SetCenter(60.0, 0.0, 0.0);
  source3->SetXFreq(60.0);
  source3->SetYFreq(30.0);
  source3->SetZFreq(40.0);
  source3->SetMaximum(255.0);
  source3->SetXMag(10.0);
  source3->SetYMag(18.0);
  source3->SetZMag(5.0);
  source3->SetStandardDeviation(0.5);
  source3->SetSubsampleRate(1);

  // First case
  auto pvt1 = vtkSmartPointer<vtkPVThreshold>::New();
  pvt1->SetInputConnection(source1->GetOutputPort());
  pvt1->SetThresholdFunction(vtkThreshold::THRESHOLD_BETWEEN);
  pvt1->SetLowerThreshold(100.0);
  pvt1->SetUpperThreshold(150.0);

  auto sf1 = vtkSmartPointer<vtkDataSetSurfaceFilter>::New();
  sf1->SetInputConnection(pvt1->GetOutputPort(0));

  auto mapper1 = vtkSmartPointer<vtkPolyDataMapper>::New();
  mapper1->SetInputConnection(sf1->GetOutputPort());

  auto actor1 = vtkSmartPointer<vtkPVLODActor>::New();
  actor1->SetMapper(mapper1);
  //--

  // Second case.
  auto pvt2 = vtkSmartPointer<vtkPVThreshold>::New();
  pvt2->SetInputConnection(source2->GetOutputPort());
  pvt2->SetThresholdFunction(vtkThreshold::THRESHOLD_BETWEEN);
  pvt2->SetLowerThreshold(50.0);
  pvt2->SetUpperThreshold(276.829);

  auto sf2 = vtkSmartPointer<vtkDataSetSurfaceFilter>::New();
  sf2->SetInputConnection(pvt2->GetOutputPort(0));

  auto mapper2 = vtkSmartPointer<vtkPolyDataMapper>::New();
  mapper2->SetInputConnection(sf2->GetOutputPort());

  auto actor2 = vtkSmartPointer<vtkPVLODActor>::New();
  actor2->SetMapper(mapper2);
  //--

  // Third case.
  auto pvt3 = vtkSmartPointer<vtkPVThreshold>::New();
  pvt3->SetInputConnection(source3->GetOutputPort());
  pvt3->SetThresholdFunction(vtkThreshold::THRESHOLD_BETWEEN);
  pvt3->SetLowerThreshold(100.0);
  pvt3->SetUpperThreshold(150.0);

  auto sf3 = vtkSmartPointer<vtkDataSetSurfaceFilter>::New();
  sf3->SetInputConnection(pvt3->GetOutputPort(0));

  auto mapper3 = vtkSmartPointer<vtkPolyDataMapper>::New();
  mapper3->SetInputConnection(sf3->GetOutputPort());

  auto actor3 = vtkSmartPointer<vtkPVLODActor>::New();
  actor3->SetMapper(mapper3);
  //--

  auto ren = vtkSmartPointer<vtkRenderer>::New();
  ren->AddActor(actor1);
  ren->AddActor(actor2);
  ren->AddActor(actor3);
  ren->ResetCamera();

  auto renWin = vtkSmartPointer<vtkRenderWindow>::New();
  renWin->AddRenderer(ren);

  auto iren = vtkSmartPointer<vtkRenderWindowInteractor>::New();
  iren->SetRenderWindow(renWin);
  renWin->SetSize(300, 300);
  iren->SetRenderWindow(renWin);
  renWin->Render();

  int retVal = vtkRegressionTestImage(renWin);
  if (retVal == vtkRegressionTester::DO_INTERACTOR)
  {
    iren->Start();
  }
  return !retVal;
}
