/*=========================================================================

  Program:   Visualization Toolkit
  Module:    TestPVAMRDualContour.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "vtkDummyController.h"
#include "vtkMultiProcessController.h"
#include "vtkPVAMRDualContour.h"
#include "vtkSmartPointer.h"
#include "vtkSpyPlotReader.h"
#include "vtkTestUtilities.h"

#include <iostream>

int TestPVAMRDualContour(int argc, char* argv[])
{
  auto controller = vtkSmartPointer<vtkDummyController>::New();
  vtkMultiProcessController::SetGlobalController(controller);

  int retVal = 0;

  char* fname = vtkTestUtilities::ExpandDataFileName(
    argc, argv, "Testing/Data/SPCTH/Dave_Karelitz_Small/spcth.0");

  auto reader = vtkSmartPointer<vtkSpyPlotReader>::New();
  reader->SetFileName(fname);
  reader->SetGlobalController(controller);
  reader->MergeXYZComponentsOn();
  reader->DownConvertVolumeFractionOn();
  reader->DistributeFilesOn();
  reader->SetCellArrayStatus("Material volume fraction - 2", 1);
  reader->Update();

  auto contour = vtkSmartPointer<vtkPVAMRDualContour>::New();
  contour->SetInputData(reader->GetOutputDataObject(0));
  contour->SetVolumeFractionSurfaceValue(0.1);
  contour->SetEnableMergePoints(1);
  contour->SetEnableDegenerateCells(1);
  contour->SetEnableMultiProcessCommunication(1);
  contour->AddInputCellArrayToProcess("Material volume fraction - 2");
  contour->Update();

  delete[] fname;

  return retVal;
}
