/*=========================================================================

  Program:   Visualization Toolkit
  Module:    TestPVAMRDualClip.cxx

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#include "vtkActor.h"
#include "vtkCompositePolyDataMapper2.h"
#include "vtkDataSetSurfaceFilter.h"
#include "vtkDummyController.h"
#include "vtkPVAMRDualClip.h"
#include "vtkPVGeometryFilter.h"
#include "vtkRegressionTestImage.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkRenderer.h"
#include "vtkSmartPointer.h"
#include "vtkSpyPlotReader.h"
#include "vtkTestUtilities.h"

int TestPVAMRDualClip(int argc, char* argv[])
{
  int retVal = 0;

  char* fname = vtkTestUtilities::ExpandDataFileName(
    argc, argv, "Testing/Data/SPCTH/Dave_Karelitz_Small/spcth.0");

  if (!fname)
  {
    return retVal;
  }

  auto controller = vtkSmartPointer<vtkDummyController>::New();
  vtkMultiProcessController::SetGlobalController(controller);

  auto reader = vtkSmartPointer<vtkSpyPlotReader>::New();
  reader->SetFileName(fname);
  reader->SetGlobalController(controller);
  reader->MergeXYZComponentsOn();
  reader->DownConvertVolumeFractionOn();
  reader->DistributeFilesOn();
  reader->SetCellArrayStatus("Material volume fraction - 3", 1);
  reader->Update();

  auto filter = vtkSmartPointer<vtkPVAMRDualClip>::New();
  filter->SetInputConnection(reader->GetOutputPort(0));
  filter->SetVolumeFractionSurfaceValue(0.1);
  filter->SetEnableMergePoints(1);
  filter->SetEnableDegenerateCells(1);
  filter->SetEnableMultiProcessCommunication(1);
  filter->AddInputCellArrayToProcess("Material volume fraction - 3");

  auto surface = vtkSmartPointer<vtkPVGeometryFilter>::New();
  surface->SetUseOutline(0);
  surface->SetInputConnection(filter->GetOutputPort(0));

  auto mapper = vtkSmartPointer<vtkCompositePolyDataMapper2>::New();
  mapper->SetInputConnection(surface->GetOutputPort());

  auto actor = vtkSmartPointer<vtkActor>::New();
  actor->SetMapper(mapper);

  auto renderer = vtkSmartPointer<vtkRenderer>::New();
  renderer->AddActor(actor);
  renderer->ResetCamera();

  auto renWin = vtkSmartPointer<vtkRenderWindow>::New();
  renWin->AddRenderer(renderer);

  auto iren = vtkSmartPointer<vtkRenderWindowInteractor>::New();
  iren->SetRenderWindow(renWin);

  retVal = vtkRegressionTestImage(renWin);
  if (retVal == vtkRegressionTester::DO_INTERACTOR)
  {
    iren->Start();
    retVal = vtkRegressionTester::PASSED;
  }
  delete[] fname;

  return (retVal == vtkRegressionTester::PASSED) ? EXIT_SUCCESS : EXIT_FAILURE;
}
