
#include "vtkSmartPointer.h"
#include "vtkTilesHelper.h"
#include <cassert>

static void vtkTest(int rank, vtkTilesHelper* helper, int minX, int minY, int maxX, int maxY)
{
  vtkVector4d viewport = { 0, 0, 1, 1 };
  vtkVector2i size, minXY;
  helper->GetTiledSizeAndOrigin(rank, size, minXY, viewport);
  cout << "---------------------" << endl
       << "Rank : " << rank << " in " << helper->GetTileDimensions()[0] << "x"
       << helper->GetTileDimensions()[1] << endl;
  cout << "Size: " << size[0] << ", " << size[1] << "\n"
       << "MinXY " << minXY[0] << ", " << minXY[1] << endl;

  int maxXActual = size[0] + minXY[0];
  int maxYActual = size[1] + minXY[1];

  cout << "Expected value: " << minX << ", " << minY << ", " << maxX << ", " << maxY << endl;
  cout << "From vtkTilesHelper: " << minXY[0] << ", " << minXY[1] << ", " << maxXActual << ", "
       << maxYActual << endl;
  assert(minXY[0] == minX);
  assert(minXY[1] == minY);
  assert(maxXActual == maxX);
  assert(maxYActual == maxY);
}

int TestTilesHelper(int, char* [])
{
  auto helper = vtkSmartPointer<vtkTilesHelper>::New();

  helper->SetTileDimensions(3, 2);
  helper->SetTileWindowSize(400, 400);
  vtkTest(1, helper, 400, 400, 800, 800);
  vtkTest(2, helper, 800, 400, 1200, 800);
  vtkTest(4, helper, 400, 0, 800, 400);

  return 0;
}
