#! /usr/bin/env bash
#                          __  __            _
#                       ___\ \/ /_ __   __ _| |_
#                      / _ \\  /| '_ \ / _` | __|
#                     |  __//  \| |_) | (_| | |_
#                      \___/_/\_\ .__/ \__,_|\__|
#                               |_| XML parser
#
# Copyright (c) 2017-2021 Sebastian Pipping <sebastian@pipping.org>
# Copyright (c) 2018      Marco Maggi <marco.maggi-ipsu@poste.it>
# Licensed under the MIT license:
#
# Permission is  hereby granted,  free of charge,  to any  person obtaining
# a  copy  of  this  software   and  associated  documentation  files  (the
# "Software"),  to  deal in  the  Software  without restriction,  including
# without  limitation the  rights  to use,  copy,  modify, merge,  publish,
# distribute, sublicense, and/or sell copies of the Software, and to permit
# persons  to whom  the Software  is  furnished to  do so,  subject to  the
# following conditions:
#
# The above copyright  notice and this permission notice  shall be included
# in all copies or substantial portions of the Software.
#
# THE  SOFTWARE  IS  PROVIDED  "AS  IS",  WITHOUT  WARRANTY  OF  ANY  KIND,
# EXPRESS  OR IMPLIED,  INCLUDING  BUT  NOT LIMITED  TO  THE WARRANTIES  OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
# NO EVENT SHALL THE AUTHORS OR  COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
# DAMAGES OR  OTHER LIABILITY, WHETHER  IN AN  ACTION OF CONTRACT,  TORT OR
# OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
# USE OR OTHER DEALINGS IN THE SOFTWARE.

set -e

# File expat_config.h.in (as generated by autoheader by autoreconf) contains
# macro SIZEOF_VOID_P which is (1) not really needed by Expat as of today and
# (2) a problem to "multilib" systems with one shared installed
# /usr/include/expat_config.h for two Expats with different "void *" sizes
# installed in e.g. /usr/lib32 and /usr/lib64.  Hence we patch macro
# SIZEOF_VOID_P out of template expat_config.h.in so that configure will
# not put SIZEOF_VOID_P in the eventual expat_config.h.
patch_expat_config_h_in() {
    local filename="$1"
    local sizeof_void_p_line_number="$(fgrep -n SIZEOF_VOID_P "${filename}" | awk -F: '{print $1}')"
    [[ ${sizeof_void_p_line_number} =~ ^[0-9]+$ ]]  # cheap assert
    local first_line_to_delete=$(( sizeof_void_p_line_number - 1 ))
    local last_line_to_delete=$(( sizeof_void_p_line_number + 1 ))
    # Note: Avoiding "sed -i" only for macOS portability.
    local tempfile="$(mktemp)"
    sed "${first_line_to_delete},${last_line_to_delete}d" "${filename}" > "${tempfile}"
    mv "${tempfile}" "${filename}"
}

autoreconf --warnings=all --install --verbose "$@"

patch_expat_config_h_in expat_config.h.in
