/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#ifndef CMTARGETGRAPHVIZWRITER_H
#define CMTARGETGRAPHVIZWRITER_H

#include "cmGraphVizWriter.h"

/** This class implements writing files for graphviz (dot) for graphs
 * representing the dependencies between the targets in the project. */
class cmTargetGraphVizWriter: public cmGraphVizWriter
{
public:
  cmTargetGraphVizWriter(
    const std::vector<cmLocalGenerator*>& localGenerators);

  void ReadSettings(const char* settingsFileName,
                    const char* fallbackSettingsFileName);

  void WritePerNodeFiles(const char* fileName);
  void WriteNodeDependersFiles(const char* fileName);

  void WriteGlobalFile(const char* fileName);

protected:
  void CollectTargetsAndLibs();

  int CollectAllTargets();

  int CollectAllExternalLibs(int cnt);

  void WriteConnections(const std::string& targetName,
                        std::set<std::string>& insertedNodes,
                        std::set<std::string>& insertedConnections,
                        cmGeneratedFileStream& str) const;

  void WriteDependerConnections(const std::string& targetName,
                                std::set<std::string>& insertedNodes,
                                std::set<std::string>& insertedConnections,
                                cmGeneratedFileStream& str) const;

  void WriteNode(const std::string& targetName,
                 const cmGeneratorTarget* target,
                 std::set<std::string>& insertedNodes,
                 cmGeneratedFileStream& str) const;

  bool IgnoreThisTarget(const std::string& name);

  bool GenerateForTargetType(cmStateEnums::TargetType targetType) const;

  std::string GraphNodePrefix;

  std::vector<cmsys::RegularExpression> TargetsToIgnoreRegex;

  const std::vector<cmLocalGenerator*>& LocalGenerators;

  std::map<std::string, const cmGeneratorTarget*> TargetPtrs;
  // maps from the actual target names to node names in dot:
  std::map<std::string, std::string> TargetNamesNodes;

  bool GenerateForExecutables;
  bool GenerateForStaticLibs;
  bool GenerateForSharedLibs;
  bool GenerateForModuleLibs;
  bool GenerateForExternals;
  bool GeneratePerTarget;
  bool GenerateDependers;
  bool HaveTargetsAndLibs;
};

#endif
