/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import prefuse.Display;
import prefuse.controls.ControlAdapter;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class PanControl
extends ControlAdapter {
    private boolean m_panOverItem;
    private int m_xDown;
    private int m_yDown;
    private int m_button;

    public PanControl() {
        this(16, false);
    }

    public PanControl(boolean bl) {
        this(16, bl);
    }

    public PanControl(int n) {
        this(n, false);
    }

    public PanControl(int n, boolean bl) {
        this.m_button = n;
        this.m_panOverItem = bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed(mouseEvent, this.m_button)) {
            mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(13));
            this.m_xDown = mouseEvent.getX();
            this.m_yDown = mouseEvent.getY();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed(mouseEvent, this.m_button)) {
            Display display = (Display)mouseEvent.getComponent();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = n - this.m_xDown;
            int n4 = n2 - this.m_yDown;
            display.pan(n3, n4);
            this.m_xDown = n;
            this.m_yDown = n2;
            display.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (UILib.isButtonPressed(mouseEvent, this.m_button)) {
            mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            this.m_xDown = -1;
            this.m_yDown = -1;
        }
    }

    public void itemPressed(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.m_panOverItem) {
            this.mousePressed(mouseEvent);
        }
    }

    public void itemDragged(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.m_panOverItem) {
            this.mouseDragged(mouseEvent);
        }
    }

    public void itemReleased(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.m_panOverItem) {
            this.mouseReleased(mouseEvent);
        }
    }
}

