/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.filter;

import java.util.Iterator;
import prefuse.Visualization;
import prefuse.action.GroupAction;
import prefuse.data.Graph;
import prefuse.data.Tree;
import prefuse.data.expression.Predicate;
import prefuse.util.PrefuseLib;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;

public class FisheyeTreeFilter
extends GroupAction {
    private String m_sources;
    private Predicate m_groupP;
    private int m_threshold;
    private NodeItem m_root;
    private double m_divisor;

    public FisheyeTreeFilter(String string) {
        this(string, 1);
    }

    public FisheyeTreeFilter(String string, int n) {
        this(string, Visualization.FOCUS_ITEMS, n);
    }

    public FisheyeTreeFilter(String string, String string2, int n) {
        super(string);
        this.m_sources = string2;
        this.m_threshold = -n;
        this.m_groupP = new InGroupPredicate(PrefuseLib.getGroupName(string, Graph.NODES));
    }

    public int getDistance() {
        return -this.m_threshold;
    }

    public void setDistance(int n) {
        this.m_threshold = -n;
    }

    public String getSources() {
        return this.m_sources;
    }

    public void setSources(String string) {
        this.m_sources = string;
    }

    public void run(double d) {
        Object object;
        Tree tree = ((Graph)this.m_vis.getGroup(this.m_group)).getSpanningTree();
        this.m_divisor = tree.getNodeCount();
        this.m_root = (NodeItem)tree.getRoot();
        Iterator iterator = this.m_vis.visibleItems(this.m_group);
        while (iterator.hasNext()) {
            object = (VisualItem)iterator.next();
            object.setDOI(-1.7976931348623157E308);
            object.setExpanded(false);
        }
        object = this.m_vis.items(this.m_sources, this.m_groupP);
        while (object.hasNext()) {
            this.visitFocus((NodeItem)object.next(), null);
        }
        this.visitFocus(this.m_root, null);
        iterator = this.m_vis.visibleItems(this.m_group);
        while (iterator.hasNext()) {
            VisualItem visualItem = (VisualItem)iterator.next();
            if (visualItem.getDOI() != -1.7976931348623157E308) continue;
            PrefuseLib.updateVisible(visualItem, false);
        }
    }

    private void visitFocus(NodeItem nodeItem, NodeItem nodeItem2) {
        if (nodeItem.getDOI() <= -1.0) {
            this.visit(nodeItem, nodeItem2, 0, 0);
            if (this.m_threshold < 0) {
                this.visitDescendants(nodeItem, nodeItem2);
            }
            this.visitAncestors(nodeItem);
        }
    }

    private void visit(NodeItem nodeItem, NodeItem nodeItem2, int n, int n2) {
        PrefuseLib.updateVisible(nodeItem, true);
        double d = (double)(-n2) / Math.min(1000.0, this.m_divisor);
        nodeItem.setDOI((double)n + d);
        if (nodeItem2 != null) {
            EdgeItem edgeItem = (EdgeItem)nodeItem2.getParentEdge();
            edgeItem.setDOI(nodeItem2.getDOI());
            PrefuseLib.updateVisible(edgeItem, true);
        }
    }

    private void visitAncestors(NodeItem nodeItem) {
        if (nodeItem == this.m_root) {
            return;
        }
        this.visitFocus((NodeItem)nodeItem.getParent(), nodeItem);
    }

    private void visitDescendants(NodeItem nodeItem, NodeItem nodeItem2) {
        int n = nodeItem2 == null ? 0 : nodeItem.getChildIndex(nodeItem2);
        Iterator iterator = nodeItem.children();
        nodeItem.setExpanded(iterator.hasNext());
        int n2 = 0;
        while (iterator.hasNext()) {
            NodeItem nodeItem3 = (NodeItem)iterator.next();
            if (nodeItem3 != nodeItem2) {
                int n3 = (int)(nodeItem.getDOI() - 1.0);
                this.visit(nodeItem3, nodeItem3, n3, Math.abs(n - n2));
                if (n3 > this.m_threshold) {
                    this.visitDescendants(nodeItem3, null);
                }
            }
            ++n2;
        }
    }
}

