/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import prefuse.data.Table;
import prefuse.data.event.TableListener;
import prefuse.util.StringLib;
import prefuse.util.collections.CopyOnWriteArrayList;
import prefuse.util.collections.IntIterator;
import prefuse.visual.VisualTable;

public class JPrefuseTable
extends JTable {
    private Table m_table;
    private TableCellRenderer m_tcr = new DefaultTableCellRenderer();

    public JPrefuseTable(Table table) {
        this.m_table = table;
        PrefuseTableModel prefuseTableModel = new PrefuseTableModel();
        super.setModel(prefuseTableModel);
        this.m_table.addTableListener(prefuseTableModel);
    }

    public Table getTable() {
        return this.m_table;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        return this.m_tcr;
    }

    public static JFrame showTableWindow(Table table) {
        JPrefuseTable jPrefuseTable = new JPrefuseTable(table);
        String string = table.toString();
        if (table instanceof VisualTable) {
            string = ((VisualTable)table).getGroup() + " " + string;
        }
        JFrame jFrame = new JFrame(string);
        jFrame.getContentPane().add(new JScrollPane(jPrefuseTable));
        jFrame.pack();
        jFrame.setVisible(true);
        return jFrame;
    }

    public class PrefuseTableModel
    implements TableModel,
    TableListener {
        private CopyOnWriteArrayList m_listeners = new CopyOnWriteArrayList();
        private int[] m_rowmap;

        private void initRowMap() {
            this.m_rowmap = new int[JPrefuseTable.this.m_table.getRowCount()];
            IntIterator intIterator = JPrefuseTable.this.m_table.rows();
            int n = 0;
            while (intIterator.hasNext()) {
                this.m_rowmap[n] = intIterator.nextInt();
                ++n;
            }
        }

        private int getRow(int n) {
            if (this.m_rowmap == null) {
                this.initRowMap();
            }
            return this.m_rowmap[n];
        }

        public int getColumnCount() {
            return JPrefuseTable.this.m_table.getColumnCount();
        }

        public int getRowCount() {
            return JPrefuseTable.this.m_table.getRowCount();
        }

        public boolean isCellEditable(int n, int n2) {
            return JPrefuseTable.this.m_table.isCellEditable(n, n2);
        }

        public Class getColumnClass(int n) {
            return JPrefuseTable.this.m_table.getColumnType(n);
        }

        public Object getValueAt(int n, int n2) {
            Object object = JPrefuseTable.this.m_table.get(this.getRow(n), n2);
            if (object != null && object.getClass().isArray()) {
                return StringLib.getArrayString(object);
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            JPrefuseTable.this.m_table.set(this.getRow(n), n2, object);
        }

        public String getColumnName(int n) {
            return JPrefuseTable.this.m_table.getColumnName(n);
        }

        public void addTableModelListener(TableModelListener tableModelListener) {
            this.m_listeners.add(tableModelListener);
        }

        public void removeTableModelListener(TableModelListener tableModelListener) {
            this.m_listeners.remove(tableModelListener);
        }

        public void tableChanged(Table table, int n, int n2, int n3, int n4) {
            Object[] objectArray;
            if (n4 == 1 || n4 == -1) {
                this.m_rowmap = null;
            }
            if ((objectArray = this.m_listeners.getArray()).length == 0) {
                return;
            }
            TableModelEvent tableModelEvent = new TableModelEvent(this, n, n2, n3, n4);
            for (int i = 0; i < objectArray.length; ++i) {
                ((TableModelListener)objectArray[i]).tableChanged(tableModelEvent);
            }
        }
    }
}

