/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.awt.FontMetrics;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.Hashtable;

public class StringLib {
    private static final String SUFFIX = "suffix";
    private static final String PREFIX = "prefix";
    private static Hashtable prefixSuffixT = new Hashtable();

    private StringLib() {
    }

    public static final String getArrayString(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(Array.get(object, i));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String formatNumber(double d, int n) {
        String string = String.valueOf(d);
        int n2 = string.indexOf(46);
        if (n2 == -1) {
            return string;
        }
        int n3 = string.indexOf(69);
        int n4 = n + (n3 >= 0 ? 0 : 1);
        String string2 = string.substring(0, Math.min(n2 + n4, string.length()));
        if (n3 >= 0) {
            string2 = string2 + string.substring(n3);
        }
        return string2;
    }

    public static String capitalizeFirstOnly(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = string.charAt(0);
        stringBuffer.append(Character.toUpperCase(c));
        boolean bl = Character.isWhitespace(c);
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                bl = true;
            } else if (bl) {
                c = Character.toUpperCase(c);
                bl = false;
            } else {
                c = Character.toLowerCase(c);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public static String abbreviate(String string, FontMetrics fontMetrics, int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n && n3 < string.length(); i += fontMetrics.charWidth(string.charAt(n3)), ++n3) {
            if (!Character.isWhitespace(string.charAt(n3))) continue;
            n2 = n3;
        }
        if (n3 < string.length() && n2 > 0) {
            n3 = n2;
        }
        return n3 > 0 ? string.substring(0, n3) : string;
    }

    public static String abbreviateName(String string, FontMetrics fontMetrics, int n) {
        if (fontMetrics.stringWidth(string) > n) {
            string = StringLib.abbreviateName(string, false);
        }
        if (fontMetrics.stringWidth(string) > n) {
            string = StringLib.abbreviateName(string, true);
        }
        return string;
    }

    private static String abbreviateName(String string, boolean bl) {
        StringReader stringReader = new StringReader(string);
        StreamTokenizer streamTokenizer = new StreamTokenizer(stringReader);
        streamTokenizer.wordChars(38, 38);
        streamTokenizer.wordChars(64, 64);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.ordinaryChar(44);
        streamTokenizer.ordinaryChar(45);
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            block9: while (true) {
                int n = streamTokenizer.nextToken();
                switch (n) {
                    case -1: {
                        break block9;
                    }
                    case 10: {
                        System.err.println("warning: unexpected EOL token");
                        continue block9;
                    }
                    case -2: {
                        continue block9;
                    }
                    case 44: {
                        break block9;
                    }
                    case -3: {
                        if (streamTokenizer.sval.endsWith(":")) {
                            stringBuffer.append(streamTokenizer.sval + " ");
                            continue block9;
                        }
                        if (prefixSuffixT.get(streamTokenizer.sval.toLowerCase()) != null) continue block9;
                        if (!bl) {
                            if (string3 != null) {
                                stringBuffer.append(string3);
                            }
                            string3 = streamTokenizer.sval.substring(0, 1) + ". ";
                        }
                        string2 = streamTokenizer.sval;
                        continue block9;
                    }
                    default: {
                        continue block9;
                    }
                }
                break;
            }
            stringBuffer.append(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    static {
        prefixSuffixT.put("mr", PREFIX);
        prefixSuffixT.put("mr.", PREFIX);
        prefixSuffixT.put("dr", PREFIX);
        prefixSuffixT.put("dr.", PREFIX);
        prefixSuffixT.put("lt", PREFIX);
        prefixSuffixT.put("lt.", PREFIX);
        prefixSuffixT.put("gen", PREFIX);
        prefixSuffixT.put("gen.", PREFIX);
        prefixSuffixT.put("sgt", PREFIX);
        prefixSuffixT.put("sgt.", PREFIX);
        prefixSuffixT.put("cmdr", PREFIX);
        prefixSuffixT.put("cmdr.", PREFIX);
        prefixSuffixT.put("cpt", PREFIX);
        prefixSuffixT.put("cpt.", PREFIX);
        prefixSuffixT.put("ii", SUFFIX);
        prefixSuffixT.put("iii", SUFFIX);
        prefixSuffixT.put("iv", SUFFIX);
        prefixSuffixT.put("jr", SUFFIX);
        prefixSuffixT.put("jr.", SUFFIX);
        prefixSuffixT.put("sr", SUFFIX);
        prefixSuffixT.put("sr.", SUFFIX);
    }
}

