/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.awt.Color;
import prefuse.util.collections.IntObjectHashMap;

public class ColorLib {
    public static final char HEX_PREFIX = '#';
    private static final IntObjectHashMap colorMap = new IntObjectHashMap();
    private static int misses = 0;
    private static int lookups = 0;
    private static final float scale = 0.7f;
    public static final float[] CATEGORY_HUES = new float[]{0.0f, 0.083333336f, 0.16666667f, 0.33333334f, 0.5f, 0.5833333f, 0.6666667f, 0.8333333f, 0.9166667f};
    public static final int DEFAULT_MAP_SIZE = 64;

    public static int rgb(int n, int n2, int n3) {
        return ColorLib.rgba(n, n2, n3, 255);
    }

    public static int gray(int n) {
        return ColorLib.rgba(n, n, n, 255);
    }

    public static int gray(int n, int n2) {
        return ColorLib.rgba(n, n, n, n2);
    }

    public static int hex(String string) {
        if (string.charAt(0) == '#') {
            string = string.substring(1);
        }
        if (string.length() > 6) {
            int n = Integer.parseInt(string.substring(2), 16);
            int n2 = Integer.parseInt(string.substring(0, 2), 16);
            return ColorLib.setAlpha(n, n2);
        }
        return ColorLib.setAlpha(Integer.parseInt(string, 16), 255);
    }

    public static int hsb(float f, float f2, float f3) {
        return Color.HSBtoRGB(f, f2, f3);
    }

    public static int hsba(float f, float f2, float f3, float f4) {
        return ColorLib.setAlpha(Color.HSBtoRGB(f, f2, f3), (int)((double)(f4 * 255.0f) + 0.5) & 0xFF);
    }

    public static int rgba(int n, int n2, int n3, int n4) {
        return (n4 & 0xFF) << 24 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 0;
    }

    public static int rgba(float f, float f2, float f3, float f4) {
        return ((int)((double)(f4 * 255.0f) + 0.5) & 0xFF) << 24 | ((int)((double)(f * 255.0f) + 0.5) & 0xFF) << 16 | ((int)((double)(f2 * 255.0f) + 0.5) & 0xFF) << 8 | (int)((double)(f3 * 255.0f) + 0.5) & 0xFF;
    }

    public static int color(Color color) {
        return color.getRGB();
    }

    public static int red(int n) {
        return n >> 16 & 0xFF;
    }

    public static int green(int n) {
        return n >> 8 & 0xFF;
    }

    public static int blue(int n) {
        return n & 0xFF;
    }

    public static int alpha(int n) {
        return n >> 24 & 0xFF;
    }

    public static int setAlpha(int n, int n2) {
        return ColorLib.rgba(ColorLib.red(n), ColorLib.green(n), ColorLib.blue(n), n2);
    }

    public static Color getColor(float f, float f2, float f3, float f4) {
        return ColorLib.getColor(ColorLib.rgba(f, f2, f3, f4));
    }

    public static Color getColor(float f, float f2, float f3) {
        return ColorLib.getColor(f, f2, f3, 1.0f);
    }

    public static Color getColor(int n, int n2, int n3, int n4) {
        return ColorLib.getColor(ColorLib.rgba(n, n2, n3, n4));
    }

    public static Color getColor(int n, int n2, int n3) {
        return ColorLib.getColor(n, n2, n3, 255);
    }

    public static Color getGrayscale(int n) {
        return ColorLib.getColor(n, n, n, 255);
    }

    public static Color getColor(int n) {
        Color color = null;
        color = (Color)colorMap.get(n);
        if (color == null) {
            color = new Color(n, true);
            colorMap.put(n, color);
            ++misses;
        }
        ++lookups;
        return color;
    }

    public static int getCacheMissCount() {
        return misses;
    }

    public static int getCacheLookupCount() {
        return lookups;
    }

    public static void clearCache() {
        colorMap.clear();
    }

    public static int interp(int n, int n2, double d) {
        double d2 = 1.0 - d;
        return ColorLib.rgba((int)Math.round(d * (double)ColorLib.red(n2) + d2 * (double)ColorLib.red(n)), (int)Math.round(d * (double)ColorLib.green(n2) + d2 * (double)ColorLib.green(n)), (int)Math.round(d * (double)ColorLib.blue(n2) + d2 * (double)ColorLib.blue(n)), (int)Math.round(d * (double)ColorLib.alpha(n2) + d2 * (double)ColorLib.alpha(n)));
    }

    public static int darker(int n) {
        return ColorLib.rgba(Math.max(0, (int)(0.7f * (float)ColorLib.red(n))), Math.max(0, (int)(0.7f * (float)ColorLib.green(n))), Math.max(0, (int)(0.7f * (float)ColorLib.blue(n))), ColorLib.alpha(n));
    }

    public static int brighter(int n) {
        int n2 = ColorLib.red(n);
        int n3 = ColorLib.green(n);
        int n4 = ColorLib.blue(n);
        int n5 = 3;
        if (n2 == 0 && n3 == 0 && n4 == 0) {
            return ColorLib.rgba(n5, n5, n5, ColorLib.alpha(n));
        }
        if (n2 > 0 && n2 < n5) {
            n2 = n5;
        }
        if (n3 > 0 && n3 < n5) {
            n3 = n5;
        }
        if (n4 > 0 && n4 < n5) {
            n4 = n5;
        }
        return ColorLib.rgba(Math.min(255, (int)((float)n2 / 0.7f)), Math.min(255, (int)((float)n3 / 0.7f)), Math.min(255, (int)((float)n4 / 0.7f)), ColorLib.alpha(n));
    }

    public static int desaturate(int n) {
        int n2 = n & 0xFF000000;
        float f = (n & 0xFF0000) >> 16;
        float f2 = (n & 0xFF00) >> 8;
        float f3 = n & 0xFF;
        int n3 = Math.min((int)((f *= 0.2125f) + (f2 *= 0.7154f) + (f3 *= 0.0721f)), 255) & 0xFF;
        return n2 | n3 << 16 | n3 << 8 | n3;
    }

    public static int saturate(int n, float f) {
        float[] fArray = Color.RGBtoHSB(ColorLib.red(n), ColorLib.green(n), ColorLib.blue(n), null);
        return ColorLib.hsb(fArray[0], f, fArray[2]);
    }

    public static int[] getCoolPalette(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            float f = (float)i / Math.max((float)(n - 1), 1.0f);
            nArray[i] = ColorLib.rgba(f, 1.0f - f, 1.0f, 1.0f);
        }
        return nArray;
    }

    public static int[] getCoolPalette() {
        return ColorLib.getCoolPalette(64);
    }

    public static int[] getHotPalette(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            float f;
            int n2 = 3 * n / 8;
            float f2 = f = i < n2 ? (float)(i + 1) / (float)n2 : 1.0f;
            float f3 = i < n2 ? 0.0f : (i < 2 * n2 ? (float)(i - n2) / (float)n2 : 1.0f);
            float f4 = i < 2 * n2 ? 0.0f : (float)(i - 2 * n2) / (float)(n - 2 * n2);
            nArray[i] = ColorLib.rgba(f, f3, f4, 1.0f);
        }
        return nArray;
    }

    public static int[] getHotPalette() {
        return ColorLib.getHotPalette(64);
    }

    public static int[] getCategoryPalette(int n, float f, float f2, float f3, float f4) {
        int[] nArray = new int[n];
        float f5 = f;
        for (int i = 0; i < n; ++i) {
            int n2 = i % CATEGORY_HUES.length;
            if (n2 == 0) {
                f5 = f + (float)i / (float)n * (f2 - f);
            }
            nArray[i] = ColorLib.hsba(CATEGORY_HUES[n2], f5, f3, f4);
        }
        return nArray;
    }

    public static int[] getCategoryPalette(int n) {
        return ColorLib.getCategoryPalette(n, 1.0f, 0.4f, 1.0f, 1.0f);
    }

    public static int[] getHSBPalette(int n, float f, float f2) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            float f3 = (float)i / (float)(n - 1);
            nArray[i] = ColorLib.hsb(f3, f, f2);
        }
        return nArray;
    }

    public static int[] getHSBPalette() {
        return ColorLib.getHSBPalette(64, 1.0f, 1.0f);
    }

    public static int[] getInterpolatedPalette(int n, int n2, int n3) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            float f = (float)i / (float)(n - 1);
            nArray[i] = ColorLib.interp(n2, n3, f);
        }
        return nArray;
    }

    public static int[] getInterpolatedPalette(int n, int n2) {
        return ColorLib.getInterpolatedPalette(64, n, n2);
    }

    public static int[] getGrayscalePalette(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = Math.round(255.0f * (0.2f + 0.6f * (float)i / (float)(n - 1)));
            nArray[n - i - 1] = ColorLib.gray(n2);
        }
        return nArray;
    }

    public static int[] getGrayscalePalette() {
        return ColorLib.getGrayscalePalette(64);
    }
}

