/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import prefuse.render.AbstractShapeRenderer;
import prefuse.util.ColorLib;
import prefuse.util.GraphicsLib;
import prefuse.visual.VisualItem;

public class AxisRenderer
extends AbstractShapeRenderer {
    private Line2D m_line = new Line2D.Double();
    private Rectangle2D m_box = new Rectangle2D.Double();
    private int m_xalign;
    private int m_yalign;
    private int m_ascent;

    public AxisRenderer() {
        this(0, 3);
    }

    public AxisRenderer(int n, int n2) {
        this.m_xalign = n;
        this.m_yalign = n2;
    }

    public void setHorizontalAlignment(int n) {
        this.m_xalign = n;
    }

    public void setVerticalAlignment(int n) {
        this.m_yalign = n;
    }

    protected Shape getRawShape(VisualItem visualItem) {
        double d;
        double d2;
        double d3 = visualItem.getDouble(VisualItem.X);
        double d4 = visualItem.getDouble(VisualItem.Y);
        double d5 = visualItem.getDouble(VisualItem.X2);
        double d6 = visualItem.getDouble(VisualItem.Y2);
        this.m_line.setLine(d3, d4, d5, d6);
        if (!visualItem.canGetString(VisualItem.LABEL)) {
            return this.m_line;
        }
        String string = visualItem.getString(VisualItem.LABEL);
        if (string == null) {
            return this.m_line;
        }
        FontMetrics fontMetrics = DEFAULT_GRAPHICS.getFontMetrics(visualItem.getFont());
        this.m_ascent = fontMetrics.getAscent();
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.stringWidth(string);
        switch (this.m_xalign) {
            case 6: {
                d2 = d5 + 2.0;
                break;
            }
            case 5: {
                d2 = d3 - (double)n2 - 2.0;
                break;
            }
            case 2: {
                d2 = d3 + (d5 - d3) / 2.0 - (double)(n2 / 2);
                break;
            }
            case 1: {
                d2 = d5 - (double)n2;
                break;
            }
            default: {
                d2 = d3;
            }
        }
        switch (this.m_yalign) {
            case 8: {
                d = d4 - (double)n;
                break;
            }
            case 7: {
                d = d6;
                break;
            }
            case 2: {
                d = d4 + (d6 - d4) / 2.0 - (double)(n / 2);
                break;
            }
            case 4: {
                d = d4;
                break;
            }
            default: {
                d = d6 - (double)n;
            }
        }
        this.m_box.setFrame(d2, d, n2, n);
        return this.m_box;
    }

    public void render(Graphics2D graphics2D, VisualItem visualItem) {
        Shape shape = this.getShape(visualItem);
        GraphicsLib.paint(graphics2D, visualItem, this.m_line, this.getStroke(visualItem), this.getRenderType(visualItem));
        if (shape == this.m_box) {
            float f = (float)this.m_box.getMinX();
            float f2 = (float)this.m_box.getMinY() + (float)this.m_ascent;
            GraphicsLib.paint(graphics2D, visualItem, shape, null, 2);
            String string = visualItem.getString(VisualItem.LABEL);
            graphics2D.setFont(visualItem.getFont());
            graphics2D.setColor(ColorLib.getColor(visualItem.getTextColor()));
            graphics2D.drawString(string, f, f2);
        }
    }

    public boolean locatePoint(Point2D point2D, VisualItem visualItem) {
        Shape shape = this.getShape(visualItem);
        if (shape == null) {
            return false;
        }
        if (shape == this.m_box && this.m_box.contains(point2D)) {
            return true;
        }
        double d = Math.max(2.0, visualItem.getSize());
        double d2 = d / 2.0;
        return shape.intersects(point2D.getX() - d2, point2D.getY() - d2, d, d);
    }

    public void setBounds(VisualItem visualItem) {
        if (!this.m_manageBounds) {
            return;
        }
        Shape shape = this.getShape(visualItem);
        if (shape == null) {
            visualItem.setBounds(visualItem.getX(), visualItem.getY(), 0.0, 0.0);
        } else if (shape == this.m_line) {
            GraphicsLib.setBounds(visualItem, shape, this.getStroke(visualItem));
        } else {
            this.m_box.add(this.m_line.getX1(), this.m_line.getY1());
            this.m_box.add(this.m_line.getX2(), this.m_line.getY2());
            visualItem.setBounds(this.m_box.getMinX(), this.m_box.getMinY(), this.m_box.getWidth(), this.m_box.getHeight());
        }
    }
}

