/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.search;

import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class LuceneSearcher {
    public static final String FIELD = "prefuse-text";
    public static final String ID = "prefuse-id";
    private Directory directory;
    private Analyzer analyzer;
    private String[] fields;
    private Searcher searcher;
    private IndexReader reader;
    private IndexWriter writer;
    private boolean m_readMode = true;
    private boolean m_readOnly = false;
    private HashMap m_hitCountCache = new HashMap();

    public LuceneSearcher() {
        this((Directory)new RAMDirectory(), FIELD, false);
    }

    public LuceneSearcher(Directory directory) {
        this(directory, FIELD, false);
    }

    public LuceneSearcher(Directory directory, String string, boolean bl) {
        this(directory, new String[]{string}, bl);
    }

    public LuceneSearcher(Directory directory, String[] stringArray, boolean bl) {
        this.directory = directory;
        this.analyzer = new StandardAnalyzer();
        this.fields = (String[])stringArray.clone();
        try {
            this.writer = new IndexWriter(this.directory, this.analyzer, !bl);
            this.writer.close();
            this.writer = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.m_readOnly = bl;
        if (!bl) {
            this.setReadMode(false);
        } else {
            this.m_readMode = false;
            this.setReadMode(true);
        }
    }

    public boolean setReadMode(boolean bl) {
        if (this.m_readOnly && !bl) {
            return false;
        }
        if (this.m_readMode == bl) {
            return true;
        }
        if (!bl) {
            try {
                if (this.searcher != null) {
                    this.searcher.close();
                }
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            try {
                this.writer = new IndexWriter(this.directory, this.analyzer, false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        try {
            if (this.writer != null) {
                this.writer.optimize();
                this.writer.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        try {
            this.reader = IndexReader.open((Directory)this.directory);
            this.searcher = new IndexSearcher(this.reader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        this.m_readMode = bl;
        return true;
    }

    public Hits search(String string) throws ParseException, IOException {
        if (this.m_readMode) {
            Query query = this.fields.length == 1 ? QueryParser.parse((String)string, (String)this.fields[0], (Analyzer)this.analyzer) : MultiFieldQueryParser.parse((String)string, (String[])this.fields, (Analyzer)this.analyzer);
            return this.searcher.search(query);
        }
        throw new IllegalStateException("Searches can only be performed when the LuceneSearcher is in read mode");
    }

    public int numHits(String string) throws ParseException, IOException {
        Integer n = (Integer)this.m_hitCountCache.get(string);
        if (n == null) {
            Hits hits = this.search(string);
            n = new Integer(hits.length());
            this.m_hitCountCache.put(string, n);
        }
        return n;
    }

    public void addDocument(Document document) {
        if (!this.m_readMode) {
            try {
                this.writer.addDocument(document);
                this.m_hitCountCache.clear();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Documents can not be added to the index unlessthe LuceneSearcher is not in read mode");
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public String[] getFields() {
        return (String[])this.fields.clone();
    }

    public void setFields(String[] stringArray) {
        this.fields = (String[])stringArray.clone();
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public Searcher getIndexSearcher() {
        return this.searcher;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }
}

