/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.search;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Hits;
import prefuse.data.Tuple;
import prefuse.data.search.LuceneSearcher;
import prefuse.data.search.SearchTupleSet;
import prefuse.util.StringLib;
import prefuse.util.collections.IntObjectHashMap;

public class KeywordSearchTupleSet
extends SearchTupleSet {
    private static final Logger s_logger = Logger.getLogger(KeywordSearchTupleSet.class.getName());
    protected IntObjectHashMap m_map = new IntObjectHashMap();
    protected String m_query = "";
    protected LuceneSearcher m_lucene = null;
    protected boolean m_storeTermVectors = false;
    protected int m_id = 1;

    public KeywordSearchTupleSet() {
        this.m_lucene = new LuceneSearcher();
    }

    public KeywordSearchTupleSet(LuceneSearcher luceneSearcher) {
        this.m_lucene = luceneSearcher;
    }

    public String getQuery() {
        return this.m_query;
    }

    public void search(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equals(this.m_query)) {
            return;
        }
        Tuple[] tupleArray = this.clearInternal();
        this.m_query = string;
        string.trim();
        if (string.length() == 0) {
            this.fireTupleEvent(null, -1);
            return;
        }
        this.m_lucene.setReadMode(true);
        try {
            Hits hits = this.m_lucene.search(string);
            for (int i = 0; i < hits.length(); ++i) {
                Tuple tuple = this.getMatchingTuple(hits.doc(i));
                this.addInternal(tuple);
            }
            Tuple[] tupleArray2 = this.getTupleCount() > 0 ? this.toArray() : null;
            this.fireTupleEvent(tupleArray2, tupleArray);
        }
        catch (ParseException parseException) {
            s_logger.warning("Lucene query parse exception.\n" + StringLib.getStackTrace(parseException));
        }
        catch (IOException iOException) {
            s_logger.warning("Lucene IO exception.\n" + StringLib.getStackTrace(iOException));
        }
    }

    protected Tuple getMatchingTuple(Document document) {
        int n = Integer.parseInt(document.get("prefuse-id"));
        return (Tuple)this.m_map.get(n);
    }

    public void index(Tuple tuple, String string) {
        this.m_lucene.setReadMode(false);
        String string2 = tuple.getString(string);
        if (string2 == null) {
            return;
        }
        int n = this.m_id++;
        this.m_lucene.addDocument(this.getDocument(n, string2));
        this.m_map.put(n, tuple);
    }

    public boolean isUnindexSupported() {
        return false;
    }

    public void unindex(Tuple tuple, String string) {
        throw new UnsupportedOperationException();
    }

    protected Document getDocument(int n, String string) {
        Document document = new Document();
        document.add(Field.Text((String)"prefuse-text", (String)string, (boolean)this.m_storeTermVectors));
        document.add(Field.Keyword((String)"prefuse-id", (String)String.valueOf(n)));
        return document;
    }

    public LuceneSearcher getLuceneSearcher() {
        return this.m_lucene;
    }

    public IntObjectHashMap getTupleMap() {
        return (IntObjectHashMap)this.m_map.clone();
    }

    public void clear() {
        this.m_lucene = new LuceneSearcher();
        super.clear();
    }
}

