/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.query;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import prefuse.data.expression.ColumnExpression;
import prefuse.data.expression.Literal;
import prefuse.data.expression.RangePredicate;
import prefuse.data.query.DynamicQueryBinding;
import prefuse.data.query.NumberRangeModel;
import prefuse.data.query.ObjectRangeModel;
import prefuse.data.tuple.TupleSet;
import prefuse.util.DataLib;
import prefuse.util.TypeLib;
import prefuse.util.ui.JRangeSlider;
import prefuse.util.ui.ValuedRangeModel;

public class RangeQueryBinding
extends DynamicQueryBinding {
    private Class m_type;
    private Listener m_lstnr;
    private ValuedRangeModel m_model;
    private boolean m_ordinal;
    private static FocusListener s_sliderAdj;

    public RangeQueryBinding(TupleSet tupleSet, String string) {
        this(tupleSet, string, false);
    }

    public RangeQueryBinding(TupleSet tupleSet, String string, boolean bl) {
        super(tupleSet, string);
        this.m_type = DataLib.inferType(tupleSet, string);
        this.m_ordinal = bl;
        this.m_lstnr = new Listener();
        this.initPredicate();
        this.initModel();
    }

    private void initPredicate() {
        Object object = DataLib.min(this.m_tuples, this.m_field).get(this.m_field);
        Object object2 = DataLib.max(this.m_tuples, this.m_field).get(this.m_field);
        Literal literal = Literal.getLiteral(object, this.m_type);
        Literal literal2 = Literal.getLiteral(object2, this.m_type);
        ColumnExpression columnExpression = new ColumnExpression(this.m_field);
        RangePredicate rangePredicate = new RangePredicate(columnExpression, literal, literal2);
        this.setPredicate(rangePredicate);
    }

    public void initModel() {
        if (this.m_model != null) {
            this.m_model.removeChangeListener(this.m_lstnr);
        }
        DefaultBoundedRangeModel defaultBoundedRangeModel = null;
        if (TypeLib.isNumericType(this.m_type) && !this.m_ordinal) {
            Number number = (Number)DataLib.min(this.m_tuples, this.m_field).get(this.m_field);
            Number number2 = (Number)DataLib.max(this.m_tuples, this.m_field).get(this.m_field);
            defaultBoundedRangeModel = new NumberRangeModel(number, number2, number, number2);
        } else {
            defaultBoundedRangeModel = new ObjectRangeModel(DataLib.ordinalArray(this.m_tuples, this.m_field));
        }
        this.m_model = defaultBoundedRangeModel;
        this.m_model.addChangeListener(this.m_lstnr);
    }

    public ValuedRangeModel getModel() {
        return this.m_model;
    }

    public NumberRangeModel getNumberModel() {
        return this.m_model instanceof NumberRangeModel ? (NumberRangeModel)this.m_model : null;
    }

    public ObjectRangeModel getObjectModel() {
        return this.m_model instanceof ObjectRangeModel ? (ObjectRangeModel)this.m_model : null;
    }

    public JComponent createComponent() {
        return this.createHorizontalRangeSlider();
    }

    public JRangeSlider createHorizontalRangeSlider() {
        return this.createRangeSlider(1, 0);
    }

    public JRangeSlider createVerticalRangeSlider() {
        return this.createRangeSlider(0, 1);
    }

    public JRangeSlider createRangeSlider(int n, int n2) {
        return new JRangeSlider(this.m_model, n, n2);
    }

    public JSlider createSlider() {
        JSlider jSlider = new JSlider(this.m_model);
        jSlider.addFocusListener(RangeQueryBinding.getSliderAdjuster());
        return jSlider;
    }

    private static synchronized FocusListener getSliderAdjuster() {
        if (s_sliderAdj == null) {
            s_sliderAdj = new SliderAdjuster();
        }
        return s_sliderAdj;
    }

    private class Listener
    implements ChangeListener {
        private Listener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ValuedRangeModel valuedRangeModel = (ValuedRangeModel)changeEvent.getSource();
            Object object = valuedRangeModel.getLowValue();
            Object object2 = valuedRangeModel.getHighValue();
            RangePredicate rangePredicate = (RangePredicate)RangeQueryBinding.this.m_query;
            rangePredicate.setLeftExpression(Literal.getLiteral(object, RangeQueryBinding.this.m_type));
            rangePredicate.setRightExpression(Literal.getLiteral(object2, RangeQueryBinding.this.m_type));
        }
    }

    private static class SliderAdjuster
    implements FocusListener {
        private SliderAdjuster() {
        }

        public void focusGained(FocusEvent focusEvent) {
            ((JSlider)focusEvent.getSource()).setExtent(0);
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

