/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.io.AbstractGraphWriter;
import prefuse.data.io.DataIOException;
import prefuse.data.io.TreeMLReader;
import prefuse.util.io.XMLWriter;

public class TreeMLWriter
extends AbstractGraphWriter {
    private static final HashMap TYPES = new HashMap();

    public void writeGraph(Graph graph, OutputStream outputStream) throws DataIOException {
        Schema schema = graph.getNodeTable().getSchema();
        this.checkTreeMLSchema(schema);
        XMLWriter xMLWriter = new XMLWriter(new PrintWriter(outputStream));
        xMLWriter.begin();
        xMLWriter.comment("prefuse TreeML Writer | " + new Date(System.currentTimeMillis()));
        xMLWriter.start("tree");
        xMLWriter.start("declarations");
        String[] stringArray = new String[]{"name", "type"};
        String[] stringArray2 = new String[2];
        for (int i = 0; i < schema.getColumnCount(); ++i) {
            stringArray2[0] = schema.getColumnName(i);
            stringArray2[1] = (String)TYPES.get(schema.getColumnType(i));
            xMLWriter.tag("attributeDecl", stringArray, stringArray2, 2);
        }
        xMLWriter.end();
        xMLWriter.println();
        stringArray[0] = "name";
        stringArray[1] = "value";
        Node node = graph.getSpanningTree().getRoot();
        while (node != null) {
            boolean bl;
            boolean bl2 = bl = node.getChildCount() == 0;
            if (bl) {
                xMLWriter.start("leaf");
            } else {
                xMLWriter.start("branch");
            }
            if (schema.getColumnCount() > 0) {
                for (int i = 0; i < schema.getColumnCount(); ++i) {
                    stringArray2[0] = schema.getColumnName(i);
                    stringArray2[1] = node.getString(stringArray2[0]);
                    xMLWriter.tag("attribute", stringArray, stringArray2, 2);
                }
            }
            node = this.nextNode(node, xMLWriter);
        }
        xMLWriter.end();
        xMLWriter.finish();
    }

    private Node nextNode(Node node, XMLWriter xMLWriter) {
        Node node2 = node.getChild(0);
        if (node2 == null) {
            node2 = node.getNextSibling();
            if (node2 != null) {
                xMLWriter.end();
            } else {
                xMLWriter.end();
                for (node2 = node.getParent(); node2 != null; node2 = node2.getParent()) {
                    Node node3 = node2.getNextSibling();
                    if (node3 != null) {
                        node2 = node3;
                        xMLWriter.end();
                        break;
                    }
                    xMLWriter.end();
                }
            }
        }
        return node2;
    }

    private void checkTreeMLSchema(Schema schema) throws DataIOException {
        for (int i = 0; i < schema.getColumnCount(); ++i) {
            Class clazz = schema.getColumnType(i);
            if (TYPES.get(clazz) != null) continue;
            throw new DataIOException("Data type unsupported by the TreeML format: " + clazz.getName());
        }
    }

    static {
        TYPES.put(Integer.TYPE, "Int");
        TYPES.put(Long.TYPE, "Long");
        TYPES.put(Float.TYPE, "Float");
        TYPES.put(Double.TYPE, "Real");
        TYPES.put(Boolean.TYPE, "Boolean");
        TYPES.put(String.class, "String");
        TYPES.put(Date.class, "Date");
    }

    public static interface Tokens
    extends TreeMLReader.Tokens {
    }
}

