/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import prefuse.data.io.AbstractTextTableReader;
import prefuse.data.io.TableReadListener;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.ParserFactory;

public class DelimitedTextTableReader
extends AbstractTextTableReader {
    private String m_delim;

    public DelimitedTextTableReader() {
        this("\t");
    }

    public DelimitedTextTableReader(ParserFactory parserFactory) {
        this("\t", parserFactory);
    }

    public DelimitedTextTableReader(String string) {
        this.m_delim = string;
    }

    public DelimitedTextTableReader(String string, ParserFactory parserFactory) {
        super(parserFactory);
        this.m_delim = string;
    }

    protected void read(InputStream inputStream, TableReadListener tableReadListener) throws IOException, DataParseException {
        String string;
        int n = 0;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            ++n;
            String[] stringArray = string.split(this.m_delim);
            for (int i = 0; i < stringArray.length; ++i) {
                tableReadListener.readValue(n, i + 1, stringArray[i]);
            }
        }
    }
}

