/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data;

import java.util.Iterator;
import java.util.logging.Logger;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.SpanningTree;
import prefuse.data.Table;
import prefuse.util.PrefuseConfig;
import prefuse.util.collections.IntIterator;

public class Tree
extends Graph {
    private static final Logger s_logger = Logger.getLogger(Tree.class.getName());
    public static final String DEFAULT_SOURCE_KEY = PrefuseConfig.get("data.tree.sourceKey");
    public static final String DEFAULT_TARGET_KEY = PrefuseConfig.get("data.tree.targetKey");
    protected int m_root = -1;
    protected static final String CHILDINDEX = "_childIndex";
    protected static final Schema TREE_LINKS_SCHEMA = new Schema();

    public Tree() {
        super(new Table(), false);
    }

    public Tree(Table table, Table table2) {
        this(table, table2, DEFAULT_SOURCE_KEY, DEFAULT_TARGET_KEY);
    }

    public Tree(Table table, Table table2, String string, String string2) {
        this(table, table2, DEFAULT_NODE_KEY, string, string2);
    }

    public Tree(Table table, Table table2, String string, String string2, String string3) {
        super(table, table2, false, string, string2, string3);
        IntIterator intIterator = table.rows();
        while (intIterator.hasNext()) {
            int n = intIterator.nextInt();
            if (this.getParent(n) >= 0) continue;
            this.m_root = n;
            break;
        }
    }

    void setRoot(Node node) {
        this.m_root = node.getRow();
    }

    protected Table createLinkTable() {
        Table table = super.createLinkTable();
        table.addColumns(TREE_LINKS_SCHEMA);
        return table;
    }

    protected void updateDegrees(int n, int n2, int n3, int n4) {
        super.updateDegrees(n, n2, n3, n4);
        int n5 = this.getOutDegree(n2);
        if (n4 > 0) {
            this.m_links.setInt(n3, CHILDINDEX, n5 - 1);
        } else if (n4 < 0) {
            int[] nArray = (int[])this.m_links.get(n2, "_outlinks");
            for (int i = 0; i < n5; ++i) {
                int n6 = this.getTargetNode(nArray[i]);
                this.m_links.setInt(n6, CHILDINDEX, i);
            }
            this.m_links.setInt(n3, CHILDINDEX, -1);
        }
    }

    public int addRootRow() {
        if (this.getNodeCount() != 0) {
            throw new IllegalStateException("Can only add a root node to an empty tree");
        }
        this.m_root = this.addNodeRow();
        return this.m_root;
    }

    public Node addRoot() {
        return this.getNode(this.addRootRow());
    }

    public int addChild(int n) {
        int n2 = super.addNodeRow();
        this.addChildEdge(n, n2);
        return n2;
    }

    public Node addChild(Node node) {
        this.nodeCheck(node, true);
        return this.getNode(this.addChild(node.getRow()));
    }

    public int addChildEdge(int n, int n2) {
        return super.addEdge(n, n2);
    }

    public Edge addChildEdge(Node node, Node node2) {
        this.nodeCheck(node, true);
        this.nodeCheck(node2, true);
        return this.getEdge(this.addChildEdge(node.getRow(), node2.getRow()));
    }

    public boolean removeChildEdge(int n) {
        return this.removeChild(this.getTargetNode(n));
    }

    public boolean removeChildEdge(Edge edge) {
        this.edgeCheck(edge, true);
        return this.removeChild(this.getTargetNode(edge.getRow()));
    }

    public boolean removeChild(int n) {
        while (this.getChildCount(n) > 0) {
            this.removeChild(this.getLastChildRow(n));
        }
        return this.removeNode(n);
    }

    public boolean removeChild(Node node) {
        this.nodeCheck(node, true);
        return this.removeChild(node.getRow());
    }

    public int getRootRow() {
        return this.m_root;
    }

    public Node getRoot() {
        return (Node)this.m_nodeTuples.getTuple(this.m_root);
    }

    public int getChildRow(int n, int n2) {
        int n3 = this.getChildCount(n);
        if (n2 < 0 || n2 >= n3) {
            return -1;
        }
        int[] nArray = (int[])this.m_links.get(n, "_outlinks");
        return this.getTargetNode(nArray[n2]);
    }

    public Node getChild(Node node, int n) {
        int n2 = this.getChildRow(node.getRow(), n);
        return n2 < 0 ? null : this.getNode(n2);
    }

    public int getChildIndex(int n, int n2) {
        if (this.getParent(n2) != n) {
            return -1;
        }
        return this.m_links.getInt(n2, CHILDINDEX);
    }

    public int getChildIndex(Node node, Node node2) {
        return this.getChildIndex(node.getRow(), node2.getRow());
    }

    public int getFirstChildRow(int n) {
        return this.getChildRow(n, 0);
    }

    public Node getFirstChild(Node node) {
        return this.getChild(node, 0);
    }

    public int getLastChildRow(int n) {
        return this.getChildRow(n, this.getChildCount(n) - 1);
    }

    public Node getLastChild(Node node) {
        return this.getChild(node, node.getChildCount() - 1);
    }

    public int getPreviousSiblingRow(int n) {
        int n2 = this.getParent(n);
        if (n2 < 0) {
            return -1;
        }
        int[] nArray = (int[])this.m_links.get(n2, "_outlinks");
        int n3 = this.m_links.getInt(n, CHILDINDEX);
        return n3 <= 0 ? -1 : this.getTargetNode(nArray[n3 - 1]);
    }

    public Node getPreviousSibling(Node node) {
        int n = this.getPreviousSiblingRow(node.getRow());
        return n < 0 ? null : this.getNode(n);
    }

    public int getNextSiblingRow(int n) {
        int n2 = this.getParent(n);
        if (n2 < 0) {
            return -1;
        }
        int[] nArray = (int[])this.m_links.get(n2, "_outlinks");
        int n3 = this.m_links.getInt(n, CHILDINDEX);
        int n4 = this.getChildCount(n2) - 1;
        return n3 < 0 || n3 >= n4 ? -1 : this.getTargetNode(nArray[n3 + 1]);
    }

    public Node getNextSibling(Node node) {
        int n = this.getNextSiblingRow(node.getRow());
        return n < 0 ? null : this.getNode(n);
    }

    public int getDepth(int n) {
        if (!this.getNodeTable().isValidRow(n)) {
            return -1;
        }
        int n2 = 0;
        int n3 = n;
        while (n3 != this.m_root && n3 >= 0) {
            ++n2;
            n3 = this.getParent(n3);
        }
        return n2;
    }

    public int getChildCount(int n) {
        return this.getOutDegree(n);
    }

    public int getParentEdge(int n) {
        if (this.getInDegree(n) > 0) {
            int[] nArray = (int[])this.m_links.get(n, "_inlinks");
            return nArray[0];
        }
        return -1;
    }

    public Edge getParentEdge(Node node) {
        this.nodeCheck(node, true);
        int n = this.getParentEdge(node.getRow());
        return n < 0 ? null : this.getEdge(n);
    }

    public int getParent(int n) {
        int n2 = this.getParentEdge(n);
        return n2 < 0 ? -1 : this.getSourceNode(n2);
    }

    public Node getParent(Node node) {
        int n = this.getParent(node.getRow());
        return n < 0 ? null : this.getNode(n);
    }

    public IntIterator childEdgeRows(int n) {
        return super.outEdgeRows(n);
    }

    public Iterator childEdges(Node node) {
        return super.outEdges(node);
    }

    public Iterator children(Node node) {
        return super.outNeighbors(node);
    }

    public boolean isValidTree() {
        int n;
        int n2 = this.getNodeCount();
        if (n2 != (n = this.getEdgeCount()) + 1) {
            s_logger.warning("Node/edge counts incorrect.");
            return false;
        }
        int n3 = this.getRootRow();
        IntIterator intIterator = this.getNodeTable().rows();
        while (intIterator.hasNext()) {
            int n4 = intIterator.nextInt();
            int n5 = this.getInDegree(n4);
            if (n4 == n3 && n5 > 0) {
                s_logger.warning("Root node has a parent.");
                return false;
            }
            if (n5 <= 1) continue;
            s_logger.warning("Node " + n4 + " has multiple parents.");
            return false;
        }
        int[] nArray = new int[]{0, n};
        this.isValidHelper(this.getRootRow(), nArray);
        if (nArray[0] > n) {
            s_logger.warning("The tree has non-tree edges in it.");
            return false;
        }
        if (nArray[0] < n) {
            s_logger.warning("Not all of the tree was visited. Only " + nArray[0] + "/" + n + " edges encountered");
            return false;
        }
        return true;
    }

    private void isValidHelper(int n, int[] nArray) {
        IntIterator intIterator = this.childEdgeRows(n);
        int n2 = 0;
        while (intIterator.hasNext()) {
            int n3 = intIterator.nextInt();
            ++n2;
            nArray[0] = nArray[0] + 1;
            int n4 = this.getAdjacentNode(n3, n);
            this.isValidHelper(n4, nArray);
            if (nArray[0] <= nArray[1]) continue;
            return;
        }
    }

    public Tree getSpanningTree() {
        return this.m_spanning == null ? this : this.m_spanning;
    }

    public Tree getSpanningTree(Node node) {
        this.nodeCheck(node, true);
        if (this.m_spanning == null) {
            if (this.m_root == node.getRow()) {
                return this;
            }
            this.m_spanning = new SpanningTree(this, node);
        } else if (this.m_spanning.getRoot() != node) {
            this.m_spanning.buildSpanningTree(node);
        }
        return this.m_spanning;
    }

    static {
        TREE_LINKS_SCHEMA.addColumn(CHILDINDEX, Integer.TYPE, new Integer(-1));
        TREE_LINKS_SCHEMA.lockSchema();
    }
}

