/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import prefuse.Display;
import prefuse.action.layout.Layout;
import prefuse.controls.ControlAdapter;
import prefuse.visual.VisualItem;

public class AnchorUpdateControl
extends ControlAdapter {
    private boolean m_anchorOverItem;
    private Layout[] m_layouts;
    private String m_action;
    private Point2D m_tmp = new Point2D.Double();

    public AnchorUpdateControl(Layout layout) {
        this(layout, null);
    }

    public AnchorUpdateControl(Layout layout, String string) {
        this(new Layout[]{layout}, string);
    }

    public AnchorUpdateControl(Layout layout, String string, boolean bl) {
        this(new Layout[]{layout}, string, bl);
    }

    public AnchorUpdateControl(Layout[] layoutArray, String string) {
        this(layoutArray, string, true);
    }

    public AnchorUpdateControl(Layout[] layoutArray, String string, boolean bl) {
        this.m_layouts = (Layout[])layoutArray.clone();
        this.m_action = string;
        this.m_anchorOverItem = bl;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        for (int i = 0; i < this.m_layouts.length; ++i) {
            this.m_layouts[i].setLayoutAnchor(null);
        }
        this.runAction(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.moveEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.moveEvent(mouseEvent);
    }

    public void itemDragged(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.m_anchorOverItem) {
            this.moveEvent(mouseEvent);
        }
    }

    public void itemMoved(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.m_anchorOverItem) {
            this.moveEvent(mouseEvent);
        }
    }

    public void moveEvent(MouseEvent mouseEvent) {
        Display display = (Display)mouseEvent.getSource();
        display.getAbsoluteCoordinate(mouseEvent.getPoint(), this.m_tmp);
        for (int i = 0; i < this.m_layouts.length; ++i) {
            this.m_layouts[i].setLayoutAnchor(this.m_tmp);
        }
        this.runAction(mouseEvent);
    }

    private void runAction(MouseEvent mouseEvent) {
        if (this.m_action != null) {
            Display display = (Display)mouseEvent.getSource();
            display.getVisualization().run(this.m_action);
        }
    }
}

