/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout;

import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.data.Table;
import prefuse.visual.VisualItem;

public class CollapsedStackLayout
extends Layout {
    private String m_polyField;
    private int m_orientation = 3;
    private boolean m_horiz = false;
    private boolean m_top = false;

    public CollapsedStackLayout(String string) {
        this(string, "_polygon");
    }

    public CollapsedStackLayout(String string, String string2) {
        super(string);
        this.m_polyField = string2;
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public void setOrientation(int n) {
        if (n != 2 && n != 3 && n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid orientation value: " + n);
        }
        this.m_orientation = n;
        this.m_horiz = this.m_orientation == 0 || this.m_orientation == 1;
        this.m_top = this.m_orientation == 2 || this.m_orientation == 0;
    }

    public void run(double d) {
        VisualItem visualItem = null;
        Rectangle2D rectangle2D = this.getLayoutBounds();
        float f = (float)(this.m_horiz ? (this.m_top ? rectangle2D.getMaxX() : rectangle2D.getMinX()) : (this.m_top ? rectangle2D.getMinY() : rectangle2D.getMaxY()));
        int n = this.m_horiz ? 0 : 1;
        Iterator iterator = ((Table)this.m_vis.getGroup(this.m_group)).tuplesReversed();
        while (iterator.hasNext()) {
            VisualItem visualItem2 = (VisualItem)iterator.next();
            boolean bl = visualItem2.isStartVisible();
            boolean bl2 = visualItem2.isVisible();
            if (!bl && bl2) {
                float[] fArray = (float[])visualItem2.get(this.m_polyField);
                if (fArray == null) continue;
                if (visualItem == null) {
                    for (int i = 0; i < fArray.length; i += 2) {
                        fArray[i + n] = f;
                    }
                    continue;
                }
                float[] fArray2 = (float[])visualItem.get(this.m_polyField);
                for (int i = 0; i < fArray.length / 2; i += 2) {
                    float f2 = fArray2[i + n];
                    fArray[fArray.length - 2 - i + n] = f2;
                    fArray[i + n] = f2;
                }
                continue;
            }
            if (!bl || !bl2) continue;
            visualItem = visualItem2;
        }
    }
}

