/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.animate;

import java.awt.geom.Point2D;
import prefuse.Display;
import prefuse.action.ItemAction;
import prefuse.visual.VisualItem;

public class PolarLocationAnimator
extends ItemAction {
    private Point2D m_anchor = new Point2D.Double();
    private String m_linear = null;
    private double ax;
    private double ay;
    private double sx;
    private double sy;
    private double ex;
    private double ey;
    private double x;
    private double y;
    private double dt1;
    private double dt2;
    private double sr;
    private double st;
    private double er;
    private double et;
    private double r;
    private double t;
    private double stt;
    private double ett;

    public PolarLocationAnimator() {
    }

    public PolarLocationAnimator(String string) {
        super(string);
    }

    public PolarLocationAnimator(String string, String string2) {
        super(string);
        this.m_linear = string2;
    }

    private void setAnchor() {
        Display display = this.getVisualization().getDisplay(0);
        this.m_anchor.setLocation(display.getWidth() / 2, display.getHeight() / 2);
        display.getAbsoluteCoordinate(this.m_anchor, this.m_anchor);
        this.ax = this.m_anchor.getX();
        this.ay = this.m_anchor.getY();
    }

    public void run(double d) {
        this.setAnchor();
        super.run(d);
    }

    public void process(VisualItem visualItem, double d) {
        if (this.m_linear != null && visualItem.isInGroup(this.m_linear)) {
            double d2 = visualItem.getStartX();
            visualItem.setX(d2 + d * (visualItem.getEndX() - d2));
            d2 = visualItem.getStartY();
            visualItem.setY(d2 + d * (visualItem.getEndY() - d2));
            return;
        }
        this.sx = visualItem.getStartX() - this.ax;
        this.sy = visualItem.getStartY() - this.ay;
        this.ex = visualItem.getEndX() - this.ax;
        this.ey = visualItem.getEndY() - this.ay;
        this.sr = Math.sqrt(this.sx * this.sx + this.sy * this.sy);
        this.st = Math.atan2(this.sy, this.sx);
        this.er = Math.sqrt(this.ex * this.ex + this.ey * this.ey);
        this.et = Math.atan2(this.ey, this.ex);
        this.stt = this.st < 0.0 ? this.st + Math.PI * 2 : this.st;
        this.ett = this.et < 0.0 ? this.et + Math.PI * 2 : this.et;
        this.dt1 = this.et - this.st;
        this.dt2 = this.ett - this.stt;
        this.t = Math.abs(this.dt1) < Math.abs(this.dt2) ? this.st + d * this.dt1 : this.stt + d * this.dt2;
        this.r = this.sr + d * (this.er - this.sr);
        this.x = Math.round(this.ax + this.r * Math.cos(this.t));
        this.y = Math.round(this.ay + this.r * Math.sin(this.t));
        visualItem.setX(this.x);
        visualItem.setY(this.y);
    }
}

