/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual.tuple;

import java.util.Iterator;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.data.expression.Predicate;
import prefuse.data.util.FilterIterator;
import prefuse.visual.AggregateItem;
import prefuse.visual.AggregateTable;
import prefuse.visual.VisualItem;
import prefuse.visual.tuple.TableVisualItem;

public class TableAggregateItem
extends TableVisualItem
implements AggregateItem {
    protected void init(Table table, Graph graph, int n) {
        this.m_table = table;
        this.m_row = this.m_table.isValidRow(n) ? n : -1;
    }

    public int getAggregateSize() {
        return ((AggregateTable)this.m_table).getAggregateSize(this.m_row);
    }

    public boolean containsItem(VisualItem visualItem) {
        return ((AggregateTable)this.m_table).aggregateContains(this.m_row, visualItem);
    }

    public void addItem(VisualItem visualItem) {
        ((AggregateTable)this.m_table).addToAggregate(this.m_row, visualItem);
    }

    public void removeItem(VisualItem visualItem) {
        ((AggregateTable)this.m_table).removeFromAggregate(this.m_row, visualItem);
    }

    public void removeAllItems() {
        ((AggregateTable)this.m_table).removeAllFromAggregate(this.m_row);
    }

    public Iterator items() {
        return ((AggregateTable)this.m_table).aggregatedTuples(this.m_row);
    }

    public Iterator items(Predicate predicate) {
        return new FilterIterator(((AggregateTable)this.m_table).aggregatedTuples(this.m_row), predicate);
    }
}

