/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class CopyOnWriteArrayList
implements List,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    private volatile transient Object[] array;

    public Object[] getArray() {
        return this.array;
    }

    void setArray(Object[] objectArray) {
        this.array = objectArray;
    }

    public CopyOnWriteArrayList() {
        this.setArray(new Object[0]);
    }

    public CopyOnWriteArrayList(Collection collection) {
        Object[] objectArray = new Object[collection.size()];
        int n = 0;
        for (Object e : collection) {
            objectArray[n++] = e;
        }
        this.setArray(objectArray);
    }

    public CopyOnWriteArrayList(Object[] objectArray) {
        this.copyIn(objectArray, 0, objectArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyIn(Object[] objectArray, int n, int n2) {
        int n3 = n + n2;
        if (n3 > objectArray.length) {
            throw new IndexOutOfBoundsException();
        }
        Object[] objectArray2 = CopyOnWriteArrayList.copyOfRange(objectArray, n, n3, Object[].class);
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            this.setArray(objectArray2);
        }
    }

    public int size() {
        return this.getArray().length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static boolean eq(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private static int indexOf(Object object, Object[] objectArray, int n, int n2) {
        if (object == null) {
            for (int i = n; i < n2; ++i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i < n2; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static int lastIndexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            for (int i = n; i >= 0; --i) {
                if (objectArray[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n; i >= 0; --i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean contains(Object object) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.indexOf(object, objectArray, 0, objectArray.length) >= 0;
    }

    public int indexOf(Object object) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.indexOf(object, objectArray, 0, objectArray.length);
    }

    public int indexOf(Object object, int n) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.indexOf(object, objectArray, n, objectArray.length);
    }

    public int lastIndexOf(Object object) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.lastIndexOf(object, objectArray, objectArray.length - 1);
    }

    public int lastIndexOf(Object object, int n) {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.lastIndexOf(object, objectArray, n);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object[] toArray() {
        Object[] objectArray = this.getArray();
        return CopyOnWriteArrayList.copyOf(objectArray, objectArray.length);
    }

    public Object[] toArray(Object[] objectArray) {
        Object[] objectArray2 = this.getArray();
        int n = objectArray2.length;
        if (objectArray.length < n) {
            return CopyOnWriteArrayList.copyOf(objectArray2, n, objectArray.getClass());
        }
        System.arraycopy(objectArray2, 0, objectArray, 0, n);
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public Object get(int n) {
        return this.getArray()[n];
    }

    public synchronized Object set(int n, Object object) {
        Object[] objectArray = this.getArray();
        int n2 = objectArray.length;
        Object object2 = objectArray[n];
        if (object2 != object) {
            Object[] objectArray2 = CopyOnWriteArrayList.copyOf(objectArray, n2);
            objectArray2[n] = object;
            this.setArray(objectArray2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] objectArray = this.getArray();
            int n = objectArray.length;
            Object[] objectArray2 = CopyOnWriteArrayList.copyOf(objectArray, n + 1);
            objectArray2[n] = object;
            this.setArray(objectArray2);
        }
        return true;
    }

    public synchronized void add(int n, Object object) {
        Object[] objectArray;
        Object[] objectArray2 = this.getArray();
        int n2 = objectArray2.length;
        if (n > n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
        int n3 = n2 - n;
        if (n3 == 0) {
            objectArray = CopyOnWriteArrayList.copyOf(objectArray2, n2 + 1);
        } else {
            objectArray = new Object[n2 + 1];
            System.arraycopy(objectArray2, 0, objectArray, 0, n);
            System.arraycopy(objectArray2, n, objectArray, n + 1, n3);
        }
        objectArray[n] = object;
        this.setArray(objectArray);
    }

    public synchronized Object remove(int n) {
        Object[] objectArray = this.getArray();
        int n2 = objectArray.length;
        Object object = objectArray[n];
        int n3 = n2 - n - 1;
        if (n3 == 0) {
            this.setArray(CopyOnWriteArrayList.copyOf(objectArray, n2 - 1));
        } else {
            Object[] objectArray2 = new Object[n2 - 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            System.arraycopy(objectArray, n + 1, objectArray2, n, n3);
            this.setArray(objectArray2);
        }
        return object;
    }

    public synchronized boolean remove(Object object) {
        Object[] objectArray = this.getArray();
        int n = objectArray.length;
        if (n != 0) {
            int n2 = n - 1;
            Object[] objectArray2 = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                if (CopyOnWriteArrayList.eq(object, objectArray[i])) {
                    for (int j = i + 1; j < n; ++j) {
                        objectArray2[j - 1] = objectArray[j];
                    }
                    this.setArray(objectArray2);
                    return true;
                }
                objectArray2[i] = objectArray[i];
            }
            if (CopyOnWriteArrayList.eq(object, objectArray[n2])) {
                this.setArray(objectArray2);
                return true;
            }
        }
        return false;
    }

    private synchronized void removeRange(int n, int n2) {
        Object[] objectArray = this.getArray();
        int n3 = objectArray.length;
        if (n < 0 || n >= n3 || n2 > n3 || n2 < n) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n3 - (n2 - n);
        int n5 = n3 - n2;
        if (n5 == 0) {
            this.setArray(CopyOnWriteArrayList.copyOf(objectArray, n4));
        } else {
            Object[] objectArray2 = new Object[n4];
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            System.arraycopy(objectArray, n2, objectArray2, n, n5);
            this.setArray(objectArray2);
        }
    }

    public synchronized boolean addIfAbsent(Object object) {
        Object[] objectArray = this.getArray();
        int n = objectArray.length;
        Object[] objectArray2 = new Object[n + 1];
        for (int i = 0; i < n; ++i) {
            if (CopyOnWriteArrayList.eq(object, objectArray[i])) {
                return false;
            }
            objectArray2[i] = objectArray[i];
        }
        objectArray2[n] = object;
        this.setArray(objectArray2);
        return true;
    }

    public boolean containsAll(Collection collection) {
        Object[] objectArray = this.getArray();
        int n = objectArray.length;
        for (Object e : collection) {
            if (CopyOnWriteArrayList.indexOf(e, objectArray, 0, n) >= 0) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean removeAll(Collection collection) {
        Object[] objectArray = this.getArray();
        int n = objectArray.length;
        if (n != 0) {
            int n2 = 0;
            Object[] objectArray2 = new Object[n];
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                if (collection.contains(object)) continue;
                objectArray2[n2++] = object;
            }
            if (n2 != n) {
                this.setArray(CopyOnWriteArrayList.copyOfRange(objectArray2, 0, n2, Object[].class));
                return true;
            }
        }
        return false;
    }

    public synchronized boolean retainAll(Collection collection) {
        Object[] objectArray = this.getArray();
        int n = objectArray.length;
        if (n != 0) {
            int n2 = 0;
            Object[] objectArray2 = new Object[n];
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                if (!collection.contains(object)) continue;
                objectArray2[n2++] = object;
            }
            if (n2 != n) {
                this.setArray(CopyOnWriteArrayList.copyOfRange(objectArray2, 0, n2, Object[].class));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAllAbsent(Collection collection) {
        int n = collection.size();
        if (n == 0) {
            return 0;
        }
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] objectArray = this.getArray();
            int n2 = objectArray.length;
            Object[] objectArray2 = new Object[n];
            int n3 = 0;
            for (Object e : collection) {
                if (CopyOnWriteArrayList.indexOf(e, objectArray, 0, n2) >= 0 || CopyOnWriteArrayList.indexOf(e, objectArray2, 0, n3) >= 0) continue;
                objectArray2[n3++] = e;
            }
            if (n3 != 0) {
                Object[] objectArray3 = new Object[n2 + n3];
                System.arraycopy(objectArray, 0, objectArray3, 0, n2);
                System.arraycopy(objectArray2, 0, objectArray3, n2, n3);
                this.setArray(objectArray3);
            }
            return n3;
        }
    }

    public synchronized void clear() {
        this.setArray(new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        int n = collection.size();
        if (n == 0) {
            return false;
        }
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] objectArray = this.getArray();
            int n2 = objectArray.length;
            Object[] objectArray2 = new Object[n2 + n];
            System.arraycopy(objectArray, 0, objectArray2, 0, n2);
            for (Object e : collection) {
                objectArray2[n2++] = e;
            }
            this.setArray(objectArray2);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int n, Collection collection) {
        int n2 = collection.size();
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] objectArray;
            Object[] objectArray2 = this.getArray();
            int n3 = objectArray2.length;
            if (n > n3 || n < 0) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n3);
            }
            if (n2 == 0) {
                return false;
            }
            int n4 = n3 - n;
            if (n4 == 0) {
                objectArray = CopyOnWriteArrayList.copyOf(objectArray2, n3 + n2);
            } else {
                objectArray = new Object[n3 + n2];
                System.arraycopy(objectArray2, 0, objectArray, 0, n);
                System.arraycopy(objectArray2, n, objectArray, n + n2, n4);
            }
            for (Object e : collection) {
                objectArray[n++] = e;
            }
            this.setArray(objectArray);
            return true;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = this.getArray();
        int n = objectArray.length;
        objectOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeObject(objectArray[i]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = objectInputStream.readObject();
        }
        this.setArray(objectArray);
    }

    public String toString() {
        Object[] objectArray = this.getArray();
        int n = objectArray.length - 1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append(String.valueOf(objectArray[i]));
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator listIterator = this.listIterator();
        ListIterator listIterator2 = list.listIterator();
        while (listIterator.hasNext()) {
            if (CopyOnWriteArrayList.eq(listIterator.next(), listIterator2.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (Object object : this.getArray()) {
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    public Iterator iterator() {
        return new COWIterator(this.getArray(), 0);
    }

    public ListIterator listIterator() {
        return new COWIterator(this.getArray(), 0);
    }

    public ListIterator listIterator(int n) {
        Object[] objectArray = this.getArray();
        int n2 = objectArray.length;
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new COWIterator(this.getArray(), n);
    }

    public synchronized List subList(int n, int n2) {
        Object[] objectArray = this.getArray();
        int n3 = objectArray.length;
        if (n < 0 || n2 > n3 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return new COWSubList(this, n, n2);
    }

    private static Object[] copyOfRange(Object[] objectArray, int n, int n2, Class clazz) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        Object[] objectArray2 = (Object[])Array.newInstance(clazz.getComponentType(), n3);
        System.arraycopy(objectArray, n, objectArray2, 0, Math.min(objectArray.length - n, n3));
        return objectArray2;
    }

    private static Object[] copyOf(Object[] objectArray, int n, Class clazz) {
        Object[] objectArray2 = (Object[])Array.newInstance(clazz.getComponentType(), n);
        System.arraycopy(objectArray, 0, objectArray2, 0, Math.min(objectArray.length, n));
        return objectArray2;
    }

    private static Object[] copyOf(Object[] objectArray, int n) {
        return CopyOnWriteArrayList.copyOf(objectArray, n, objectArray.getClass());
    }

    private static class COWSubListIterator
    implements ListIterator {
        private final ListIterator i;
        private final int offset;
        private final int size;

        private COWSubListIterator(List list, int n, int n2, int n3) {
            this.offset = n2;
            this.size = n3;
            this.i = list.listIterator(n + n2);
        }

        public boolean hasNext() {
            return this.nextIndex() < this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                return this.i.next();
            }
            throw new NoSuchElementException();
        }

        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        public Object previous() {
            if (this.hasPrevious()) {
                return this.i.previous();
            }
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return this.i.nextIndex() - this.offset;
        }

        public int previousIndex() {
            return this.i.previousIndex() - this.offset;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private static class COWSubList
    extends AbstractList {
        private final CopyOnWriteArrayList l;
        private final int offset;
        private int size;
        private Object[] expectedArray;

        private COWSubList(CopyOnWriteArrayList copyOnWriteArrayList, int n, int n2) {
            this.l = copyOnWriteArrayList;
            this.expectedArray = this.l.getArray();
            this.offset = n;
            this.size = n2 - n;
        }

        private void checkForComodification() {
            if (this.l.getArray() != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        private void rangeCheck(int n) {
            if (n < 0 || n >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ",Size: " + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int n, Object object) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                Object object2 = this.l.set(n + this.offset, object);
                this.expectedArray = this.l.getArray();
                return object2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(int n) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                return this.l.get(n + this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int n, Object object) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(n + this.offset, object);
                this.expectedArray = this.l.getArray();
                ++this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                this.l.removeRange(this.offset, this.offset + this.size);
                this.expectedArray = this.l.getArray();
                this.size = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int n) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                Object object = this.l.remove(n + this.offset);
                this.expectedArray = this.l.getArray();
                --this.size;
                return object;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator iterator() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return new COWSubListIterator(this.l, 0, this.offset, this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator listIterator(int n) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
                }
                return new COWSubListIterator(this.l, n, this.offset, this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List subList(int n, int n2) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n2 > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                return new COWSubList(this.l, n + this.offset, n2 + this.offset);
            }
        }
    }

    private static class COWIterator
    implements ListIterator {
        private final Object[] snapshot;
        private int cursor;

        private COWIterator(Object[] objectArray, int n) {
            this.cursor = n;
            this.snapshot = objectArray;
        }

        public boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        public Object next() {
            try {
                return this.snapshot[this.cursor++];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public Object previous() {
            try {
                return this.snapshot[--this.cursor];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

