/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import java.util.Comparator;
import prefuse.data.Table;
import prefuse.data.column.Column;
import prefuse.data.event.ColumnListener;
import prefuse.data.event.TableListener;
import prefuse.data.util.Index;
import prefuse.data.util.RowManager;
import prefuse.util.collections.BooleanIntSortedMap;
import prefuse.util.collections.DoubleIntSortedMap;
import prefuse.util.collections.FloatIntSortedMap;
import prefuse.util.collections.IncompatibleComparatorException;
import prefuse.util.collections.IntIntSortedMap;
import prefuse.util.collections.IntIterator;
import prefuse.util.collections.IntSortedMap;
import prefuse.util.collections.LongIntSortedMap;
import prefuse.util.collections.ObjectIntSortedMap;
import prefuse.util.collections.SortedMapFactory;

public class TreeIndex
implements Index,
ColumnListener,
TableListener {
    protected Table m_table;
    protected RowManager m_rows;
    protected Column m_col;
    protected IntSortedMap m_index;
    protected boolean m_reindex;
    protected int m_colidx;

    public TreeIndex(Table table, RowManager rowManager, Column column, Comparator comparator) throws IncompatibleComparatorException {
        this.m_table = table;
        this.m_rows = rowManager;
        this.m_col = column;
        this.m_index = SortedMapFactory.getMap(column.getColumnType(), comparator, false);
        this.index();
        this.m_col.addColumnListener(this);
        this.m_table.addTableListener(this);
    }

    public void dispose() {
        this.m_col.removeColumnListener(this);
        this.m_table.removeTableListener(this);
    }

    public Comparator getComparator() {
        return this.m_index.comparator();
    }

    public int size() {
        return this.m_index.size();
    }

    private int getColumnIndex() {
        if (this.m_table.getColumn(this.m_colidx) != this.m_col) {
            this.m_colidx = this.m_table.getColumnNumber(this.m_col);
        }
        return this.m_colidx;
    }

    public void index() {
        int n;
        this.m_index.clear();
        this.m_colidx = n = this.getColumnIndex();
        IntIterator intIterator = this.m_rows.rows();
        if (this.m_index instanceof IntIntSortedMap) {
            IntIntSortedMap intIntSortedMap = (IntIntSortedMap)this.m_index;
            while (intIterator.hasNext()) {
                int n2 = intIterator.nextInt();
                intIntSortedMap.put(this.m_col.getInt(this.m_table.getColumnRow(n2, n)), n2);
            }
        } else if (this.m_index instanceof LongIntSortedMap) {
            LongIntSortedMap longIntSortedMap = (LongIntSortedMap)this.m_index;
            while (intIterator.hasNext()) {
                int n3 = intIterator.nextInt();
                longIntSortedMap.put(this.m_col.getLong(this.m_table.getColumnRow(n3, n)), n3);
            }
        } else if (this.m_index instanceof FloatIntSortedMap) {
            FloatIntSortedMap floatIntSortedMap = (FloatIntSortedMap)this.m_index;
            while (intIterator.hasNext()) {
                int n4 = intIterator.nextInt();
                floatIntSortedMap.put(this.m_col.getFloat(this.m_table.getColumnRow(n4, n)), n4);
            }
        } else if (this.m_index instanceof DoubleIntSortedMap) {
            DoubleIntSortedMap doubleIntSortedMap = (DoubleIntSortedMap)this.m_index;
            while (intIterator.hasNext()) {
                int n5 = intIterator.nextInt();
                doubleIntSortedMap.put(this.m_col.getDouble(this.m_table.getColumnRow(n5, n)), n5);
            }
        } else if (this.m_index instanceof BooleanIntSortedMap) {
            BooleanIntSortedMap booleanIntSortedMap = (BooleanIntSortedMap)this.m_index;
            while (intIterator.hasNext()) {
                int n6 = intIterator.nextInt();
                booleanIntSortedMap.put(this.m_col.getBoolean(this.m_table.getColumnRow(n6, n)), n6);
            }
        } else if (this.m_index instanceof ObjectIntSortedMap) {
            ObjectIntSortedMap objectIntSortedMap = (ObjectIntSortedMap)this.m_index;
            while (intIterator.hasNext()) {
                int n7 = intIterator.nextInt();
                objectIntSortedMap.put(this.m_col.get(this.m_table.getColumnRow(n7, n)), n7);
            }
        } else {
            throw new IllegalStateException();
        }
        this.m_reindex = false;
    }

    public void tableChanged(Table table, int n, int n2, int n3, int n4) {
        if (n4 == 0 || table != this.m_table || n3 != -1) {
            return;
        }
        boolean bl = n4 == 1;
        for (int i = n; i <= n2; ++i) {
            this.rowChanged(i, bl);
        }
    }

    private void rowChanged(int n, boolean bl) {
        int n2 = this.m_rows.getColumnRow(n, this.getColumnIndex());
        if (this.m_index instanceof IntIntSortedMap) {
            IntIntSortedMap intIntSortedMap = (IntIntSortedMap)this.m_index;
            int n3 = this.m_col.getInt(n);
            if (bl) {
                intIntSortedMap.put(n3, n);
            } else {
                intIntSortedMap.remove(n3, n);
            }
        } else if (this.m_index instanceof LongIntSortedMap) {
            LongIntSortedMap longIntSortedMap = (LongIntSortedMap)this.m_index;
            long l = this.m_col.getLong(n2);
            if (bl) {
                longIntSortedMap.put(l, n);
            } else {
                longIntSortedMap.remove(l, n);
            }
        } else if (this.m_index instanceof FloatIntSortedMap) {
            FloatIntSortedMap floatIntSortedMap = (FloatIntSortedMap)this.m_index;
            float f = this.m_col.getFloat(n2);
            if (bl) {
                floatIntSortedMap.put(f, n);
            } else {
                floatIntSortedMap.remove(f, n);
            }
        } else if (this.m_index instanceof DoubleIntSortedMap) {
            DoubleIntSortedMap doubleIntSortedMap = (DoubleIntSortedMap)this.m_index;
            double d = this.m_col.getDouble(n2);
            if (bl) {
                doubleIntSortedMap.put(d, n);
            } else {
                doubleIntSortedMap.remove(d, n);
            }
        } else if (this.m_index instanceof BooleanIntSortedMap) {
            BooleanIntSortedMap booleanIntSortedMap = (BooleanIntSortedMap)this.m_index;
            boolean bl2 = this.m_col.getBoolean(n2);
            if (bl) {
                booleanIntSortedMap.put(bl2, n);
            } else {
                booleanIntSortedMap.remove(bl2, n);
            }
        } else if (this.m_index instanceof ObjectIntSortedMap) {
            ObjectIntSortedMap objectIntSortedMap = (ObjectIntSortedMap)this.m_index;
            Object object = this.m_col.get(n2);
            if (bl) {
                objectIntSortedMap.put(object, n);
            } else {
                objectIntSortedMap.remove(object, n);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public void columnChanged(Column column, int n, int n2, int n3) {
        this.m_reindex = true;
    }

    public void columnChanged(Column column, int n, boolean bl) {
        int n2 = this.m_rows.getTableRow(n, this.getColumnIndex());
        if (n2 < 0) {
            return;
        }
        ((BooleanIntSortedMap)this.m_index).remove(bl, n2);
        ((BooleanIntSortedMap)this.m_index).put(column.getBoolean(n), n2);
    }

    public void columnChanged(Column column, int n, int n2) {
        int n3 = this.m_rows.getTableRow(n, this.getColumnIndex());
        if (n3 < 0) {
            return;
        }
        ((IntIntSortedMap)this.m_index).remove(n2, n3);
        ((IntIntSortedMap)this.m_index).put(column.getInt(n), n3);
    }

    public void columnChanged(Column column, int n, long l) {
        int n2 = this.m_rows.getTableRow(n, this.getColumnIndex());
        if (n2 < 0) {
            return;
        }
        ((LongIntSortedMap)this.m_index).remove(l, n2);
        ((LongIntSortedMap)this.m_index).put(column.getLong(n), n2);
    }

    public void columnChanged(Column column, int n, float f) {
        int n2 = this.m_rows.getTableRow(n, this.getColumnIndex());
        if (n2 < 0) {
            return;
        }
        ((FloatIntSortedMap)this.m_index).remove(f, n2);
        ((FloatIntSortedMap)this.m_index).put(column.getFloat(n), n2);
    }

    public void columnChanged(Column column, int n, double d) {
        int n2 = this.m_rows.getTableRow(n, this.getColumnIndex());
        if (n2 < 0) {
            return;
        }
        ((DoubleIntSortedMap)this.m_index).remove(d, n2);
        ((DoubleIntSortedMap)this.m_index).put(column.getDouble(n), n2);
    }

    public void columnChanged(Column column, int n, Object object) {
        int n2 = this.m_rows.getTableRow(n, this.getColumnIndex());
        if (n2 < 0) {
            return;
        }
        ((ObjectIntSortedMap)this.m_index).remove(object, n2);
        ((ObjectIntSortedMap)this.m_index).put(column.get(n), n2);
    }

    public int minimum() {
        return this.m_index.getMinimum();
    }

    public int maximum() {
        return this.m_index.getMaximum();
    }

    public int median() {
        return this.m_index.getMedian();
    }

    public int uniqueCount() {
        return this.m_index.getUniqueCount();
    }

    public IntIterator allRows(int n) {
        boolean bl = (n & 0x20) > 0;
        return this.m_index.valueIterator(bl);
    }

    public IntIterator rows(Object object, Object object2, int n) {
        boolean bl;
        if (!(this.m_index instanceof ObjectIntSortedMap)) {
            throw new IllegalStateException();
        }
        boolean bl2 = (n & 0x10) > 0;
        boolean bl3 = (n & 8) > 0;
        boolean bl4 = bl = (n & 2) > 0;
        if (object == null) {
            object = ObjectIntSortedMap.MIN_KEY;
        }
        if (object2 == null) {
            object2 = ObjectIntSortedMap.MAX_KEY;
        }
        ObjectIntSortedMap objectIntSortedMap = (ObjectIntSortedMap)this.m_index;
        if (bl2) {
            return objectIntSortedMap.valueRangeIterator(object2, bl, object, bl3);
        }
        return objectIntSortedMap.valueRangeIterator(object, bl3, object2, bl);
    }

    public IntIterator rows(int n, int n2, int n3) {
        if (!(this.m_index instanceof IntIntSortedMap)) {
            throw new IllegalStateException();
        }
        boolean bl = (n3 & 0x10) > 0;
        boolean bl2 = (n3 & 8) > 0;
        boolean bl3 = (n3 & 2) > 0;
        IntIntSortedMap intIntSortedMap = (IntIntSortedMap)this.m_index;
        if (bl) {
            return intIntSortedMap.valueRangeIterator(n2, bl3, n, bl2);
        }
        return intIntSortedMap.valueRangeIterator(n, bl2, n2, bl3);
    }

    public IntIterator rows(long l, long l2, int n) {
        if (!(this.m_index instanceof LongIntSortedMap)) {
            throw new IllegalStateException();
        }
        boolean bl = (n & 0x10) > 0;
        boolean bl2 = (n & 8) > 0;
        boolean bl3 = (n & 2) > 0;
        LongIntSortedMap longIntSortedMap = (LongIntSortedMap)this.m_index;
        if (bl) {
            return longIntSortedMap.valueRangeIterator(l2, bl3, l, bl2);
        }
        return longIntSortedMap.valueRangeIterator(l, bl2, l2, bl3);
    }

    public IntIterator rows(float f, float f2, int n) {
        if (!(this.m_index instanceof FloatIntSortedMap)) {
            throw new IllegalStateException();
        }
        boolean bl = (n & 0x10) > 0;
        boolean bl2 = (n & 8) > 0;
        boolean bl3 = (n & 2) > 0;
        FloatIntSortedMap floatIntSortedMap = (FloatIntSortedMap)this.m_index;
        if (bl) {
            return floatIntSortedMap.valueRangeIterator(f2, bl3, f, bl2);
        }
        return floatIntSortedMap.valueRangeIterator(f, bl2, f2, bl3);
    }

    public IntIterator rows(double d, double d2, int n) {
        if (!(this.m_index instanceof DoubleIntSortedMap)) {
            throw new IllegalStateException();
        }
        boolean bl = (n & 0x10) > 0;
        boolean bl2 = (n & 8) > 0;
        boolean bl3 = (n & 2) > 0;
        DoubleIntSortedMap doubleIntSortedMap = (DoubleIntSortedMap)this.m_index;
        if (bl) {
            return doubleIntSortedMap.valueRangeIterator(d2, bl3, d, bl2);
        }
        return doubleIntSortedMap.valueRangeIterator(d, bl2, d2, bl3);
    }

    public IntIterator rows(int n) {
        return this.rows(n, n, 42);
    }

    public IntIterator rows(long l) {
        return this.rows(l, l, 42);
    }

    public IntIterator rows(float f) {
        return this.rows(f, f, 42);
    }

    public IntIterator rows(double d) {
        return this.rows(d, d, 42);
    }

    public IntIterator rows(boolean bl) {
        if (!(this.m_index instanceof BooleanIntSortedMap)) {
            throw new IllegalStateException();
        }
        BooleanIntSortedMap booleanIntSortedMap = (BooleanIntSortedMap)this.m_index;
        return booleanIntSortedMap.valueRangeIterator(bl, true, bl, true);
    }

    public IntIterator rows(Object object) {
        return this.rows(object, object, 42);
    }

    public int get(double d) {
        DoubleIntSortedMap doubleIntSortedMap = (DoubleIntSortedMap)this.m_index;
        return doubleIntSortedMap.get(d);
    }

    public int get(float f) {
        FloatIntSortedMap floatIntSortedMap = (FloatIntSortedMap)this.m_index;
        return floatIntSortedMap.get(f);
    }

    public int get(int n) {
        IntIntSortedMap intIntSortedMap = (IntIntSortedMap)this.m_index;
        return intIntSortedMap.get(n);
    }

    public int get(long l) {
        LongIntSortedMap longIntSortedMap = (LongIntSortedMap)this.m_index;
        return longIntSortedMap.get(l);
    }

    public int get(Object object) {
        ObjectIntSortedMap objectIntSortedMap = (ObjectIntSortedMap)this.m_index;
        return objectIntSortedMap.get(object);
    }
}

