/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.io.AbstractGraphReader;
import prefuse.data.io.DataIOException;
import prefuse.data.io.GraphReader;
import prefuse.data.parser.DataParseException;
import prefuse.data.parser.DataParser;
import prefuse.data.parser.ParserFactory;
import prefuse.util.collections.IntIterator;

public class GraphMLReader
extends AbstractGraphReader
implements GraphReader {
    public Graph readGraph(InputStream inputStream) throws DataIOException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            GraphMLHandler graphMLHandler = new GraphMLHandler();
            sAXParser.parse(inputStream, (DefaultHandler)graphMLHandler);
            return graphMLHandler.getGraph();
        }
        catch (Exception exception) {
            if (exception instanceof DataIOException) {
                throw (DataIOException)exception;
            }
            throw new DataIOException(exception);
        }
    }

    public static class GraphMLHandler
    extends DefaultHandler
    implements Tokens {
        protected ParserFactory m_pf = ParserFactory.getDefaultFactory();
        protected static final String SRC = Graph.DEFAULT_SOURCE_KEY;
        protected static final String TRG = Graph.DEFAULT_TARGET_KEY;
        protected static final String SRCID = SRC + '_' + "id";
        protected static final String TRGID = TRG + '_' + "id";
        protected Schema m_nsch = new Schema();
        protected Schema m_esch = new Schema();
        protected String m_graphid;
        protected Graph m_graph = null;
        protected Table m_nodes;
        protected Table m_edges;
        protected String m_id;
        protected String m_for;
        protected String m_name;
        protected String m_type;
        protected String m_dflt;
        protected StringBuffer m_sbuf = new StringBuffer();
        private String m_key;
        private int m_row = -1;
        private Table m_table = null;
        protected HashMap m_nodeMap = new HashMap();
        protected HashMap m_idMap = new HashMap();
        private boolean m_directed = false;
        private boolean inSchema;

        public void startDocument() {
            this.m_nodeMap.clear();
            this.inSchema = true;
            this.m_esch.addColumn(SRC, Integer.TYPE);
            this.m_esch.addColumn(TRG, Integer.TYPE);
            this.m_esch.addColumn(SRCID, String.class);
            this.m_esch.addColumn(TRGID, String.class);
        }

        public void endDocument() throws SAXException {
            IntIterator intIterator = this.m_edges.rows();
            while (intIterator.hasNext()) {
                int n = intIterator.nextInt();
                String string = this.m_edges.getString(n, SRCID);
                if (!this.m_nodeMap.containsKey(string)) {
                    throw new SAXException("Tried to create edge with source node id=" + string + " which does not exist.");
                }
                int n2 = (Integer)this.m_nodeMap.get(string);
                this.m_edges.setInt(n, SRC, n2);
                String string2 = this.m_edges.getString(n, TRGID);
                if (!this.m_nodeMap.containsKey(string2)) {
                    throw new SAXException("Tried to create edge with target node id=" + string2 + " which does not exist.");
                }
                int n3 = (Integer)this.m_nodeMap.get(string2);
                this.m_edges.setInt(n, TRG, n3);
            }
            this.m_edges.removeColumn(SRCID);
            this.m_edges.removeColumn(TRGID);
            this.m_graph = new Graph(this.m_nodes, this.m_edges, this.m_directed);
            if (this.m_graphid != null) {
                this.m_graph.putClientProperty("id", this.m_graphid);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.m_sbuf.delete(0, this.m_sbuf.length());
            if (string3.equals("graph")) {
                String string4 = attributes.getValue("edgedefault");
                this.m_directed = "directed".equalsIgnoreCase(string4);
                this.m_graphid = attributes.getValue("id");
            } else if (string3.equals("key")) {
                if (!this.inSchema) {
                    this.error("\"key\" elements can not occur after the first node or edge declaration.");
                }
                this.m_for = attributes.getValue("for");
                this.m_id = attributes.getValue("id");
                this.m_name = attributes.getValue("attr.name");
                this.m_type = attributes.getValue("attr.type");
            } else if (string3.equals("node")) {
                this.schemaCheck();
                this.m_row = this.m_nodes.addRow();
                String string5 = attributes.getValue("id");
                this.m_nodeMap.put(string5, new Integer(this.m_row));
                this.m_table = this.m_nodes;
            } else if (string3.equals("edge")) {
                this.schemaCheck();
                this.m_row = this.m_edges.addRow();
                this.m_edges.setString(this.m_row, SRCID, attributes.getValue(SRC));
                this.m_edges.setString(this.m_row, TRGID, attributes.getValue(TRG));
                this.m_table = this.m_edges;
            } else if (string3.equals("data")) {
                this.m_key = attributes.getValue("key");
            }
        }

        public void endElement(String string, String string2, String string3) {
            if (string3.equals("default")) {
                this.m_dflt = this.m_sbuf.toString();
            } else if (string3.equals("key")) {
                this.addToSchema();
            } else if (string3.equals("data")) {
                String string4 = this.m_sbuf.toString();
                String string5 = (String)this.m_idMap.get(this.m_key);
                Class clazz = this.m_table.getColumnType(string5);
                try {
                    Object object = this.parse(string4, clazz);
                    this.m_table.set(this.m_row, string5, object);
                }
                catch (DataParseException dataParseException) {
                    this.error(dataParseException);
                }
            } else if (string3.equals("node") || string3.equals("edge")) {
                this.m_row = -1;
                this.m_table = null;
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.m_sbuf.append(cArray, n, n2);
        }

        protected void schemaCheck() {
            if (this.inSchema) {
                this.m_nsch.lockSchema();
                this.m_esch.lockSchema();
                this.m_nodes = this.m_nsch.instantiate();
                this.m_edges = this.m_esch.instantiate();
                this.inSchema = false;
            }
        }

        protected void addToSchema() {
            if (this.m_name == null || this.m_name.length() == 0) {
                this.error("Empty key name.");
            }
            if (this.m_type == null || this.m_type.length() == 0) {
                this.error("Empty key type.");
            }
            try {
                Object object;
                Class clazz = this.parseType(this.m_type);
                Object object2 = object = this.m_dflt == null ? null : this.parse(this.m_dflt, clazz);
                if (this.m_for == null || this.m_for.equals("all")) {
                    this.m_nsch.addColumn(this.m_name, clazz, object);
                    this.m_esch.addColumn(this.m_name, clazz, object);
                } else if (this.m_for.equals("node")) {
                    this.m_nsch.addColumn(this.m_name, clazz, object);
                } else if (this.m_for.equals("edge")) {
                    this.m_esch.addColumn(this.m_name, clazz, object);
                } else {
                    this.error("Unrecognized \"for\" value: " + this.m_for);
                }
                this.m_idMap.put(this.m_id, this.m_name);
                this.m_dflt = null;
            }
            catch (DataParseException dataParseException) {
                this.error(dataParseException);
            }
        }

        protected Class parseType(String string) {
            if ((string = string.toLowerCase()).equals("int") || string.equals("integer")) {
                return Integer.TYPE;
            }
            if (string.equals("long")) {
                return Long.TYPE;
            }
            if (string.equals("float")) {
                return Float.TYPE;
            }
            if (string.equals("double") || string.equals("real")) {
                return Double.TYPE;
            }
            if (string.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (string.equals("string")) {
                return String.class;
            }
            if (string.equals("date")) {
                return Date.class;
            }
            this.error("Unrecognized data type: " + string);
            return null;
        }

        protected Object parse(String string, Class clazz) throws DataParseException {
            DataParser dataParser = this.m_pf.getParser(clazz);
            return dataParser.parse(string);
        }

        public Graph getGraph() {
            return this.m_graph;
        }

        protected void error(String string) {
            throw new RuntimeException(string);
        }

        protected void error(Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static interface Tokens {
        public static final String ID = "id";
        public static final String GRAPH = "graph";
        public static final String EDGEDEF = "edgedefault";
        public static final String DIRECTED = "directed";
        public static final String UNDIRECTED = "undirected";
        public static final String KEY = "key";
        public static final String FOR = "for";
        public static final String ALL = "all";
        public static final String ATTRNAME = "attr.name";
        public static final String ATTRTYPE = "attr.type";
        public static final String DEFAULT = "default";
        public static final String NODE = "node";
        public static final String EDGE = "edge";
        public static final String SOURCE = "source";
        public static final String TARGET = "target";
        public static final String DATA = "data";
        public static final String TYPE = "type";
        public static final String INT = "int";
        public static final String INTEGER = "integer";
        public static final String LONG = "long";
        public static final String FLOAT = "float";
        public static final String DOUBLE = "double";
        public static final String REAL = "real";
        public static final String BOOLEAN = "boolean";
        public static final String STRING = "string";
        public static final String DATE = "date";
    }
}

