/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data;

import java.util.Iterator;
import prefuse.data.Edge;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.SpanningTree;
import prefuse.data.Table;
import prefuse.data.Tree;
import prefuse.data.Tuple;
import prefuse.data.column.Column;
import prefuse.data.event.ColumnListener;
import prefuse.data.event.GraphListener;
import prefuse.data.event.TableListener;
import prefuse.data.expression.Predicate;
import prefuse.data.tuple.CompositeTupleSet;
import prefuse.data.tuple.TableEdge;
import prefuse.data.tuple.TableNode;
import prefuse.data.tuple.TupleManager;
import prefuse.data.tuple.TupleSet;
import prefuse.data.util.Index;
import prefuse.data.util.NeighborIterator;
import prefuse.util.PrefuseConfig;
import prefuse.util.TypeLib;
import prefuse.util.collections.CompositeIntIterator;
import prefuse.util.collections.CompositeIterator;
import prefuse.util.collections.CopyOnWriteArrayList;
import prefuse.util.collections.IntArrayIterator;
import prefuse.util.collections.IntIterator;

public class Graph
extends CompositeTupleSet {
    public static final int INEDGES = 0;
    public static final int OUTEDGES = 1;
    public static final int UNDIRECTED = 2;
    public static final String DEFAULT_NODE_KEY = PrefuseConfig.get("data.graph.nodeKey");
    public static final String DEFAULT_SOURCE_KEY = PrefuseConfig.get("data.graph.sourceKey");
    public static final String DEFAULT_TARGET_KEY = PrefuseConfig.get("data.graph.targetKey");
    public static final String NODES = PrefuseConfig.get("data.graph.nodeGroup");
    public static final String EDGES = PrefuseConfig.get("data.graph.edgeGroup");
    protected Table m_links;
    protected TupleManager m_nodeTuples;
    protected TupleManager m_edgeTuples;
    protected boolean m_directed = false;
    protected SpanningTree m_spanning = null;
    protected String m_nkey;
    protected String m_skey;
    protected String m_tkey;
    protected Index m_nidx;
    protected boolean m_longKey = false;
    private Listener m_listener;
    private CopyOnWriteArrayList m_listeners = new CopyOnWriteArrayList();
    protected static final String INDEGREE = "_indegree";
    protected static final String OUTDEGREE = "_outdegree";
    protected static final String INLINKS = "_inlinks";
    protected static final String OUTLINKS = "_outlinks";
    protected static final Schema LINKS_SCHEMA = new Schema();

    public Graph() {
        this(false);
    }

    public Graph(boolean bl) {
        this(new Table(), bl);
    }

    public Graph(Table table, boolean bl) {
        this(table, bl, DEFAULT_NODE_KEY, DEFAULT_SOURCE_KEY, DEFAULT_TARGET_KEY);
    }

    public Graph(Table table, boolean bl, String string, String string2, String string3) {
        Table table2 = new Table();
        table2.addColumn(string2, Integer.TYPE, new Integer(-1));
        table2.addColumn(string3, Integer.TYPE, new Integer(-1));
        this.init(table, table2, bl, string, string2, string3);
    }

    public Graph(Table table, Table table2, boolean bl) {
        this(table, table2, bl, DEFAULT_NODE_KEY, DEFAULT_SOURCE_KEY, DEFAULT_TARGET_KEY);
    }

    public Graph(Table table, Table table2, boolean bl, String string, String string2) {
        this.init(table, table2, bl, DEFAULT_NODE_KEY, string, string2);
    }

    public Graph(Table table, Table table2, boolean bl, String string, String string2, String string3) {
        this.init(table, table2, bl, string, string2, string3);
    }

    protected void init(Table table, Table table2, boolean bl, String string, String string2, String string3) {
        if (string != null && !TypeLib.isIntegerType(table.getColumnType(string)) || !TypeLib.isIntegerType(table2.getColumnType(string2)) || !TypeLib.isIntegerType(table2.getColumnType(string3))) {
            throw new IllegalArgumentException("Incompatible column types for graph keys");
        }
        this.removeAllSets();
        super.addSet(EDGES, table2);
        super.addSet(NODES, table);
        this.m_directed = bl;
        this.m_nkey = string;
        this.m_skey = string2;
        this.m_tkey = string3;
        if (string != null) {
            if (table.getColumnType(string) == Long.TYPE) {
                this.m_longKey = true;
            }
            table.index(string);
            this.m_nidx = table.getIndex(string);
        }
        if (this.m_nodeTuples == null) {
            this.m_nodeTuples = new TupleManager(table, this, TableNode.class);
        }
        this.m_edgeTuples = new TupleManager(table2, this, TableEdge.class);
        this.initLinkTable();
        if (this.m_listener == null) {
            this.m_listener = new Listener();
        }
        table.addTableListener(this.m_listener);
        table2.addTableListener(this.m_listener);
        this.m_listener.setEdgeTable(table2);
    }

    public void setTupleManagers(TupleManager tupleManager, TupleManager tupleManager2) {
        if (!Node.class.isAssignableFrom(tupleManager.getTupleType())) {
            throw new IllegalArgumentException("The provided node TupleManager must generate tuples that implement the Node interface.");
        }
        if (!Edge.class.isAssignableFrom(tupleManager2.getTupleType())) {
            throw new IllegalArgumentException("The provided edge TupleManager must generate tuples that implement the Edge interface.");
        }
        this.m_nodeTuples = tupleManager;
        this.m_edgeTuples = tupleManager2;
    }

    public void dispose() {
        this.getNodeTable().removeTableListener(this.m_listener);
        this.getEdgeTable().removeTableListener(this.m_listener);
    }

    public void setEdgeTable(Table table) {
        Table table2 = this.getEdgeTable();
        table2.removeTableListener(this.m_listener);
        this.m_edgeTuples.invalidateAll();
        this.m_links.clear();
        this.init(this.getNodeTable(), table, this.m_directed, this.m_nkey, this.m_skey, this.m_tkey);
    }

    protected void initLinkTable() {
        this.m_links = this.createLinkTable();
        IntIterator intIterator = this.getEdgeTable().rows();
        while (intIterator.hasNext()) {
            this.updateDegrees(intIterator.nextInt(), 1);
        }
    }

    protected Table createLinkTable() {
        return LINKS_SCHEMA.instantiate(this.getNodeTable().getMaximumRow() + 1);
    }

    protected void updateDegrees(int n, int n2) {
        if (!this.getEdgeTable().isValidRow(n)) {
            return;
        }
        int n3 = this.getSourceNode(n);
        int n4 = this.getTargetNode(n);
        if (n3 < 0 || n4 < 0) {
            return;
        }
        this.updateDegrees(n, n3, n4, n2);
        if (n2 < 0) {
            this.m_edgeTuples.invalidate(n);
        }
    }

    protected void updateDegrees(int n, int n2, int n3, int n4) {
        int n5 = this.m_links.getInt(n2, OUTDEGREE);
        int n6 = this.m_links.getInt(n3, INDEGREE);
        if (n4 > 0) {
            this.addLink(OUTLINKS, n5, n2, n);
            this.addLink(INLINKS, n6, n3, n);
        } else if (n4 < 0) {
            this.remLink(OUTLINKS, n5, n2, n);
            this.remLink(INLINKS, n6, n3, n);
        }
        this.m_links.setInt(n2, OUTDEGREE, n5 + n4);
        this.m_links.setInt(n3, INDEGREE, n6 + n4);
        this.m_spanning = null;
    }

    protected void addLink(String string, int n, int n2, int n3) {
        int[] nArray = (int[])this.m_links.get(n2, string);
        if (nArray == null) {
            nArray = new int[]{n3};
            this.m_links.set(n2, string, (Object)nArray);
            return;
        }
        if (n == nArray.length) {
            int[] nArray2 = new int[Math.max(3 * nArray.length / 2, n + 1)];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
            this.m_links.set(n2, string, (Object)nArray);
        }
        nArray[n] = n3;
    }

    protected boolean remLink(String string, int n, int n2, int n3) {
        int[] nArray = (int[])this.m_links.get(n2, string);
        for (int i = 0; i < n; ++i) {
            if (nArray[i] != n3) continue;
            System.arraycopy(nArray, i + 1, nArray, i, n - i - 1);
            return true;
        }
        return false;
    }

    protected void updateNodeData(int n, boolean bl) {
        if (bl) {
            this.m_links.addRow();
        } else {
            this.m_nodeTuples.invalidate(n);
            this.m_links.removeRow(n);
        }
    }

    public String getNodeKeyField() {
        return this.m_nkey;
    }

    public String getEdgeSourceField() {
        return this.m_skey;
    }

    public String getEdgeTargetField() {
        return this.m_tkey;
    }

    public long getKey(int n) {
        return this.m_nkey == null ? (long)n : this.getNodeTable().getLong(n, this.m_nkey);
    }

    public int getNodeIndex(long l) {
        if (this.m_nidx == null) {
            return (int)l;
        }
        int n = this.m_longKey ? this.m_nidx.get(l) : this.m_nidx.get((int)l);
        return n < 0 ? -1 : n;
    }

    public int addNodeRow() {
        return this.getNodeTable().addRow();
    }

    public Node addNode() {
        int n = this.addNodeRow();
        return (Node)this.m_nodeTuples.getTuple(n);
    }

    public int addEdge(int n, int n2) {
        long l = this.getKey(n);
        long l2 = this.getKey(n2);
        Table table = this.getEdgeTable();
        int n3 = table.addRow();
        if (this.m_longKey) {
            table.setLong(n3, this.m_skey, l);
            table.setLong(n3, this.m_tkey, l2);
        } else {
            table.setInt(n3, this.m_skey, (int)l);
            table.setInt(n3, this.m_tkey, (int)l2);
        }
        return n3;
    }

    public Edge addEdge(Node node, Node node2) {
        this.nodeCheck(node, true);
        this.nodeCheck(node2, true);
        int n = this.addEdge(node.getRow(), node2.getRow());
        return this.getEdge(n);
    }

    public boolean removeNode(int n) {
        Table table = this.getNodeTable();
        if (table.isValidRow(n)) {
            int n2;
            int n3 = this.getInDegree(n);
            if (n3 > 0) {
                int[] nArray = (int[])this.m_links.get(n, INLINKS);
                int n4 = n3;
                while (--n4 >= 0) {
                    this.removeEdge(nArray[n4]);
                }
            }
            if ((n2 = this.getOutDegree(n)) > 0) {
                int[] nArray = (int[])this.m_links.get(n, OUTLINKS);
                int n5 = n2;
                while (--n5 >= 0) {
                    this.removeEdge(nArray[n5]);
                }
            }
        }
        return table.removeRow(n);
    }

    public boolean removeNode(Node node) {
        this.nodeCheck(node, true);
        return this.removeNode(node.getRow());
    }

    public boolean removeEdge(int n) {
        return this.getEdgeTable().removeRow(n);
    }

    public boolean removeEdge(Edge edge) {
        this.edgeCheck(edge, true);
        return this.removeEdge(edge.getRow());
    }

    protected void clearEdges() {
        this.getEdgeTable().clear();
    }

    protected boolean nodeCheck(Node node, boolean bl) {
        if (!node.isValid()) {
            if (bl) {
                throw new IllegalArgumentException("Node must be valid.");
            }
            return false;
        }
        Graph graph = node.getGraph();
        if (graph != this && graph.m_spanning != this) {
            if (bl) {
                throw new IllegalArgumentException("Node must be part of this Graph.");
            }
            return false;
        }
        return true;
    }

    public TupleSet getNodes() {
        return this.getSet(NODES);
    }

    public Table getNodeTable() {
        return (Table)this.getSet(NODES);
    }

    public int getNodeCount() {
        return this.getNodeTable().getRowCount();
    }

    public Node getNode(int n) {
        return (Node)this.m_nodeTuples.getTuple(n);
    }

    public Node getNodeFromKey(long l) {
        int n = this.getNodeIndex(l);
        return n < 0 ? null : this.getNode(n);
    }

    public int getInDegree(int n) {
        return this.m_links.getInt(n, INDEGREE);
    }

    public int getInDegree(Node node) {
        this.nodeCheck(node, true);
        return this.getInDegree(node.getRow());
    }

    public int getOutDegree(int n) {
        return this.m_links.getInt(n, OUTDEGREE);
    }

    public int getOutDegree(Node node) {
        this.nodeCheck(node, true);
        return this.getOutDegree(node.getRow());
    }

    public int getDegree(int n) {
        return this.getInDegree(n) + this.getOutDegree(n);
    }

    public int getDegree(Node node) {
        this.nodeCheck(node, true);
        return this.getDegree(node.getRow());
    }

    public boolean isDirected() {
        return this.m_directed;
    }

    protected boolean edgeCheck(Edge edge, boolean bl) {
        if (!edge.isValid()) {
            if (bl) {
                throw new IllegalArgumentException("Edge must be valid.");
            }
            return false;
        }
        if (edge.getGraph() != this) {
            if (bl) {
                throw new IllegalArgumentException("Edge must be part of this Graph.");
            }
            return false;
        }
        return true;
    }

    public TupleSet getEdges() {
        return this.getSet(EDGES);
    }

    public Table getEdgeTable() {
        return (Table)this.getSet(EDGES);
    }

    public int getEdgeCount() {
        return this.getEdgeTable().getRowCount();
    }

    public Edge getEdge(int n) {
        return n < 0 ? null : (Edge)this.m_edgeTuples.getTuple(n);
    }

    public int getEdge(int n, int n2) {
        int n3 = this.getOutDegree(n);
        if (n3 > 0) {
            int[] nArray = (int[])this.m_links.get(n, OUTLINKS);
            for (int i = 0; i < n3; ++i) {
                if (this.getTargetNode(nArray[i]) != n2) continue;
                return nArray[i];
            }
        }
        return -1;
    }

    public Edge getEdge(Node node, Node node2) {
        this.nodeCheck(node, true);
        this.nodeCheck(node2, true);
        return this.getEdge(this.getEdge(node.getRow(), node2.getRow()));
    }

    public int getSourceNode(int n) {
        return this.getNodeIndex(this.getEdgeTable().getLong(n, this.m_skey));
    }

    public Node getSourceNode(Edge edge) {
        this.edgeCheck(edge, true);
        return this.getNode(this.getSourceNode(edge.getRow()));
    }

    public int getTargetNode(int n) {
        return this.getNodeIndex(this.getEdgeTable().getLong(n, this.m_tkey));
    }

    public Node getTargetNode(Edge edge) {
        this.edgeCheck(edge, true);
        return this.getNode(this.getTargetNode(edge.getRow()));
    }

    public int getAdjacentNode(int n, int n2) {
        int n3 = this.getSourceNode(n);
        int n4 = this.getTargetNode(n);
        if (n3 == n2) {
            return n4;
        }
        if (n4 == n2) {
            return n3;
        }
        throw new IllegalArgumentException("Edge is not incident on the input node.");
    }

    public Node getAdjacentNode(Edge edge, Node node) {
        this.edgeCheck(edge, true);
        this.nodeCheck(node, true);
        return this.getNode(this.getAdjacentNode(edge.getRow(), node.getRow()));
    }

    public IntIterator nodeRows() {
        return this.getNodeTable().rows();
    }

    public IntIterator edgeRows() {
        return this.getEdgeTable().rows();
    }

    public IntIterator edgeRows(int n) {
        return this.edgeRows(n, 2);
    }

    public IntIterator edgeRows(int n, int n2) {
        if (n2 == 1) {
            int[] nArray = (int[])this.m_links.get(n, OUTLINKS);
            return new IntArrayIterator(nArray, 0, this.getOutDegree(n));
        }
        if (n2 == 0) {
            int[] nArray = (int[])this.m_links.get(n, INLINKS);
            return new IntArrayIterator(nArray, 0, this.getInDegree(n));
        }
        if (n2 == 2) {
            return new CompositeIntIterator(this.edgeRows(n, 1), this.edgeRows(n, 0));
        }
        throw new IllegalArgumentException("Unrecognized edge type: " + n2 + ". Type should be one of Graph.OUTEDGES, " + "Graoh.INEDGES, or Graph.ALL");
    }

    public IntIterator inEdgeRows(int n) {
        return this.edgeRows(n, 0);
    }

    public IntIterator outEdgeRows(int n) {
        return this.edgeRows(n, 1);
    }

    public Iterator nodes() {
        return this.m_nodeTuples.iterator(this.nodeRows());
    }

    public Iterator neighbors(Node node) {
        return new NeighborIterator(node, this.edges(node));
    }

    public Iterator inNeighbors(Node node) {
        return new NeighborIterator(node, this.inEdges(node));
    }

    public Iterator outNeighbors(Node node) {
        return new NeighborIterator(node, this.outEdges(node));
    }

    public Iterator edges() {
        return this.m_edgeTuples.iterator(this.edgeRows());
    }

    public Iterator edges(Node node) {
        this.nodeCheck(node, true);
        return this.m_edgeTuples.iterator(this.edgeRows(node.getRow(), 2));
    }

    public Iterator inEdges(Node node) {
        this.nodeCheck(node, true);
        return this.m_edgeTuples.iterator(this.inEdgeRows(node.getRow()));
    }

    public Iterator outEdges(Node node) {
        this.nodeCheck(node, true);
        return this.m_edgeTuples.iterator(this.outEdgeRows(node.getRow()));
    }

    public void clear() {
        this.m_nodeTuples.invalidateAll();
        this.m_edgeTuples.invalidateAll();
        super.clear();
        this.m_links.clear();
    }

    public boolean removeTuple(Tuple tuple) {
        if (tuple instanceof Node) {
            return this.removeNode((Node)tuple);
        }
        if (tuple instanceof Edge) {
            return this.removeEdge((Edge)tuple);
        }
        throw new IllegalArgumentException("Input tuple must be part of this graph");
    }

    public Iterator tuples(Predicate predicate) {
        if (predicate == null) {
            return this.tuples();
        }
        return new CompositeIterator(this.m_edgeTuples.iterator(this.getEdgeTable().rows(predicate)), this.m_nodeTuples.iterator(this.getNodeTable().rows(predicate)));
    }

    public Iterator tuples() {
        return new CompositeIterator(this.edges(), this.nodes());
    }

    public Tree getSpanningTree() {
        if (this.m_spanning == null) {
            return this.getSpanningTree((Node)this.nodes().next());
        }
        return this.m_spanning;
    }

    public Tree getSpanningTree(Node node) {
        this.nodeCheck(node, true);
        if (this.m_spanning == null) {
            this.m_spanning = new SpanningTree(this, node);
        } else if (this.m_spanning.getRoot() != node) {
            this.m_spanning.buildSpanningTree(node);
        }
        return this.m_spanning;
    }

    public void clearSpanningTree() {
        this.m_spanning = null;
    }

    public void addGraphModelListener(GraphListener graphListener) {
        if (!this.m_listeners.contains(graphListener)) {
            this.m_listeners.add(graphListener);
        }
    }

    public void removeGraphModelListener(GraphListener graphListener) {
        this.m_listeners.remove(graphListener);
    }

    protected void fireGraphEvent(Table table, int n, int n2, int n3, int n4) {
        String string;
        String string2 = string = table == this.getNodeTable() ? NODES : EDGES;
        if (n4 != 0) {
            this.fireTupleEvent(table, n, n2, n4);
        }
        if (!this.m_listeners.isEmpty()) {
            Object[] objectArray = this.m_listeners.getArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((GraphListener)objectArray[i]).graphChanged(this, string, n, n2, n3, n4);
            }
        }
    }

    static {
        Integer n = new Integer(0);
        LINKS_SCHEMA.addColumn(INDEGREE, Integer.TYPE, n);
        LINKS_SCHEMA.addColumn(OUTDEGREE, Integer.TYPE, n);
        LINKS_SCHEMA.addColumn(INLINKS, int[].class);
        LINKS_SCHEMA.addColumn(OUTLINKS, int[].class);
        LINKS_SCHEMA.lockSchema();
    }

    protected class Listener
    implements TableListener,
    ColumnListener {
        private Table m_edges;
        private Column m_scol;
        private Column m_tcol;
        private int m_sidx;
        private int m_tidx;

        protected Listener() {
        }

        public void setEdgeTable(Table table) {
            if (this.m_scol != null) {
                this.m_scol.removeColumnListener(this);
            }
            if (this.m_tcol != null) {
                this.m_tcol.removeColumnListener(this);
            }
            this.m_tcol = null;
            this.m_scol = null;
            this.m_tidx = -1;
            this.m_sidx = -1;
            this.m_edges = table;
            if (this.m_edges != null) {
                this.m_sidx = table.getColumnNumber(Graph.this.m_skey);
                this.m_tidx = table.getColumnNumber(Graph.this.m_tkey);
                this.m_scol = table.getColumn(this.m_sidx);
                this.m_tcol = table.getColumn(this.m_tidx);
                this.m_scol.addColumnListener(this);
                this.m_tcol.addColumnListener(this);
            }
        }

        public void tableChanged(Table table, int n, int n2, int n3, int n4) {
            if (!Graph.this.containsSet(table)) {
                throw new IllegalStateException("Graph shouldn't be listening to an unrelated table");
            }
            if (n4 != 0) {
                if (table == Graph.this.getNodeTable()) {
                    if (n3 == -1) {
                        boolean bl = n4 == 1;
                        for (int i = n; i <= n2; ++i) {
                            Graph.this.updateNodeData(i, bl);
                        }
                    }
                } else if (n3 == -1) {
                    boolean bl = n4 == 1;
                    for (int i = n; i <= n2; ++i) {
                        Graph.this.updateDegrees(n, bl ? 1 : -1);
                    }
                }
                Graph.this.m_spanning = null;
            }
            Graph.this.fireGraphEvent(table, n, n2, n3, n4);
        }

        public void columnChanged(Column column, int n, int n2) {
            this.columnChanged(column, n, (long)n2);
        }

        public void columnChanged(Column column, int n, long l) {
            if (column == this.m_scol || column == this.m_tcol) {
                boolean bl = column == this.m_scol;
                int n2 = this.m_edges.getTableRow(n, bl ? this.m_sidx : this.m_tidx);
                if (n2 == -1) {
                    return;
                }
                int n3 = Graph.this.getSourceNode(n2);
                int n4 = Graph.this.getTargetNode(n2);
                int n5 = Graph.this.getNodeIndex(l);
                if (n5 > -1 && (bl && n4 > -1 || !bl && n3 > -1)) {
                    Graph.this.updateDegrees(n2, bl ? n5 : n3, bl ? n4 : n5, -1);
                }
                if (n3 > -1 && n4 > -1) {
                    Graph.this.updateDegrees(n2, n3, n4, 1);
                }
            } else {
                throw new IllegalStateException();
            }
        }

        public void columnChanged(Column column, int n, int n2, int n3) {
            throw new IllegalStateException();
        }

        public void columnChanged(Column column, int n, float f) {
            throw new IllegalStateException();
        }

        public void columnChanged(Column column, int n, double d) {
            throw new IllegalStateException();
        }

        public void columnChanged(Column column, int n, boolean bl) {
            throw new IllegalStateException();
        }

        public void columnChanged(Column column, int n, Object object) {
            throw new IllegalStateException();
        }
    }
}

