/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.distortion;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import prefuse.action.distortion.Distortion;

public class BifocalDistortion
extends Distortion {
    private double rx;
    private double ry;
    private double mx;
    private double my;

    public BifocalDistortion() {
        this(0.1, 3.0);
    }

    public BifocalDistortion(double d, double d2) {
        this(d, d2, d, d2);
    }

    public BifocalDistortion(double d, double d2, double d3, double d4) {
        this.rx = d;
        this.mx = d2;
        this.ry = d3;
        this.my = d4;
        this.m_distortX = this.rx != 0.0 && this.mx != 1.0;
        this.m_distortY = this.ry != 0.0 && this.my != 1.0;
    }

    protected double distortX(double d, Point2D point2D, Rectangle2D rectangle2D) {
        return this.bifocal(d, point2D.getX(), this.rx, this.mx, rectangle2D.getMinX(), rectangle2D.getMaxX());
    }

    protected double distortY(double d, Point2D point2D, Rectangle2D rectangle2D) {
        return this.bifocal(d, point2D.getY(), this.ry, this.my, rectangle2D.getMinY(), rectangle2D.getMaxY());
    }

    protected double distortSize(Rectangle2D rectangle2D, double d, double d2, Point2D point2D, Rectangle2D rectangle2D2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        boolean bl = false;
        boolean bl2 = false;
        if (this.m_distortX) {
            d7 = rectangle2D.getCenterX();
            d6 = point2D.getX();
            d5 = rectangle2D2.getMinX();
            d4 = rectangle2D2.getMaxX();
            double d8 = d3 = d7 < d6 ? d6 - d5 : d4 - d6;
            if (d3 == 0.0) {
                d3 = d4 - d5;
            }
            if (Math.abs(d7 - d6) <= this.rx * d3) {
                bl = true;
            }
        }
        if (this.m_distortY) {
            d7 = rectangle2D.getCenterY();
            d6 = point2D.getY();
            d5 = rectangle2D2.getMinY();
            d4 = rectangle2D2.getMaxY();
            double d9 = d3 = d7 < d6 ? d6 - d5 : d4 - d6;
            if (d3 == 0.0) {
                d3 = d4 - d5;
            }
            if (Math.abs(d7 - d6) <= this.ry * d3) {
                bl2 = true;
            }
        }
        if (bl && !this.m_distortY) {
            return this.mx;
        }
        if (bl2 && !this.m_distortX) {
            return this.my;
        }
        if (bl && bl2) {
            return Math.min(this.mx, this.my);
        }
        return Math.min((1.0 - this.rx * this.mx) / (1.0 - this.rx), (1.0 - this.ry * this.my) / (1.0 - this.ry));
    }

    private double bifocal(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8 = d7 = d < d2 ? d2 - d5 : d6 - d2;
        if (d7 == 0.0) {
            d7 = d6 - d5;
        }
        double d9 = d - d2;
        double d10 = d7 * d3;
        if (Math.abs(d9) <= d10) {
            d = d9 * d4 + d2;
            return d;
        }
        double d11 = d3 * d4;
        d = (Math.abs(d9) - d10) / d7 * ((1.0 - d11) / (1.0 - d3));
        return (double)(d9 < 0.0 ? -1 : 1) * d7 * (d + d11) + d2;
    }

    public double getXMagnification() {
        return this.mx;
    }

    public void setXMagnification(double d) {
        this.mx = d;
    }

    public double getYMagnification() {
        return this.my;
    }

    public void setYMagnification(double d) {
        this.my = d;
    }

    public double getXRange() {
        return this.rx;
    }

    public void setXRange(double d) {
        this.rx = d;
    }

    public double getYRange() {
        return this.ry;
    }

    public void setYRange(double d) {
        this.ry = d;
    }
}

