/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql.util;

import java.util.HashMap;
import java.util.Map;
import org.python.core.Py;
import org.python.core.PyObject;

public class PyArgParser {
    protected Map keywords = new HashMap();
    protected PyObject[] arguments = null;

    public PyArgParser(PyObject[] pyObjectArray, String[] stringArray) {
        this.parse(pyObjectArray, stringArray);
    }

    protected void parse(PyObject[] pyObjectArray, String[] stringArray) {
        int n = pyObjectArray.length;
        if (stringArray != null) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                this.keywords.put(stringArray[i], pyObjectArray[--n]);
            }
        }
        this.arguments = new PyObject[n];
        System.arraycopy(pyObjectArray, 0, this.arguments, 0, n);
    }

    public int numKw() {
        return this.keywords.keySet().size();
    }

    public boolean hasKw(String string) {
        return this.keywords.containsKey(string);
    }

    public PyObject kw(String string) {
        if (!this.hasKw(string)) {
            throw Py.KeyError(string);
        }
        return (PyObject)this.keywords.get(string);
    }

    public PyObject kw(String string, PyObject pyObject) {
        if (!this.hasKw(string)) {
            return pyObject;
        }
        return (PyObject)this.keywords.get(string);
    }

    public String[] kws() {
        return this.keywords.keySet().toArray(new String[0]);
    }

    public int numArg() {
        return this.arguments.length;
    }

    public PyObject arg(int n) {
        if (n >= 0 && n <= this.arguments.length - 1) {
            return this.arguments[n];
        }
        throw Py.IndexError("index out of range");
    }

    public PyObject arg(int n, PyObject pyObject) {
        if (n >= 0 && n <= this.arguments.length - 1) {
            return this.arguments[n];
        }
        return pyObject;
    }
}

