/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual;

import java.util.HashSet;
import java.util.Iterator;
import prefuse.Visualization;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.util.Index;
import prefuse.util.collections.IntIterator;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;
import prefuse.visual.tuple.TableAggregateItem;

public class AggregateTable
extends VisualTable {
    protected Table m_aggregated = AGGREGATED_SCHEMA.instantiate();
    protected static final String AGGREGATE = "aggregate";
    protected static final String MEMBER_HASH = "hash";
    protected static final String MEMBER = "member";
    protected static final Schema AGGREGATED_SCHEMA = new Schema();

    public AggregateTable(Visualization visualization, String string) {
        this(visualization, string, VisualItem.SCHEMA);
    }

    public AggregateTable(Visualization visualization, String string, Schema schema) {
        super(visualization, string, schema, TableAggregateItem.class);
        this.m_aggregated.index(AGGREGATE);
        this.m_aggregated.index(MEMBER_HASH);
    }

    public int getAggregateSize(int n) {
        int n2 = 0;
        AggregatedIterator aggregatedIterator = new AggregatedIterator(n);
        while (aggregatedIterator.hasNext()) {
            ++n2;
            aggregatedIterator.next();
        }
        return n2;
    }

    public void addToAggregate(int n, VisualItem visualItem) {
        this.validRowCheck(n, true);
        if (!this.aggregateContains(n, visualItem)) {
            int n2 = this.m_aggregated.addRow();
            this.m_aggregated.setInt(n2, AGGREGATE, n);
            this.m_aggregated.setInt(n2, MEMBER_HASH, this.getHashCode(visualItem));
            this.m_aggregated.set(n2, MEMBER, (Object)visualItem);
            this.fireTableEvent(n, n, -1, 0);
        }
    }

    public void removeFromAggregate(int n, VisualItem visualItem) {
        this.validRowCheck(n, true);
        int n2 = this.getAggregatedRow(n, visualItem);
        if (n2 >= 0) {
            this.m_aggregated.removeRow(n2);
            this.fireTableEvent(n, n, -1, 0);
        }
    }

    public void removeAllFromAggregate(int n) {
        this.clearAggregateMappings(n, true);
    }

    protected void clearAggregateMappings(int n, boolean bl) {
        Index index = this.m_aggregated.index(AGGREGATE);
        boolean bl2 = false;
        IntIterator intIterator = index.rows(n);
        while (intIterator.hasNext()) {
            int n2 = intIterator.nextInt();
            intIterator.remove();
            this.m_aggregated.removeRow(n2);
            bl2 = true;
        }
        if (bl && bl2) {
            this.fireTableEvent(n, n, -1, 0);
        }
    }

    public boolean aggregateContains(int n, VisualItem visualItem) {
        return this.getAggregatedRow(n, visualItem) >= 0;
    }

    protected int getAggregatedRow(int n, VisualItem visualItem) {
        int n2;
        Index index = this.m_aggregated.index(MEMBER_HASH);
        int n3 = index.get(n2 = this.getHashCode(visualItem));
        if (n3 < 0) {
            return -1;
        }
        if (this.m_aggregated.getInt(n3, AGGREGATE) == n) {
            return n3;
        }
        IntIterator intIterator = index.rows(n2);
        while (intIterator.hasNext()) {
            n3 = intIterator.nextInt();
            if (this.m_aggregated.getInt(n3, AGGREGATE) != n) continue;
            return n3;
        }
        return -1;
    }

    public Iterator aggregatedTuples(int n) {
        return new AggregatedIterator(n);
    }

    public Iterator getAggregates(Tuple tuple) {
        int n = this.getHashCode(tuple);
        IntIterator intIterator = this.m_aggregated.getIndex(MEMBER_HASH).rows(n);
        HashSet<Tuple> hashSet = new HashSet<Tuple>();
        while (intIterator.hasNext()) {
            int n2 = intIterator.nextInt();
            hashSet.add(this.getTuple(this.m_aggregated.getInt(n2, AGGREGATE)));
        }
        return hashSet.iterator();
    }

    protected int getHashCode(Tuple tuple) {
        return tuple.hashCode();
    }

    protected boolean validRowCheck(int n, boolean bl) {
        if (this.isValidRow(n)) {
            return true;
        }
        if (bl) {
            throw new IllegalArgumentException("Invalid row value: " + n);
        }
        return false;
    }

    protected void fireTableEvent(int n, int n2, int n3, int n4) {
        if (n3 == -1 && n4 == -1) {
            for (int i = n; i <= n2; ++i) {
                this.clearAggregateMappings(i, false);
            }
        }
        super.fireTableEvent(n, n2, n3, n4);
    }

    static {
        AGGREGATED_SCHEMA.addColumn(AGGREGATE, Integer.TYPE);
        AGGREGATED_SCHEMA.addColumn(MEMBER_HASH, Integer.TYPE);
        AGGREGATED_SCHEMA.addColumn(MEMBER, Tuple.class);
    }

    protected class AggregatedIterator
    implements Iterator {
        private IntIterator m_rows;
        private Tuple m_next = null;

        public AggregatedIterator(int n) {
            Index index = AggregateTable.this.m_aggregated.index(AggregateTable.AGGREGATE);
            this.m_rows = index.rows(n);
            this.advance();
        }

        public boolean hasNext() {
            return this.m_next != null;
        }

        public Object next() {
            Tuple tuple = this.m_next;
            this.advance();
            return tuple;
        }

        private void advance() {
            while (this.m_rows.hasNext()) {
                int n = this.m_rows.nextInt();
                Tuple tuple = (Tuple)AggregateTable.this.m_aggregated.get(n, AggregateTable.MEMBER);
                if (tuple.isValid()) {
                    this.m_next = tuple;
                    return;
                }
                AggregateTable.this.m_aggregated.removeRow(n);
            }
            this.m_next = null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

