/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.ArrayList;
import java.util.Arrays;
import prefuse.util.collections.AbstractHashMap;

public class IntObjectHashMap
extends AbstractHashMap
implements Cloneable {
    protected static final int defaultCapacity = 277;
    protected static final double defaultMinLoadFactor = 0.2;
    protected static final double defaultMaxLoadFactor = 0.5;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    protected int[] table;
    protected Object[] values;
    protected byte[] state;
    protected int freeEntries;

    public IntObjectHashMap() {
        this(277);
    }

    public IntObjectHashMap(int n) {
        this(n, 0.2, 0.5);
    }

    public IntObjectHashMap(int n, double d, double d2) {
        this.setUp(n, d, d2);
    }

    public void clear() {
        Arrays.fill(this.state, (byte)0);
        Arrays.fill(this.values, null);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    public Object clone() {
        try {
            IntObjectHashMap intObjectHashMap = (IntObjectHashMap)super.clone();
            intObjectHashMap.table = (int[])intObjectHashMap.table.clone();
            intObjectHashMap.values = (Object[])intObjectHashMap.values.clone();
            intObjectHashMap.state = (byte[])intObjectHashMap.state.clone();
            return intObjectHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean containsKey(int n) {
        return this.indexOfKey(n) >= 0;
    }

    public boolean containsValue(Object object) {
        return this.indexOfValue(object) >= 0;
    }

    public void ensureCapacity(int n) {
        if (this.table.length < n) {
            int n2 = this.nextPrime(n);
            this.rehash(n2);
        }
    }

    public Object get(int n) {
        int n2 = this.indexOfKey(n);
        if (n2 < 0) {
            return null;
        }
        return this.values[n2];
    }

    protected int indexOfInsertion(int n) {
        int[] nArray = this.table;
        byte[] byArray = this.state;
        int n2 = nArray.length;
        int n3 = n & Integer.MAX_VALUE;
        int n4 = n3 % n2;
        int n5 = n3 % (n2 - 2);
        if (n5 == 0) {
            n5 = 1;
        }
        while (byArray[n4] == 1 && nArray[n4] != n) {
            if ((n4 -= n5) >= 0) continue;
            n4 += n2;
        }
        if (byArray[n4] == 2) {
            int n6 = n4;
            while (byArray[n4] != 0 && (byArray[n4] == 2 || nArray[n4] != n)) {
                if ((n4 -= n5) >= 0) continue;
                n4 += n2;
            }
            if (byArray[n4] == 0) {
                n4 = n6;
            }
        }
        if (byArray[n4] == 1) {
            return -n4 - 1;
        }
        return n4;
    }

    protected int indexOfKey(int n) {
        int[] nArray = this.table;
        byte[] byArray = this.state;
        int n2 = nArray.length;
        int n3 = n & Integer.MAX_VALUE;
        int n4 = n3 % n2;
        int n5 = n3 % (n2 - 2);
        if (n5 == 0) {
            n5 = 1;
        }
        while (byArray[n4] != 0 && (byArray[n4] == 2 || nArray[n4] != n)) {
            if ((n4 -= n5) >= 0) continue;
            n4 += n2;
        }
        if (byArray[n4] == 0) {
            return -1;
        }
        return n4;
    }

    protected int indexOfValue(Object object) {
        Object[] objectArray = this.values;
        byte[] byArray = this.state;
        int n = byArray.length;
        while (--n >= 0) {
            if (byArray[n] != 1 || objectArray[n] != object) continue;
            return n;
        }
        return -1;
    }

    public int keyOf(Object object) {
        int n = this.indexOfValue(object);
        if (n < 0) {
            return Integer.MIN_VALUE;
        }
        return this.table[n];
    }

    public int keys(int[] nArray) {
        int[] nArray2 = this.table;
        byte[] byArray = this.state;
        if (nArray.length < this.distinct) {
            return -1;
        }
        int n = 0;
        int n2 = nArray2.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1) continue;
            nArray[n++] = nArray2[n2];
        }
        return this.distinct;
    }

    public boolean put(int n, Object object) {
        int n2 = this.indexOfInsertion(n);
        if (n2 < 0) {
            n2 = -n2 - 1;
            this.values[n2] = object;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int n3 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n3);
            return this.put(n, object);
        }
        this.table[n2] = n;
        this.values[n2] = object;
        if (this.state[n2] == 0) {
            --this.freeEntries;
        }
        this.state[n2] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int n4 = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n4);
        }
        return true;
    }

    protected void rehash(int n) {
        int n2 = this.table.length;
        int[] nArray = this.table;
        Object[] objectArray = this.values;
        byte[] byArray = this.state;
        int[] nArray2 = new int[n];
        Object[] objectArray2 = new Object[n];
        byte[] byArray2 = new byte[n];
        this.lowWaterMark = this.chooseLowWaterMark(n, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(n, this.maxLoadFactor);
        this.table = nArray2;
        this.values = objectArray2;
        this.state = byArray2;
        this.freeEntries = n - this.distinct;
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            int n4 = nArray[n3];
            int n5 = this.indexOfInsertion(n4);
            nArray2[n5] = n4;
            objectArray2[n5] = objectArray[n3];
            byArray2[n5] = 1;
        }
    }

    public boolean removeKey(int n) {
        int n2 = this.indexOfKey(n);
        if (n2 < 0) {
            return false;
        }
        this.state[n2] = 2;
        this.values[n2] = null;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int n3 = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(n3);
        }
        return true;
    }

    protected void setUp(int n, double d, double d2) {
        int n2 = n;
        super.setUp(n2, d, d2);
        n2 = this.nextPrime(n2);
        if (n2 == 0) {
            n2 = 1;
        }
        this.table = new int[n2];
        this.values = new Object[n2];
        this.state = new byte[n2];
        this.minLoadFactor = d;
        this.maxLoadFactor = n2 == Integer.MAX_VALUE ? 1.0 : d2;
        this.distinct = 0;
        this.freeEntries = n2;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(n2, this.maxLoadFactor);
    }

    public void trimToSize() {
        int n = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > n) {
            this.rehash(n);
        }
    }

    public void values(ArrayList arrayList) {
        Object[] objectArray = this.values;
        byte[] byArray = this.state;
        int n = byArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            arrayList.add(objectArray[n]);
        }
    }
}

