/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Arrays;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;

public class IntColumn
extends AbstractColumn {
    private int[] m_values;
    private int m_size;

    public IntColumn() {
        this(0, 10, -1);
    }

    public IntColumn(int n) {
        this(n, n, -1);
    }

    public IntColumn(int n, int n2, int n3) {
        super(Integer.TYPE, new Integer(n3));
        if (n2 < n) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new int[n2];
        Arrays.fill(this.m_values, n3);
        this.m_size = n;
    }

    public int getRowCount() {
        return this.m_size;
    }

    public void setMaximumRow(int n) {
        if (n > this.m_values.length) {
            int n2 = Math.max(3 * this.m_values.length / 2 + 1, n);
            int[] nArray = new int[n2];
            System.arraycopy(this.m_values, 0, nArray, 0, this.m_size);
            Arrays.fill(nArray, this.m_size, n2, (Integer)this.m_defaultValue);
            this.m_values = nArray;
        }
        this.m_size = n;
    }

    public Object get(int n) {
        return new Integer(this.getInt(n));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(Object object, int n) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (object == null) throw new DataTypeException("Column does not accept null values");
        if (object instanceof Number) {
            this.setInt(((Number)object).intValue(), n);
            return;
        } else {
            if (!(object instanceof String)) throw new DataTypeException(object.getClass());
            this.setString((String)object, n);
        }
    }

    public int getInt(int n) throws DataTypeException {
        if (n < 0 || n > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n);
        }
        return this.m_values[n];
    }

    public void setInt(int n, int n2) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (n2 < 0 || n2 >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + n2);
        }
        int n3 = this.m_values[n2];
        if (n3 == n) {
            return;
        }
        this.m_values[n2] = n;
        this.fireColumnEvent(n2, n3);
    }

    public long getLong(int n) throws DataTypeException {
        return this.getInt(n);
    }

    public float getFloat(int n) throws DataTypeException {
        return this.getInt(n);
    }

    public double getDouble(int n) throws DataTypeException {
        return this.getInt(n);
    }
}

