/*
 * Decompiled with CFR 0.152.
 */
package prefuse.activity;

import java.util.ArrayList;
import prefuse.activity.Activity;
import prefuse.activity.ActivityAdapter;
import prefuse.util.PrefuseConfig;

public class ActivityManager
extends Thread {
    private static ActivityManager s_instance;
    private ArrayList m_activities = new ArrayList();
    private ArrayList m_tmp = new ArrayList();
    private long m_nextTime = Long.MAX_VALUE;
    private boolean m_run;

    private static synchronized ActivityManager getInstance() {
        if (s_instance == null || !s_instance.isAlive()) {
            s_instance = new ActivityManager();
        }
        return s_instance;
    }

    private ActivityManager() {
        super("prefuse_ActivityManager");
        int n = PrefuseConfig.getInt("activity.threadPriority");
        if (n >= 1 && n <= 10) {
            this.setPriority(n);
        }
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopThread() {
        Class<ActivityManager> clazz = ActivityManager.class;
        synchronized (ActivityManager.class) {
            ActivityManager activityManager = s_instance;
            // ** MonitorExit[var1] (shouldn't be in output)
            if (activityManager != null) {
                activityManager._stop();
            }
            return;
        }
    }

    static void schedule(Activity activity) {
        ActivityManager.getInstance()._schedule(activity, activity.getStartTime());
    }

    static void scheduleNow(Activity activity) {
        ActivityManager.getInstance()._schedule(activity, System.currentTimeMillis());
    }

    static void scheduleAt(Activity activity, long l) {
        ActivityManager.getInstance()._schedule(activity, l);
    }

    static void scheduleAfter(Activity activity, Activity activity2) {
        ActivityManager.getInstance()._scheduleAfter(activity, activity2);
    }

    static void alwaysScheduleAfter(Activity activity, Activity activity2) {
        ActivityManager.getInstance()._alwaysScheduleAfter(activity, activity2);
    }

    static void removeActivity(Activity activity) {
        ActivityManager.getInstance()._removeActivity(activity);
    }

    public static int activityCount() {
        return ActivityManager.getInstance()._activityCount();
    }

    private synchronized void _stop() {
        while (this.m_activities.size() > 0) {
            Activity activity = (Activity)this.m_activities.get(this.m_activities.size() - 1);
            activity.cancel();
        }
        this._setRunning(false);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _schedule(Activity activity, long l) {
        if (activity.isScheduled()) {
            return;
        }
        activity.setStartTime(l);
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            this.m_activities.add(activity);
            activity.setScheduled(true);
            if (l < this.m_nextTime) {
                this.m_nextTime = l;
                this.notify();
            }
        }
    }

    private void _scheduleAfter(Activity activity, Activity activity2) {
        activity.addActivityListener(new ScheduleAfterActivity(activity2, true));
    }

    private void _alwaysScheduleAfter(Activity activity, Activity activity2) {
        activity.addActivityListener(new ScheduleAfterActivity(activity2, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _removeActivity(Activity activity) {
        boolean bl;
        ActivityManager activityManager = this;
        synchronized (activityManager) {
            bl = this.m_activities.remove(activity);
            if (bl && this.m_activities.size() == 0) {
                this.m_nextTime = Long.MAX_VALUE;
            }
        }
        if (bl) {
            activity.setScheduled(false);
        }
        return bl;
    }

    private synchronized int _activityCount() {
        return this.m_activities.size();
    }

    private synchronized void _setRunning(boolean bl) {
        this.m_run = bl;
    }

    private synchronized boolean _keepRunning() {
        return this.m_run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this._setRunning(true);
        while (this._keepRunning()) {
            if (this._activityCount() > 0) {
                long l = System.currentTimeMillis();
                long l2 = -1L;
                ActivityManager activityManager = this;
                synchronized (activityManager) {
                    for (int i = 0; i < this.m_activities.size(); ++i) {
                        Activity activity = (Activity)this.m_activities.get(i);
                        this.m_tmp.add(activity);
                        if (l < activity.getStopTime()) continue;
                        this.m_activities.remove(i--);
                        activity.setScheduled(false);
                    }
                    if (this.m_activities.size() == 0) {
                        this.m_nextTime = Long.MAX_VALUE;
                    }
                }
                for (int i = 0; i < this.m_tmp.size(); ++i) {
                    Activity activity = (Activity)this.m_tmp.get(i);
                    long l3 = activity.runActivity(l);
                    l2 = l3 < 0L ? l2 : (l2 < 0L ? l3 : Math.min(l2, l3));
                }
                this.m_tmp.clear();
                if (l2 == -1L) continue;
                try {
                    ActivityManager activityManager2 = this;
                    synchronized (activityManager2) {
                        this.wait(l2);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
            }
            try {
                ActivityManager activityManager = this;
                synchronized (activityManager) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public class ScheduleAfterActivity
    extends ActivityAdapter {
        Activity after;
        boolean remove;

        public ScheduleAfterActivity(Activity activity, boolean bl) {
            this.after = activity;
            this.remove = bl;
        }

        public void activityFinished(Activity activity) {
            if (this.remove) {
                activity.removeActivityListener(this);
            }
            ActivityManager.scheduleNow(this.after);
        }

        public void activityCancelled(Activity activity) {
            if (this.remove) {
                activity.removeActivityListener(this);
            }
        }
    }
}

