/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.io.AbstractGraphWriter;
import prefuse.data.io.DataIOException;
import prefuse.data.io.GraphMLReader;
import prefuse.util.io.XMLWriter;

public class GraphMLWriter
extends AbstractGraphWriter {
    private static final HashMap TYPES = new HashMap();

    public void writeGraph(Graph graph, OutputStream outputStream) throws DataIOException {
        Object object;
        String[] stringArray;
        Schema schema = graph.getNodeTable().getSchema();
        Schema schema2 = graph.getEdgeTable().getSchema();
        this.checkGraphMLSchema(schema);
        this.checkGraphMLSchema(schema2);
        XMLWriter xMLWriter = new XMLWriter(new PrintWriter(outputStream));
        xMLWriter.begin("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns\n  http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n\n", 2);
        xMLWriter.comment("prefuse GraphML Writer | " + new Date(System.currentTimeMillis()));
        this.printSchema(xMLWriter, "node", schema, null);
        this.printSchema(xMLWriter, "edge", schema2, new String[]{graph.getEdgeSourceField(), graph.getEdgeTargetField()});
        xMLWriter.println();
        xMLWriter.start("graph", "edgedefault", graph.isDirected() ? "directed" : "undirected");
        xMLWriter.comment("nodes");
        Iterator iterator = graph.nodes();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            if (schema.getColumnCount() > 0) {
                xMLWriter.start("node", "id", String.valueOf(stringArray.getRow()));
                for (int i = 0; i < schema.getColumnCount(); ++i) {
                    object = schema.getColumnName(i);
                    xMLWriter.contentTag("data", "key", (String)object, stringArray.getString((String)object));
                }
                xMLWriter.end();
                continue;
            }
            xMLWriter.tag("node", "id", String.valueOf(stringArray.getRow()));
        }
        xMLWriter.println();
        stringArray = new String[]{"id", "source", "target"};
        String[] stringArray2 = new String[3];
        xMLWriter.comment("edges");
        object = graph.edges();
        while (object.hasNext()) {
            Edge edge = (Edge)object.next();
            stringArray2[0] = String.valueOf(edge.getRow());
            stringArray2[1] = String.valueOf(edge.getSourceNode().getRow());
            stringArray2[2] = String.valueOf(edge.getTargetNode().getRow());
            if (schema2.getColumnCount() > 2) {
                xMLWriter.start("edge", stringArray, stringArray2, 3);
                for (int i = 0; i < schema2.getColumnCount(); ++i) {
                    String string = schema2.getColumnName(i);
                    if (string.equals(graph.getEdgeSourceField()) || string.equals(graph.getEdgeTargetField())) continue;
                    xMLWriter.contentTag("data", "key", string, edge.getString(string));
                }
                xMLWriter.end();
                continue;
            }
            xMLWriter.tag("edge", stringArray, stringArray2, 3);
        }
        xMLWriter.end();
        xMLWriter.finish("</graphml>\n");
    }

    private void printSchema(XMLWriter xMLWriter, String string, Schema schema, String[] stringArray) {
        String[] stringArray2 = new String[]{"id", "for", "attr.name", "attr.type"};
        String[] stringArray3 = new String[4];
        block0: for (int i = 0; i < schema.getColumnCount(); ++i) {
            stringArray3[0] = schema.getColumnName(i);
            for (int j = 0; stringArray != null && j < stringArray.length; ++j) {
                if (stringArray3[0].equals(stringArray[j])) continue block0;
            }
            stringArray3[1] = string;
            stringArray3[2] = stringArray3[0];
            stringArray3[3] = (String)TYPES.get(schema.getColumnType(i));
            Object object = schema.getDefault(i);
            if (object == null) {
                xMLWriter.tag("key", stringArray2, stringArray3, 4);
                continue;
            }
            xMLWriter.start("key", stringArray2, stringArray3, 4);
            xMLWriter.contentTag("default", object.toString());
            xMLWriter.end();
        }
    }

    private void checkGraphMLSchema(Schema schema) throws DataIOException {
        for (int i = 0; i < schema.getColumnCount(); ++i) {
            Class clazz = schema.getColumnType(i);
            if (TYPES.get(clazz) != null) continue;
            throw new DataIOException("Data type unsupported by the GraphML format: " + clazz.getName());
        }
    }

    static {
        TYPES.put(Integer.TYPE, "int");
        TYPES.put(Long.TYPE, "long");
        TYPES.put(Float.TYPE, "float");
        TYPES.put(Double.TYPE, "double");
        TYPES.put(Boolean.TYPE, "boolean");
        TYPES.put(String.class, "string");
    }

    public static interface Tokens
    extends GraphMLReader.Tokens {
        public static final String GRAPHML = "graphml";
        public static final String GRAPHML_HEADER = "<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns\n  http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n\n";
    }
}

