/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.util.ArrayList;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Tree;

public class GraphLib {
    public static final String LABEL = "label";
    public static final Schema LABEL_SCHEMA = new Schema();

    private GraphLib() {
    }

    public static Graph getNodes(int n) {
        Graph graph = new Graph();
        graph.getNodeTable().addColumns(LABEL_SCHEMA);
        for (int i = 0; i < n; ++i) {
            Node node = graph.addNode();
            node.setString(LABEL, String.valueOf(i));
        }
        return graph;
    }

    public static Graph getStar(int n) {
        Graph graph = new Graph();
        graph.getNodeTable().addColumns(LABEL_SCHEMA);
        Node node = graph.addNode();
        node.setString(LABEL, "0");
        for (int i = 1; i <= n; ++i) {
            Node node2 = graph.addNode();
            node2.setString(LABEL, String.valueOf(i));
            graph.addEdge(node, node2);
        }
        return graph;
    }

    public static Graph getClique(int n) {
        int n2;
        Graph graph = new Graph();
        graph.getNodeTable().addColumns(LABEL_SCHEMA);
        Node[] nodeArray = new Node[n];
        for (n2 = 0; n2 < n; ++n2) {
            nodeArray[n2] = graph.addNode();
            nodeArray[n2].setString(LABEL, String.valueOf(n2));
        }
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = n2; i < n; ++i) {
                if (n2 == i) continue;
                graph.addEdge(nodeArray[n2], nodeArray[i]);
            }
        }
        return graph;
    }

    public static Graph getGrid(int n, int n2) {
        Graph graph = new Graph();
        graph.getNodeTable().addColumns(LABEL_SCHEMA);
        Node[] nodeArray = new Node[n * n2];
        for (int i = 0; i < n * n2; ++i) {
            nodeArray[i] = graph.addNode();
            nodeArray[i].setString(LABEL, String.valueOf(i));
            if (i >= n2) {
                graph.addEdge(nodeArray[i - n2], nodeArray[i]);
            }
            if (i % n2 == 0) continue;
            graph.addEdge(nodeArray[i - 1], nodeArray[i]);
        }
        return graph;
    }

    public static Graph getHoneycomb(int n) {
        Graph graph = new Graph();
        graph.getNodeTable().addColumns(LABEL_SCHEMA);
        ArrayList arrayList = GraphLib.halfcomb(graph, n);
        ArrayList arrayList2 = GraphLib.halfcomb(graph, n);
        for (int i = 0; i < n << 1; ++i) {
            Node node = (Node)arrayList.get(i);
            Node node2 = (Node)arrayList2.get(i);
            graph.addEdge(node, node2);
        }
        return graph;
    }

    private static ArrayList halfcomb(Graph graph, int n) {
        Node node;
        int n2;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            node = graph.addNode();
            node.setString(LABEL, String.valueOf(n3++));
            arrayList.add(node);
        }
        for (n2 = 0; n2 < n; ++n2) {
            Node node2;
            int n4;
            node = null;
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                node2 = (Node)arrayList.get(n4);
                if (node == null) {
                    node = graph.addNode();
                    node.setString(LABEL, String.valueOf(n3++));
                    arrayList2.add(node);
                }
                graph.addEdge(node2, node);
                node = graph.addNode();
                node.setString(LABEL, String.valueOf(n3++));
                arrayList2.add(node);
                graph.addEdge(node2, node);
            }
            if (n2 == n - 1) {
                return arrayList2;
            }
            arrayList.clear();
            for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                node2 = (Node)arrayList2.get(n4);
                node = graph.addNode();
                node.setString(LABEL, String.valueOf(n3++));
                arrayList.add(node);
                graph.addEdge(node2, node);
            }
            arrayList2.clear();
        }
        return arrayList;
    }

    public static Tree getBalancedTree(int n, int n2) {
        Tree tree = new Tree();
        tree.getNodeTable().addColumns(LABEL_SCHEMA);
        Node node = tree.addRoot();
        node.setString(LABEL, "0,0");
        if (n2 > 0) {
            GraphLib.balancedHelper(tree, node, n, n2 - 1);
        }
        return tree;
    }

    private static void balancedHelper(Tree tree, Node node, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            Node node2 = tree.addChild(node);
            node2.setString(LABEL, i + "," + node2.getDepth());
            if (n2 <= 0) continue;
            GraphLib.balancedHelper(tree, node2, n, n2 - 1);
        }
    }

    public static Tree getLeftDeepTree(int n) {
        Tree tree = new Tree();
        tree.getNodeTable().addColumns(LABEL_SCHEMA);
        Node node = tree.addRoot();
        node.setString(LABEL, "0,0");
        GraphLib.deepHelper(tree, node, 2, n, true);
        return tree;
    }

    public static Tree getRightDeepTree(int n) {
        Tree tree = new Tree();
        tree.getNodeTable().addColumns(LABEL_SCHEMA);
        Node node = tree.addRoot();
        node.setString(LABEL, "0,0");
        GraphLib.deepHelper(tree, node, 2, n, false);
        return tree;
    }

    public static Tree getDiamondTree(int n, int n2, int n3) {
        Tree tree = new Tree();
        tree.getNodeTable().addColumns(LABEL_SCHEMA);
        Node node = tree.addRoot();
        node.setString(LABEL, "0,0");
        Node node2 = tree.addChild(node);
        node2.setString(LABEL, "1,0");
        Node node3 = tree.addChild(node);
        node3.setString(LABEL, "1,1");
        GraphLib.deepHelper(tree, node2, n, n2 - 2, true);
        GraphLib.deepHelper(tree, node3, n, n2 - 2, false);
        while (node2.getFirstChild() != null) {
            node2 = node2.getFirstChild();
        }
        while (node3.getLastChild() != null) {
            node3 = node3.getLastChild();
        }
        GraphLib.deepHelper(tree, node2, n, n3 - 1, false);
        GraphLib.deepHelper(tree, node3, n, n3 - 1, true);
        return tree;
    }

    private static void deepHelper(Tree tree, Node node, int n, int n2, boolean bl) {
        Node node2 = tree.addChild(node);
        node2.setString(LABEL, "0," + node2.getDepth());
        if (bl && n2 > 0) {
            GraphLib.deepHelper(tree, node2, n, n2 - 1, bl);
        }
        for (int i = 1; i < n; ++i) {
            node2 = tree.addChild(node);
            node2.setString(LABEL, i + "," + node2.getDepth());
        }
        if (!bl && n2 > 0) {
            GraphLib.deepHelper(tree, node2, n, n2 - 1, bl);
        }
    }

    static {
        LABEL_SCHEMA.addColumn(LABEL, String.class, "");
    }
}

