
#
# Based on ParaView/VTK/Utilities/vtkTclTest2Py/CMakeLists.txt and
#          ParaView/VTK/Wrapping/Python/CMakeLists.txt
#

MACRO(Slicer3_compile_python_scripts)
  SLICER3_PARSE_ARGUMENTS(MY
    "TARGET_NAME;SCRIPTS;RESOURCES;DESTINATION_DIR;INSTALL_DIR"
    ""
    ${ARGN}
    )
  
  FIND_PACKAGE(PythonInterp REQUIRED)
  
  # Sanity checks
  FOREACH(varname TARGET_NAME SCRIPTS DESTINATION_DIR;INSTALL_DIR)
    IF(NOT DEFINED MY_${varname})
      MESSAGE(SEND_ERROR "${varname} is mandatory")
    ENDIF()
  ENDFOREACH()
  
  set(copied_files)
  set(copied_python_files)
  FOREACH(file ${MY_SCRIPTS})
    SET(src "${CMAKE_CURRENT_SOURCE_DIR}/${file}.py")
    SET(tgt "${MY_DESTINATION_DIR}/${file}.py")
    SET(copied_python_files ${copied_python_files} ${tgt})
    SET(copied_files ${copied_files} ${tgt})
    ADD_CUSTOM_COMMAND(DEPENDS ${src}
                        COMMAND ${CMAKE_COMMAND} -E copy ${src} ${tgt}
                        OUTPUT ${tgt}
                        COMMENT "Copying python script: ${file}.py")
  ENDFOREACH()

  IF(DEFINED MY_RESOURCES)
    FOREACH(file ${MY_RESOURCES})
      SET(src "${CMAKE_CURRENT_SOURCE_DIR}/${file}")
      SET(tgt "${MY_DESTINATION_DIR}/${file}")
      SET(copied_files ${copied_files} ${tgt})
      ADD_CUSTOM_COMMAND(DEPENDS ${src}
                          COMMAND ${CMAKE_COMMAND} -E copy ${src} ${tgt}
                          OUTPUT ${tgt}
                          COMMENT "Copying python resource: ${file}")
    ENDFOREACH()

    ADD_CUSTOM_TARGET(Copy${MY_TARGET_NAME}PythonFiles
                      ALL
                      DEPENDS ${copied_files})
  ENDIF()
                    
  
  # Byte compile the Python files.
  SET(compile_all_script "${CMAKE_CURRENT_BINARY_DIR}/compile_${MY_TARGET_NAME}_python_scripts.py")
  
  # Generate compile_${MY_TARGET_NAME}_python_scripts.py
  FILE(WRITE ${compile_all_script} "
#
# Generated by Slicer3_compile_python_scripts CMAKE macro
#

# Based on paraview/VTK/Wrapping/Python/compile_all_vtk.py.in

import compileall
compileall.compile_dir('@MY_DESTINATION_DIR@')
file = open('@CMAKE_CURRENT_BINARY_DIR@/python_compile_@MY_TARGET_NAME@_complete', 'w')
file.write('Done')
")

  ADD_CUSTOM_COMMAND(
    COMMAND ${PYTHON_EXECUTABLE}
    ARGS  "${compile_all_script}"
    DEPENDS ${copied_python_files}  ${compile_all_script}
    OUTPUT "${CMAKE_CURRENT_BINARY_DIR}/python_compile_${MY_TARGET_NAME}_complete"
    COMMENT "Compiling python scripts: ${MY_TARGET_NAME}"
    )

  ADD_CUSTOM_TARGET(Compile${MY_TARGET_NAME}PythonFiles ALL
    DEPENDS 
      ${CMAKE_CURRENT_BINARY_DIR}/python_compile_${MY_TARGET_NAME}_complete
      ${compile_all_script}
      )   
  
  # Install python module directory
  INSTALL(DIRECTORY "${MY_DESTINATION_DIR}"
    DESTINATION "${MY_INSTALL_DIR}" COMPONENT Runtime
    USE_SOURCE_PERMISSIONS)
       
ENDMACRO()

