// Qt includes
#include <QDebug>

// qSlicer includes
#include "qSlicerIOOptionsWidget.h"

//------------------------------------------------------------------------------
qSlicerIOOptionsWidget::qSlicerIOOptionsWidget(QWidget* parentWidget)
  :qSlicerWidget(parentWidget)
{
}

//------------------------------------------------------------------------------
qSlicerIOOptionsWidget::~qSlicerIOOptionsWidget()
{
}

//------------------------------------------------------------------------------
bool qSlicerIOOptionsWidget::isValid()const
{
  return this->Properties.contains("fileName") || this->Properties.contains("fileNames");
}

//------------------------------------------------------------------------------
void qSlicerIOOptionsWidget::setFileName(const QString& fileName)
{
  qDebug() << "setFileName:" << fileName;
  bool oldValid = this->isValid();
  // replace the old filename if any
  if (!fileName.isEmpty())
    {
    this->Properties["fileName"] = fileName;
    }
  else
    {
    this->Properties.remove("fileName");
    }
  this->Properties.remove("fileNames");
  bool newValid = this->isValid();
  if (oldValid != newValid)
    {
    emit this->validChanged(newValid);
    }
}

//------------------------------------------------------------------------------
void qSlicerIOOptionsWidget::setFileNames(const QStringList& fileNames)
{
  bool oldValid = this->isValid();
  if (fileNames.count())
    {
    this->Properties["fileNames"] = fileNames;
    }
  else
    {
    this->Properties.remove("fileNames");
    }
  this->Properties.remove("fileName");
  bool newValid = this->isValid();
  if (oldValid != newValid)
    {
    emit this->validChanged(newValid);
    }
}
