/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

public class ExtraMath {
    public static double LOG10 = Math.log(10.0);
    public static double EPSILON = Math.pow(2.0, -52.0);
    public static double CLOSE = EPSILON * 2.0;

    public static double log10(double d) {
        return Math.log(d) / LOG10;
    }

    public static double hypot(double d, double d2) {
        double d3;
        if ((d = Math.abs(d)) < (d2 = Math.abs(d2))) {
            d3 = d;
            d = d2;
            d2 = d3;
        }
        if (d == 0.0) {
            return 0.0;
        }
        d3 = d2 / d;
        return d * Math.sqrt(1.0 + d3 * d3);
    }

    public static boolean close(double d, double d2, double d3) {
        if (d == d2) {
            return true;
        }
        double d4 = d3 * (Math.abs(d) + Math.abs(d2)) / 2.0;
        return Math.abs(d2 - d) < d4;
    }

    public static boolean close(double d, double d2) {
        return ExtraMath.close(d, d2, CLOSE);
    }

    public static double closeFloor(double d) {
        double d2 = Math.floor(d);
        return ExtraMath.close(d, d2 + 1.0) ? d2 + 1.0 : d2;
    }
}

