/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.collections;

import java.util.Comparator;

public class CompositeComparator
implements Comparator {
    private static final int INCREMENT = 2;
    private Comparator[] m_cmp;
    private int m_rev = 1;
    private int m_size = 0;

    public CompositeComparator(int n) {
        this(n, false);
    }

    public CompositeComparator(int n, boolean bl) {
        this.m_cmp = new Comparator[n];
        this.m_rev = bl ? -1 : 1;
    }

    public CompositeComparator(Comparator[] comparatorArray) {
        this(comparatorArray, false);
    }

    public CompositeComparator(Comparator[] comparatorArray, boolean bl) {
        this(comparatorArray.length, bl);
        System.arraycopy(comparatorArray, 0, this.m_cmp, 0, comparatorArray.length);
        this.m_size = comparatorArray.length;
    }

    public void add(Comparator comparator) {
        if (comparator == null) {
            return;
        }
        if (this.m_cmp.length == this.m_size) {
            Comparator[] comparatorArray = new Comparator[this.m_size + 2];
            System.arraycopy(this.m_cmp, 0, comparatorArray, 0, this.m_size);
            this.m_cmp = comparatorArray;
        }
        this.m_cmp[this.m_size++] = comparator;
    }

    public boolean remove(Comparator comparator) {
        for (int i = 0; i < this.m_size; ++i) {
            if (!((Object)this.m_cmp[i]).equals(comparator)) continue;
            System.arraycopy(this.m_cmp, i + 1, this.m_cmp, i, this.m_size - i);
            --this.m_size;
            return true;
        }
        return false;
    }

    public int compare(Object object, Object object2) {
        for (int i = 0; i < this.m_cmp.length; ++i) {
            int n = this.m_cmp[i].compare(object, object2);
            if (n == 0) continue;
            return this.m_rev * n;
        }
        return 0;
    }
}

