/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import prefuse.render.AbstractShapeRenderer;
import prefuse.visual.VisualItem;

public class ShapeRenderer
extends AbstractShapeRenderer {
    private int m_baseSize = 10;
    private Ellipse2D m_ellipse = new Ellipse2D.Double();
    private Rectangle2D m_rect = new Rectangle2D.Double();
    private GeneralPath m_path = new GeneralPath();

    public ShapeRenderer() {
    }

    public ShapeRenderer(int n) {
        this.setBaseSize(n);
    }

    public void setBaseSize(int n) {
        this.m_baseSize = n;
    }

    public int getBaseSize() {
        return this.m_baseSize;
    }

    protected Shape getRawShape(VisualItem visualItem) {
        double d;
        double d2;
        int n = visualItem.getShape();
        double d3 = visualItem.getX();
        if (Double.isNaN(d3) || Double.isInfinite(d3)) {
            d3 = 0.0;
        }
        if (Double.isNaN(d2 = visualItem.getY()) || Double.isInfinite(d2)) {
            d2 = 0.0;
        }
        if ((d = (double)this.m_baseSize * visualItem.getSize()) > 1.0) {
            d3 -= d / 2.0;
            d2 -= d / 2.0;
        }
        switch (n) {
            case -1: {
                return null;
            }
            case 0: {
                return this.rectangle(d3, d2, d, d);
            }
            case 1: {
                return this.ellipse(d3, d2, d, d);
            }
            case 5: {
                return this.triangle_up((float)d3, (float)d2, (float)d);
            }
            case 6: {
                return this.triangle_down((float)d3, (float)d2, (float)d);
            }
            case 7: {
                return this.triangle_left((float)d3, (float)d2, (float)d);
            }
            case 8: {
                return this.triangle_right((float)d3, (float)d2, (float)d);
            }
            case 3: {
                return this.cross((float)d3, (float)d2, (float)d);
            }
            case 4: {
                return this.star((float)d3, (float)d2, (float)d);
            }
            case 9: {
                return this.hexagon((float)d3, (float)d2, (float)d);
            }
            case 2: {
                return this.diamond((float)d3, (float)d2, (float)d);
            }
        }
        throw new IllegalStateException("Unknown shape type: " + n);
    }

    public Shape rectangle(double d, double d2, double d3, double d4) {
        this.m_rect.setFrame(d, d2, d3, d4);
        return this.m_rect;
    }

    public Shape ellipse(double d, double d2, double d3, double d4) {
        this.m_ellipse.setFrame(d, d2, d3, d4);
        return this.m_ellipse;
    }

    public Shape triangle_up(float f, float f2, float f3) {
        this.m_path.reset();
        this.m_path.moveTo(f, f2 + f3);
        this.m_path.lineTo(f + f3 / 2.0f, f2);
        this.m_path.lineTo(f + f3, f2 + f3);
        this.m_path.closePath();
        return this.m_path;
    }

    public Shape triangle_down(float f, float f2, float f3) {
        this.m_path.reset();
        this.m_path.moveTo(f, f2);
        this.m_path.lineTo(f + f3, f2);
        this.m_path.lineTo(f + f3 / 2.0f, f2 + f3);
        this.m_path.closePath();
        return this.m_path;
    }

    public Shape triangle_left(float f, float f2, float f3) {
        this.m_path.reset();
        this.m_path.moveTo(f + f3, f2);
        this.m_path.lineTo(f + f3, f2 + f3);
        this.m_path.lineTo(f, f2 + f3 / 2.0f);
        this.m_path.closePath();
        return this.m_path;
    }

    public Shape triangle_right(float f, float f2, float f3) {
        this.m_path.reset();
        this.m_path.moveTo(f, f2 + f3);
        this.m_path.lineTo(f + f3, f2 + f3 / 2.0f);
        this.m_path.lineTo(f, f2);
        this.m_path.closePath();
        return this.m_path;
    }

    public Shape cross(float f, float f2, float f3) {
        float f4 = 3.0f * f3 / 8.0f;
        float f5 = 5.0f * f3 / 8.0f;
        this.m_path.reset();
        this.m_path.moveTo(f + f4, f2);
        this.m_path.lineTo(f + f5, f2);
        this.m_path.lineTo(f + f5, f2 + f4);
        this.m_path.lineTo(f + f3, f2 + f4);
        this.m_path.lineTo(f + f3, f2 + f5);
        this.m_path.lineTo(f + f5, f2 + f5);
        this.m_path.lineTo(f + f5, f2 + f3);
        this.m_path.lineTo(f + f4, f2 + f3);
        this.m_path.lineTo(f + f4, f2 + f5);
        this.m_path.lineTo(f, f2 + f5);
        this.m_path.lineTo(f, f2 + f4);
        this.m_path.lineTo(f + f4, f2 + f4);
        this.m_path.closePath();
        return this.m_path;
    }

    public Shape star(float f, float f2, float f3) {
        float f4 = (float)((double)f3 / (2.0 * Math.sin(Math.toRadians(54.0))));
        float f5 = (float)((double)f3 / (2.0 * Math.tan(Math.toRadians(54.0))));
        float f6 = (float)((double)f4 * Math.sin(Math.toRadians(18.0)));
        float f7 = (float)((double)f4 * Math.cos(Math.toRadians(18.0)));
        float f8 = (float)((double)f4 / (2.0 * Math.cos(Math.toRadians(36.0))));
        float f9 = f8 * (float)Math.sin(Math.toRadians(36.0));
        float f10 = f8 * (float)Math.cos(Math.toRadians(36.0));
        this.m_path.reset();
        this.m_path.moveTo(f, f2 + f5);
        this.m_path.lineTo(f + f8, f2 + f5);
        this.m_path.lineTo(f + f3 / 2.0f, f2);
        this.m_path.lineTo(f + f3 - f8, f2 + f5);
        this.m_path.lineTo(f + f3, f2 + f5);
        this.m_path.lineTo(f + f3 - f10, f2 + f5 + f9);
        this.m_path.lineTo(f + f3 - f6, f2 + f3);
        this.m_path.lineTo(f + f3 / 2.0f, f2 + f5 + f7 - f9);
        this.m_path.lineTo(f + f6, f2 + f3);
        this.m_path.lineTo(f + f10, f2 + f5 + f9);
        this.m_path.closePath();
        return this.m_path;
    }

    public Shape hexagon(float f, float f2, float f3) {
        float f4 = f3 / 2.0f;
        this.m_path.reset();
        this.m_path.moveTo(f, f2 + 0.5f * f3);
        this.m_path.lineTo(f + 0.5f * f4, f2);
        this.m_path.lineTo(f + 1.5f * f4, f2);
        this.m_path.lineTo(f + 2.0f * f4, f2 + 0.5f * f3);
        this.m_path.lineTo(f + 1.5f * f4, f2 + f3);
        this.m_path.lineTo(f + 0.5f * f4, f2 + f3);
        this.m_path.closePath();
        return this.m_path;
    }

    public Shape diamond(float f, float f2, float f3) {
        this.m_path.reset();
        this.m_path.moveTo(f, f2 + 0.5f * f3);
        this.m_path.lineTo(f + 0.5f * f3, f2);
        this.m_path.lineTo(f + f3, f2 + 0.5f * f3);
        this.m_path.lineTo(f + 0.5f * f3, f2 + f3);
        this.m_path.closePath();
        return this.m_path;
    }
}

