/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.tuple;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.Expression;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.data.tuple.AbstractTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.util.collections.CompositeIterator;

public class CompositeTupleSet
extends AbstractTupleSet {
    private static final Logger s_logger = Logger.getLogger(CompositeTupleSet.class.getName());
    private Map m_map = new LinkedHashMap();
    private Set m_sets = new HashSet();
    private int m_count = 0;
    private Listener m_lstnr;

    public CompositeTupleSet() {
        this(true);
    }

    protected CompositeTupleSet(boolean bl) {
        this.m_lstnr = bl ? new Listener() : null;
    }

    public void addSet(String string, TupleSet tupleSet) {
        if (this.hasSet(string)) {
            throw new IllegalArgumentException("Name already in use: " + string);
        }
        this.m_map.put(string, tupleSet);
        this.m_sets.add(tupleSet);
        this.m_count += tupleSet.getTupleCount();
        if (this.m_lstnr != null) {
            tupleSet.addTupleSetListener(this.m_lstnr);
        }
    }

    public boolean hasSet(String string) {
        return this.m_map.containsKey(string);
    }

    public boolean containsSet(TupleSet tupleSet) {
        return this.m_sets.contains(tupleSet);
    }

    public TupleSet getSet(String string) {
        return (TupleSet)this.m_map.get(string);
    }

    public Iterator setNames() {
        return this.m_map.keySet().iterator();
    }

    public Iterator sets() {
        return this.m_map.values().iterator();
    }

    public TupleSet removeSet(String string) {
        TupleSet tupleSet = (TupleSet)this.m_map.remove(string);
        if (tupleSet != null) {
            this.m_sets.remove(tupleSet);
            if (this.m_lstnr != null) {
                tupleSet.removeTupleSetListener(this.m_lstnr);
            }
        }
        return tupleSet;
    }

    public void removeAllSets() {
        Iterator iterator = this.m_map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TupleSet tupleSet = (TupleSet)entry.getValue();
            iterator.remove();
            this.m_sets.remove(tupleSet);
            if (this.m_lstnr == null) continue;
            tupleSet.removeTupleSetListener(this.m_lstnr);
        }
        this.m_count = 0;
    }

    public void clear() {
        for (Map.Entry entry : this.m_map.entrySet()) {
            ((TupleSet)entry.getValue()).clear();
        }
        this.m_count = 0;
    }

    public Tuple addTuple(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    public Tuple setTuple(Tuple tuple) {
        throw new UnsupportedOperationException();
    }

    public boolean removeTuple(Tuple tuple) {
        Table table = tuple.getTable();
        if (this.m_sets.contains(table)) {
            return table.removeTuple(tuple);
        }
        return false;
    }

    public boolean containsTuple(Tuple tuple) {
        for (Map.Entry entry : this.m_map.entrySet()) {
            TupleSet tupleSet = (TupleSet)entry.getValue();
            if (!tupleSet.containsTuple(tuple)) continue;
            return true;
        }
        return false;
    }

    public int getTupleCount() {
        if (this.m_lstnr != null) {
            return this.m_count;
        }
        int n = 0;
        Iterator iterator = this.m_map.entrySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TupleSet tupleSet = (TupleSet)entry.getValue();
            n += tupleSet.getTupleCount();
            ++n2;
        }
        return n;
    }

    public Iterator tuples() {
        CompositeIterator compositeIterator = new CompositeIterator(this.m_map.size());
        Iterator iterator = this.m_map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TupleSet tupleSet = (TupleSet)entry.getValue();
            compositeIterator.setIterator(n, tupleSet.tuples());
            ++n;
        }
        return compositeIterator;
    }

    public Iterator tuples(Predicate predicate) {
        CompositeIterator compositeIterator = new CompositeIterator(this.m_map.size());
        Iterator iterator = this.m_map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            TupleSet tupleSet = (TupleSet)entry.getValue();
            compositeIterator.setIterator(n, tupleSet.tuples(predicate));
            ++n;
        }
        return compositeIterator;
    }

    public boolean isAddColumnSupported() {
        return true;
    }

    public void addColumn(String string, Class clazz, Object object) {
        for (Map.Entry entry : this.m_map.entrySet()) {
            TupleSet tupleSet = (TupleSet)entry.getValue();
            if (tupleSet.isAddColumnSupported()) {
                try {
                    tupleSet.addColumn(string, clazz, object);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            s_logger.fine("Skipped addColumn for " + entry.getKey());
        }
    }

    public void addColumn(String string, Class clazz) {
        for (Map.Entry entry : this.m_map.entrySet()) {
            TupleSet tupleSet = (TupleSet)entry.getValue();
            if (tupleSet.isAddColumnSupported()) {
                try {
                    tupleSet.addColumn(string, clazz);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            s_logger.fine("Skipped addColumn for " + entry.getKey());
        }
    }

    public void addColumn(String string, Expression expression) {
        for (Map.Entry entry : this.m_map.entrySet()) {
            TupleSet tupleSet = (TupleSet)entry.getValue();
            if (tupleSet.isAddColumnSupported()) {
                try {
                    tupleSet.addColumn(string, expression);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            s_logger.fine("Skipped addColumn for " + entry.getKey());
        }
    }

    public void addColumn(String string, String string2) {
        Expression expression = ExpressionParser.parse(string2);
        Throwable throwable = ExpressionParser.getError();
        if (throwable != null) {
            throw new RuntimeException(throwable);
        }
        this.addColumn(string, expression);
    }

    private class Listener
    implements TupleSetListener {
        private Listener() {
        }

        public void tupleSetChanged(TupleSet tupleSet, Tuple[] tupleArray, Tuple[] tupleArray2) {
            CompositeTupleSet.this.m_count += tupleArray.length - tupleArray2.length;
            CompositeTupleSet.this.fireTupleEvent(tupleArray, tupleArray2);
        }
    }
}

